/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Random;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import sun.misc.BASE64Encoder;

public class CertificateUtils {
    public static final void addToKeyStore(File file, KeyStore ks) throws CertificateException, IOException, KeyStoreException {
        if (JNLPRuntime.isDebug()) {
            System.out.println("Importing certificate from " + file + " into " + ks);
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)cf.generateCertificate(bis);
        }
        catch (ClassCastException cce) {
            throw new CertificateException("Input file is not an X509 Certificate", cce);
        }
        CertificateUtils.addToKeyStore(cert, ks);
    }

    public static final void addToKeyStore(X509Certificate cert, KeyStore ks) throws KeyStoreException {
        if (JNLPRuntime.isDebug()) {
            System.out.println("Importing " + cert.getSubjectX500Principal().getName());
        }
        String alias = null;
        alias = ks.getCertificateAlias(cert);
        if (alias != null) {
            return;
        }
        Random random = new Random();
        while (ks.getCertificate(alias = new BigInteger(20, random).toString()) != null) {
        }
        ks.setCertificateEntry(alias, cert);
    }

    public static final boolean inKeyStores(X509Certificate c, KeyStore[] keyStores) {
        for (int i = 0; i < keyStores.length; ++i) {
            try {
                if (keyStores[i].getCertificateAlias(c) == null) continue;
                if (JNLPRuntime.isDebug()) {
                    System.out.println(c.getSubjectX500Principal().getName() + " found in cacerts");
                }
                return true;
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void dump(Certificate cert, PrintStream out) throws IOException, CertificateException {
        BASE64Encoder encoder = new BASE64Encoder();
        out.println("-----BEGIN CERTIFICATE-----");
        encoder.encodeBuffer(cert.getEncoded(), (OutputStream)out);
        out.println("-----END CERTIFICATE-----");
    }
}

