/*
 * Decompiled with CFR 0.152.
 */
package hr.fjagic.jdosage2;

import hr.fjagic.jdosage2.Configuration;
import hr.fjagic.jdosage2.webcomic.ScraperWebcomic;
import hr.fjagic.jdosage2.webcomic.ValidationException;
import hr.fjagic.jdosage2.webcomic.Webcomic;
import hr.fjagic.jdosage2.webcomic.WebcomicException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcomicManager {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final Logger logger = LoggerFactory.getLogger(WebcomicManager.class);
    private Configuration config;
    private Properties progress;
    private Webcomic currentWebcomic;
    private int currentCounter = -1;

    public WebcomicManager(Configuration config) {
        this.config = config;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (WebcomicManager.this.currentWebcomic != null) {
                    if (WebcomicManager.this.currentCounter >= 0) {
                        logger.info("{}: {} comic pages downloaded, stopped by user", (Object)WebcomicManager.this.currentWebcomic.getName(), (Object)WebcomicManager.this.currentCounter);
                    }
                    WebcomicManager.this.updateProgress(WebcomicManager.this.currentWebcomic);
                }
                WebcomicManager.this.saveProgress();
            }
        }));
    }

    public Collection<Webcomic> getWebcomics(String[] wildcards) {
        if (!this.config.getDefinitionsDir().exists()) {
            logger.warn("Webcomic definitions directory {} doesn't exist", (Object)this.config.getDefinitionsDir());
            return Collections.emptyList();
        }
        HashSet<File> definitions = new HashSet<File>();
        String[] stringArray = wildcards;
        int n = wildcards.length;
        int n2 = 0;
        while (n2 < n) {
            String wildcard = stringArray[n2];
            definitions.addAll(FileUtils.listFiles(this.config.getDefinitionsDir(), new WebcomicFilter(wildcard), TrueFileFilter.INSTANCE));
            ++n2;
        }
        if (definitions.isEmpty()) {
            logger.info("No webcomic definition files match wildcards {}", (Object)wildcards);
            return Collections.emptyList();
        }
        ArrayList<Webcomic> webcomics = new ArrayList<Webcomic>(definitions.size());
        for (File definition : definitions) {
            try {
                Webcomic webcomic = this.loadWebcomic(definition);
                webcomics.add(webcomic);
            }
            catch (IOException e) {
                logger.error("Error reading webcomic definition file " + definition.getName(), (Throwable)e);
            }
            catch (ValidationException e) {
                logger.error("Webcomic definition file " + definition.getName() + " is invalid", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Error loading webcomic definition file " + definition.getName(), (Throwable)e);
            }
        }
        return webcomics;
    }

    private Webcomic loadWebcomic(File definition) throws IOException, ValidationException {
        logger.trace("Loading webcomic definition file {}", (Object)definition);
        ScraperWebcomic webcomic = new ScraperWebcomic();
        FileReader reader = new FileReader(definition);
        webcomic.load(reader);
        IOUtils.closeQuietly(reader);
        webcomic.validate();
        String prefix = this.getProgressPrefix(webcomic);
        for (Map.Entry<Object, Object> entry : this.getProgress().entrySet()) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            String key = ((String)entry.getKey()).substring(prefix.length());
            String value = (String)entry.getValue();
            webcomic.getProgress().put(key, value);
        }
        logger.debug("Loaded {}, progress: {}", (Object)webcomic.getName(), webcomic.getProgress());
        return webcomic;
    }

    private String getProgressPrefix(Webcomic webcomic) {
        return String.valueOf(webcomic.getName().replaceAll("\\s+", "_")) + ".";
    }

    public void downloadComics(Collection<Webcomic> webcomics) {
        for (Webcomic webcomic : webcomics) {
            this.downloadComics(webcomic);
        }
    }

    /*
     * Loose catch block
     */
    private void downloadComics(Webcomic webcomic) {
        logger.info("Downloading {} to {}", (Object)webcomic.getName(), (Object)this.config.getDownloadDir());
        this.currentWebcomic = webcomic;
        this.currentCounter = 0;
        try {
            try {
                do {
                    ++this.currentCounter;
                    logger.trace(StringUtils.repeat((char)'*', (int)60));
                } while (webcomic.downloadNext(this.config));
                logger.info("{}: {} comic pages downloaded", (Object)webcomic.getName(), (Object)this.currentCounter);
            }
            catch (IOException e) {
                logger.warn(String.valueOf(webcomic.getName()) + ": " + this.currentCounter + " comic pages downloaded, finished with error", (Throwable)e);
                this.currentCounter = -1;
                this.updateProgress(this.currentWebcomic);
                this.currentWebcomic = null;
                logger.info(StringUtils.repeat((char)'-', (int)60));
            }
            catch (WebcomicException e) {
                logger.warn(String.valueOf(webcomic.getName()) + ": " + this.currentCounter + " comic pages downloaded, finished with error", (Throwable)e);
                this.currentCounter = -1;
                this.updateProgress(this.currentWebcomic);
                this.currentWebcomic = null;
                logger.info(StringUtils.repeat((char)'-', (int)60));
            }
            catch (Exception e) {
                logger.warn(String.valueOf(webcomic.getName()) + ": " + this.currentCounter + " comic pages downloaded, finished with error", (Throwable)e);
                this.currentCounter = -1;
                this.updateProgress(this.currentWebcomic);
                this.currentWebcomic = null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                logger.info(StringUtils.repeat((char)'-', (int)60));
            }
        }
        finally {
            this.currentCounter = -1;
            this.updateProgress(this.currentWebcomic);
            this.currentWebcomic = null;
            logger.info(StringUtils.repeat((char)'-', (int)60));
        }
    }

    private Properties getProgress() {
        if (this.progress == null) {
            this.progress = new Properties();
            if (this.config.getProgressFile().exists()) {
                try {
                    FileReader reader = new FileReader(this.config.getProgressFile());
                    this.progress.load(reader);
                    IOUtils.closeQuietly(reader);
                }
                catch (IOException e) {
                    logger.error("Error reading progress file");
                }
                catch (Exception e) {
                    logger.error("Error loading progress data");
                }
            }
        }
        return this.progress;
    }

    private void updateProgress(Webcomic webcomic) {
        String prefix = this.getProgressPrefix(webcomic);
        Iterator<Map.Entry<Object, Object>> it = this.getProgress().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            logger.trace("Progress entry {} removed ", entry);
            it.remove();
        }
        for (Map.Entry<String, String> entry : webcomic.getProgress().entrySet()) {
            logger.trace("Progress entry {}={} added", (Object)(String.valueOf(prefix) + entry.getKey()), (Object)entry.getValue());
            this.getProgress().setProperty(String.valueOf(prefix) + entry.getKey(), entry.getValue());
        }
    }

    private void saveProgress() {
        try {
            this.config.getProgressFile().getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.config.getProgressFile());
            this.getProgress().store(writer, "JDosage2 download progress");
            IOUtils.closeQuietly(writer);
            logger.trace("Progress saved to {}: {}", (Object)this.config.getProgressFile(), (Object)this.getProgress());
        }
        catch (IOException e) {
            logger.error("Error writing progress file", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Error saving progress", (Throwable)e);
        }
    }

    private class WebcomicFilter
    implements IOFileFilter {
        private String fileWildcard;
        private String dirWildcard;

        public WebcomicFilter(String webcomicExp) {
            String normalizedExp = FilenameUtils.normalize(webcomicExp);
            this.fileWildcard = String.valueOf(StringUtils.substring((String)normalizedExp, (int)Math.max(normalizedExp.indexOf(FILE_SEPARATOR) + 1, 0))) + FilenameUtils.EXTENSION_SEPARATOR_STR + WebcomicManager.this.config.getDefinitionExt();
            String dirPart = StringUtils.substring((String)normalizedExp, (int)0, (int)Math.max(normalizedExp.indexOf(FILE_SEPARATOR), 0));
            this.dirWildcard = FilenameUtils.normalizeNoEndSeparator(WebcomicManager.this.config.getDefinitionsDir() + FILE_SEPARATOR + dirPart);
        }

        @Override
        public boolean accept(File dir, String name) {
            return FilenameUtils.wildcardMatch(FilenameUtils.normalizeNoEndSeparator(dir.getPath()), this.dirWildcard, IOCase.INSENSITIVE) && FilenameUtils.wildcardMatch(name, this.fileWildcard, IOCase.INSENSITIVE);
        }

        @Override
        public boolean accept(File file) {
            return FilenameUtils.wildcardMatch(FilenameUtils.normalizeNoEndSeparator(file.getParent()), this.dirWildcard, IOCase.INSENSITIVE) && FilenameUtils.wildcardMatch(file.getName(), this.fileWildcard, IOCase.INSENSITIVE);
        }
    }
}

