/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import jedecma.EcoEdit;
import jedecma.EcoImg;
import jedecma.ImgViewer;
import jedecma.Jedecma;
import jedecma.Uti1;

public class FileMgr
extends JPanel {
    private static final long serialVersionUID = 1L;
    int nrexam;
    private FileTableModel model;
    private JTable table;
    private JButton selBut;
    private JButton newBut;
    private JButton delBut;
    private ArrayList<String> fileNames = new ArrayList();
    private EcoEdit parent;
    private JFileChooser fc = new JFileChooser();
    final int COL_FILE = 0;
    final int COL_OP = 1;
    final int COL_NOTE = 2;
    final int NOTE_SIZE = 128;

    public FileMgr(int nr, EcoEdit p) {
        this.parent = p;
        this.nrexam = nr;
        this.setGui();
    }

    private void setGui() {
        this.model = new FileTableModel();
        this.table = new JTable(this.model);
        this.model.addColumn("");
        this.model.addColumn("Op");
        this.model.addColumn(Jedecma.localMessagesBundle.getString("IMG_COL_LABEL"));
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(1);
        column.setMaxWidth(25);
        column = this.table.getColumnModel().getColumn(2);
        column.setCellEditor(new NoteEditor());
        column = this.table.getColumnModel().getColumn(0);
        column.setMinWidth(0);
        column.setMaxWidth(0);
        column.setPreferredWidth(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        SelectionListener listener = new SelectionListener(this.table);
        this.table.getSelectionModel().addListSelectionListener(listener);
        this.table.addMouseListener(new mouseSelListener());
        GridBagLayout gbMPan = new GridBagLayout();
        GridBagConstraints gbcMPan = new GridBagConstraints();
        this.setLayout(gbMPan);
        JScrollPane fileScrollPan = new JScrollPane(this.table);
        Uti1.bldConst(gbcMPan, 1, 0, 10, 10, 1, 1, 11, 1);
        gbMPan.setConstraints(fileScrollPan, gbcMPan);
        this.add(fileScrollPan);
        this.selBut = new JButton();
        this.selBut = new JButton(Jedecma.localMessagesBundle.getString("DSP_IMG"));
        this.selBut.setMnemonic(68);
        this.selBut.addActionListener(new SelListener());
        Uti1.bldConst(gbcMPan, 0, 0, 1, 1, 0, 0);
        gbMPan.setConstraints(this.selBut, gbcMPan);
        this.add(this.selBut);
        this.newBut = new JButton();
        this.newBut = new JButton(Jedecma.localMessagesBundle.getString("NEW_IMG"));
        this.newBut.setMnemonic(73);
        this.newBut.addActionListener(new NewListener());
        Uti1.bldConst(gbcMPan, 0, 1, 1, 1, 0, 0);
        gbMPan.setConstraints(this.newBut, gbcMPan);
        this.add(this.newBut);
        this.delBut = new JButton();
        this.delBut = new JButton(Jedecma.localMessagesBundle.getString("DEL_IMG"));
        this.delBut.setMnemonic(73);
        this.delBut.addActionListener(new DelListener());
        Uti1.bldConst(gbcMPan, 0, 2, 1, 1, 0, 0);
        gbMPan.setConstraints(this.delBut, gbcMPan);
        this.add(this.delBut);
        this.delBut.setEnabled(false);
        this.selBut.setEnabled(false);
        if (!Jedecma.ak.isEnableWrite() || this.parent.readOnly || this.parent.busy) {
            this.newBut.setEnabled(false);
        }
        this.clearTable();
    }

    void clearTable() {
        int rows = this.table.getRowCount();
        int r = 0;
        while (r < rows) {
            try {
                this.model.removeRow(0);
            }
            catch (ArrayIndexOutOfBoundsException x) {
                System.out.println("clearTable(): ArrayIndexOutOfBoundsException indice di riga:" + r);
            }
            ++r;
        }
    }

    public int getTableSize() {
        return this.table.getRowCount();
    }

    void storeFiles() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int rows = FileMgr.this.table.getRowCount();
                int r = 0;
                while (r < rows) {
                    EcoImg img;
                    String fileBaseName;
                    String op = (String)FileMgr.this.table.getModel().getValueAt(r, 1);
                    if (op.equals("C")) {
                        EcoImg img2;
                        String note;
                        fileBaseName = (String)FileMgr.this.table.getModel().getValueAt(r, 0);
                        String srcFile = String.valueOf(FileMgr.this.getTmpPath()) + System.getProperty("file.separator") + fileBaseName;
                        String newFile = String.valueOf(FileMgr.this.getFolder()) + System.getProperty("file.separator") + fileBaseName;
                        File folder = new File(FileMgr.this.getFolder());
                        if (!folder.exists()) {
                            try {
                                System.out.println("creating folder " + folder.getName());
                                folder.mkdirs();
                            }
                            catch (SecurityException se) {
                                System.out.println("Security exception creating folder " + folder);
                            }
                        }
                        if (folder.exists()) {
                            FileMgr.this.copyFile(srcFile, newFile);
                            System.out.println("copy from " + srcFile + " to " + newFile);
                        }
                        if ((note = (String)FileMgr.this.table.getModel().getValueAt(r, 2)).equals("")) {
                            note = fileBaseName;
                        }
                        if ((img2 = FileMgr.this.findEcoImg(FileMgr.this.nrexam, fileBaseName)).getExamnr() == FileMgr.this.nrexam) {
                            if (!img2.getNote().equals(note)) {
                                img2.setNote(note);
                                img2.writeEcoImg(img2.getId());
                            }
                        } else {
                            img2.setBasename(fileBaseName);
                            img2.setNote(note);
                            img2.setExamnr(FileMgr.this.nrexam);
                            img2.writeEcoImg(0);
                        }
                    }
                    if (op.equals("D")) {
                        EcoImg img3;
                        fileBaseName = (String)FileMgr.this.table.getModel().getValueAt(r, 0);
                        String fileToDel = String.valueOf(FileMgr.this.getFolder()) + System.getProperty("file.separator") + fileBaseName;
                        File fn = new File(fileToDel);
                        if (fn.exists()) {
                            try {
                                fn.delete();
                                System.out.println("deleting file " + fileBaseName);
                            }
                            catch (SecurityException se) {
                                System.out.println("cannot delete file " + fileBaseName);
                            }
                        }
                        if ((img3 = FileMgr.this.findEcoImg(FileMgr.this.nrexam, fileBaseName)).getExamnr() == FileMgr.this.nrexam) {
                            img3.deleteEcoImg();
                        }
                    }
                    if (op.equals("") && (img = FileMgr.this.findEcoImg(FileMgr.this.nrexam, fileBaseName = (String)FileMgr.this.table.getModel().getValueAt(r, 0))).getExamnr() == FileMgr.this.nrexam) {
                        String note = (String)FileMgr.this.table.getModel().getValueAt(r, 2);
                        if (!img.getNote().equals(note)) {
                            img.setNote(note);
                            img.writeEcoImg(img.getId());
                        }
                    }
                    ++r;
                }
            }
        });
    }

    void loadTable() {
        this.clearTable();
        File path = new File(this.getFolder());
        if (path.exists()) {
            this.fileNames = this.readFolder(path);
            for (String item : this.fileNames) {
                String extension = Uti1.getExtension(new File(item));
                if (!(extension = extension.toLowerCase()).equals("jpg") && !extension.equals("png") && !extension.equals("bmp")) continue;
                Vector<String> nextRow = new Vector<String>();
                nextRow.addElement(item);
                nextRow.addElement("");
                EcoImg img = this.findEcoImg(this.nrexam, item);
                String note = item;
                if (img.getExamnr() == this.nrexam) {
                    note = img.getNote();
                }
                nextRow.addElement(note);
                this.model.addRow(nextRow);
            }
        }
    }

    private EcoImg findEcoImg(int nr, String bn) {
        EcoImg img = new EcoImg();
        img.readEcoImg(nr, bn);
        return img;
    }

    private String getFolder() {
        EcoImg tmpImg = new EcoImg();
        tmpImg.setExamnr(this.nrexam);
        return tmpImg.getFolder();
    }

    private String getTmpPath() {
        return Jedecma.param.getProperty("imgtmp");
    }

    private ArrayList<String> readFolder(File fld) {
        ArrayList<String> fn = new ArrayList<String>(Arrays.asList(fld.list()));
        System.out.println(String.valueOf(fn.size()) + " files in folder");
        return fn;
    }

    private int copyFile(String sr, String dt) {
        try {
            int len;
            File f1 = new File(sr);
            File f2 = new File(dt);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException ex) {
            System.out.println(String.valueOf(ex.getMessage()) + " in the specified directory.");
            return 1;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return 2;
        }
        return 0;
    }

    class DelListener
    implements ActionListener {
        DelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rows = FileMgr.this.table.getRowCount();
            int r = FileMgr.this.table.getSelectedRow();
            int c = FileMgr.this.table.getSelectedColumn();
            if (rows > 0 && r != -1) {
                FileMgr.this.delBut.setEnabled(false);
                FileMgr.this.selBut.setEnabled(false);
                FileMgr.this.newBut.setEnabled(false);
                String op = (String)FileMgr.this.table.getModel().getValueAt(r, 1);
                if (op.equals("")) {
                    FileMgr.this.table.getModel().setValueAt("D", r, 1);
                } else if (op.equals("D")) {
                    FileMgr.this.table.getModel().setValueAt("", r, 1);
                } else if (op.equals("C")) {
                    FileMgr.this.model.removeRow(r);
                }
                if (Jedecma.ak.isEnableWrite() && !((FileMgr)FileMgr.this).parent.readOnly && !((FileMgr)FileMgr.this).parent.busy) {
                    FileMgr.this.newBut.setEnabled(true);
                }
            }
            FileMgr.this.table.clearSelection();
        }
    }

    public class FileTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2 && Jedecma.ak.isEnableWrite() && !((FileMgr)FileMgr.this).parent.readOnly && !((FileMgr)FileMgr.this).parent.busy;
        }
    }

    class MyFileFilter
    extends FileFilter {
        MyFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = Uti1.getExtension(f);
            if (extension != null) {
                return (extension = extension.toLowerCase()).equals("jpg") || extension.equals("png") || extension.equals("bmp");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "images";
        }
    }

    class NewListener
    implements ActionListener {
        NewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileMgr.this.delBut.setEnabled(false);
            FileMgr.this.newBut.setEnabled(false);
            FileMgr.this.selBut.setEnabled(false);
            System.out.println("New button selected ");
            FileMgr.this.fc.addChoosableFileFilter(new MyFileFilter());
            FileMgr.this.fc.setCurrentDirectory(new File(FileMgr.this.getTmpPath()));
            FileMgr.this.fc.setMultiSelectionEnabled(true);
            int returnVal = FileMgr.this.fc.showOpenDialog(null);
            if (returnVal == 0) {
                final File[] fileArray = FileMgr.this.fc.getSelectedFiles();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int fi = 0;
                        while (fi < fileArray.length) {
                            String item = fileArray[fi].getName();
                            Vector<String> nextRow = new Vector<String>();
                            nextRow.addElement(item);
                            nextRow.addElement("C");
                            String note = item;
                            EcoImg img = FileMgr.this.findEcoImg(((NewListener)NewListener.this).FileMgr.this.nrexam, item);
                            if (img.getExamnr() == ((NewListener)NewListener.this).FileMgr.this.nrexam) {
                                note = img.getNote();
                            }
                            nextRow.addElement(note);
                            FileMgr.this.model.addRow(nextRow);
                            System.out.println("addRow " + fileArray[fi].getAbsolutePath());
                            ++fi;
                        }
                    }
                });
            }
            if (Jedecma.ak.isEnableWrite() && !((FileMgr)FileMgr.this).parent.readOnly && !((FileMgr)FileMgr.this).parent.busy) {
                FileMgr.this.newBut.setEnabled(true);
            }
            FileMgr.this.table.clearSelection();
        }
    }

    public class NoteEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JComponent component = new JTextField();

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            ((JTextField)this.component).setText((String)value);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            String text = ((JTextField)this.component).getText();
            if (text.length() > 128) {
                text = text.substring(0, 128);
            }
            return text.trim();
        }
    }

    class SelListener
    implements ActionListener {
        SelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileMgr.this.delBut.setEnabled(false);
            FileMgr.this.newBut.setEnabled(false);
            FileMgr.this.selBut.setEnabled(false);
            int rows = FileMgr.this.table.getRowCount();
            int r = FileMgr.this.table.getSelectedRow();
            int c = FileMgr.this.table.getSelectedColumn();
            if (FileMgr.this.table.getRowSelectionAllowed() && rows > 0 && r != -1) {
                String fn = "";
                fn = ((String)FileMgr.this.table.getModel().getValueAt(r, 1)).equals("C") ? String.valueOf(FileMgr.this.getTmpPath()) + System.getProperty("file.separator") + (String)FileMgr.this.table.getModel().getValueAt(r, 0) : String.valueOf(FileMgr.this.getFolder()) + System.getProperty("file.separator") + (String)FileMgr.this.table.getModel().getValueAt(r, 0);
                System.out.println("File (button) selected " + fn);
                final String file = fn;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new ImgViewer(file, FileMgr.this.parent);
                    }
                });
            }
            if (Jedecma.ak.isEnableWrite() && !((FileMgr)FileMgr.this).parent.readOnly && !((FileMgr)FileMgr.this).parent.busy) {
                FileMgr.this.newBut.setEnabled(true);
            }
            FileMgr.this.table.clearSelection();
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int rows = this.table.getRowCount();
            int r = this.table.getSelectedRow();
            int c = this.table.getSelectedColumn();
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                int first = e.getFirstIndex();
                int last = e.getLastIndex();
                if (rows > 0 && r != -1 && !e.getValueIsAdjusting()) {
                    System.out.println("Row selected " + r);
                    FileMgr.this.delBut.setEnabled(true);
                    FileMgr.this.selBut.setEnabled(true);
                    if (!Jedecma.ak.isEnableWrite() || ((FileMgr)FileMgr.this).parent.readOnly || ((FileMgr)FileMgr.this).parent.busy) {
                        FileMgr.this.delBut.setEnabled(false);
                    }
                }
            } else if (e.getSource() == this.table.getColumnModel().getSelectionModel() && this.table.getColumnSelectionAllowed()) {
                int first = e.getFirstIndex();
                int n = e.getLastIndex();
            }
        }
    }

    public class mouseSelListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                FileMgr.this.delBut.setEnabled(false);
                FileMgr.this.newBut.setEnabled(false);
                FileMgr.this.selBut.setEnabled(false);
                int rows = FileMgr.this.table.getRowCount();
                int r = FileMgr.this.table.getSelectedRow();
                int c = FileMgr.this.table.getSelectedColumn();
                if (FileMgr.this.table.getRowSelectionAllowed() && rows > 0 && r != -1) {
                    String fn = "";
                    fn = ((String)FileMgr.this.table.getModel().getValueAt(r, 1)).equals("C") ? String.valueOf(FileMgr.this.getTmpPath()) + System.getProperty("file.separator") + (String)FileMgr.this.table.getModel().getValueAt(r, 0) : String.valueOf(FileMgr.this.getFolder()) + System.getProperty("file.separator") + (String)FileMgr.this.table.getModel().getValueAt(r, 0);
                    System.out.println("File (mouse) selected " + fn);
                    final String file = fn;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new ImgViewer(file, FileMgr.this.parent);
                        }
                    });
                }
                if (Jedecma.ak.isEnableWrite() && !((FileMgr)FileMgr.this).parent.readOnly && !((FileMgr)FileMgr.this).parent.busy) {
                    FileMgr.this.newBut.setEnabled(true);
                }
                FileMgr.this.table.clearSelection();
            }
        }
    }
}

