/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.Set;

public class Territorio
implements Comparable {
    private String nome;
    private int armate;
    private Set territoriConfinanti;
    private String continente;
    private static final int MIN_ARMATE = 1;

    public Territorio(String nome, int armate) {
        this.nome = nome;
        this.armate = armate < 1 ? 1 : armate;
        this.territoriConfinanti = new HashSet();
    }

    public String getNome() {
        return this.nome;
    }

    public int getArmate() {
        return this.armate;
    }

    public String getContinente() {
        return this.continente;
    }

    public Set getTerritoriConfinanti() {
        return this.territoriConfinanti;
    }

    public void setArmate(int n) {
        this.armate = n;
    }

    public boolean setContinente(String nome) {
        if (ElencoTerritoriContinenti.continenteValido(nome)) {
            this.continente = nome;
            return true;
        }
        return false;
    }

    public void setConfinante(Territorio t) {
        this.territoriConfinanti.add(t);
    }

    public void setConfinanti(Set confinanti) {
        this.territoriConfinanti = confinanti;
    }

    public boolean confinaCon(Territorio t) {
        return this.territoriConfinanti.contains(t);
    }

    public boolean muovi(int n, Territorio destinazione) {
        if (!this.isVuoto() && this.territoriConfinanti.contains(destinazione)) {
            if (n >= 0 && n < this.armate) {
                this.armate -= n;
                destinazione.setArmate(destinazione.getArmate() + n);
            } else {
                destinazione.setArmate(destinazione.getArmate() + this.armate - 1);
                this.armate = 1;
            }
            return true;
        }
        return false;
    }

    public boolean puoAttaccare() {
        return this.armate > 1;
    }

    public boolean puoAttaccare(int n) {
        return n > 0 && n < 4 && this.armate >= n;
    }

    public int maxDadiAttacco() {
        if (this.puoAttaccare()) {
            if (this.armate < 4) {
                return this.armate;
            }
            return 3;
        }
        return 0;
    }

    public int maxDadiDifesa() {
        return this.armate >= 3 ? 3 : this.armate;
    }

    public boolean isVuoto() {
        return this.armate < 1;
    }

    public static int getMinimoArmate() {
        return 1;
    }

    public int hashCode() {
        return this.nome.hashCode() + this.continente.hashCode();
    }

    public int compareTo(Object ob) {
        Territorio altroTerritorio = (Territorio)ob;
        if (this.hashCode() < altroTerritorio.hashCode()) {
            return -1;
        }
        if (this.hashCode() > altroTerritorio.hashCode()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.nome) + " (" + this.continente + ")";
    }
}

