/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 15-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */

/**
 * Contiene l'elenco dei comandi validi.
 * 
 * @author Alessio Treglia
 * @version 1.0.0
 */
public class ElencoComandi {
    /** un array costante con tutti i comandi validi */
    private static final String comandiValidi[] = {
        "attacca",
        "sposta",
        "passa",
        "stampa",
        "esci",
        "aiuto",
        "versione"
    };
    
    /**
     * Restituisce una stringa contenente l'elenco
     * dei comandi accettabili
     * 
     * @return l'elenco dei comandi validi in formato
     * <code>String</code>
     */
    public static String elencoTuttiComandi(){
    	int i=0;
    	StringBuffer elenco = new StringBuffer();

    	for (i=0; i<comandiValidi.length-1; i++) {
			elenco.append(comandiValidi[i]);
			elenco. append(", ");
		}
		elenco.append(comandiValidi[i]);
		return elenco.toString();
    }


    /**
     * Controlla che una stringa sia un comando
     * accettabile.
     * 
     * @param stringa <code>String</code> da controllare
     * @return <code>true</code> se  un comando accettabile
     */
    public boolean comandoValido(String stringa) {
        for(int i = 0; i < comandiValidi.length; i++) {
            if(comandiValidi[i].equals(stringa))
                return true;
        }
        return false;
    }
}
