/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public class ComandoSposta
extends Comando {
    private final String nomeComando = "sposta";
    private String partenza;
    private String destinazione;

    public ComandoSposta(String da, String a) {
        this.partenza = da;
        this.destinazione = a;
    }

    public String getNomeComando() {
        return this.nomeComando;
    }

    public boolean esegui(Giocatore giocatore, Tabellone planisfero) throws IOException {
        if (!ElencoTerritoriContinenti.territorioValido(this.partenza) || !ElencoTerritoriContinenti.territorioValido(this.destinazione)) {
            return new ComandoNonValido().esegui(giocatore, planisfero);
        }
        Giocatore g1 = planisfero.getGiocatoreAt(this.partenza);
        Giocatore g2 = planisfero.getGiocatoreAt(this.destinazione);
        if (giocatore == g1 && giocatore == g2) {
            Territorio a;
            Territorio da = giocatore.getTerritorio(this.partenza);
            if (da.confinaCon(a = giocatore.getTerritorio(this.destinazione))) {
                giocatore.schermo.stampa("Quante armate vuoi spostare da " + da.getNome() + " a " + a.getNome() + "?");
                int n = -1;
                while (n == -1) {
                    n = giocatore.parser.getInt();
                    if (n == 0) {
                        return false;
                    }
                    if (!da.muovi(n, a)) {
                        giocatore.schermo.stampa("Digita un numero corretto, 0 per annullare: ");
                        n = -1;
                        continue;
                    }
                    g1.schermo.stampaln("Spostamento da " + this.partenza + " a " + this.destinazione + " effettuato.");
                    return true;
                }
            } else {
                g1.schermo.stampaln("Non puoi spostare armate fra territori non confinanti!");
            }
        } else {
            g1.schermo.stampaln("Puoi spostare le armate solo fra territori confinanti e di tua appartenenza.");
        }
        return false;
    }
}

