<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_overview extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','overview');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  require_once(XF::vault_query('root_path').'/class.parser.php');
  $setasread = XF::sanitize_var(XF::ifset('get','read',0),'booli');
  $showlegal = XF::sanitize_var(XF::ifset('get','legal',0),'booli');
  $this->gpc = array('setasread'=>$setasread,'showlegal'=>$showlegal);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('overview'));
  unset($setasread,$showlegal);
    if ( (bool)$this->gpc['setasread'] ){ // mark all postings as read
      if ( isset($_SESSION['xf_read_tracker']) ){
      $_SESSION['xf_read_tracker']['global'] = XF::vault_query('uts');
      $_SESSION['xf_read_tracker']['local'] = array();
      XF::sql_query("UPDATE ".XF::tbl('user')." SET u_time_last_read = :now WHERE u_id = :id",array(
      'id'=>array(XF::vault_query('current_user_id'),'int'),
      'now'=>array(XF::vault_query('uts'),'int')),__METHOD__,__LINE__);
      }
      else
      XF::cookie(XF::get_cfg('cookie_read_tracker'),XF::vault_query('uts'),'21d');
    }

  $lfp = XF::vault_query('root_path').'/lang/'.XF::vault_query('current_language').'/legal.txt';
  XFUI::html_head('{:overview}');

    // only show legal information as imprint and privacy statement
    if ( $this->gpc['showlegal'] === 1 && file_exists($lfp) ){
    echo XF::file_handler($lfp,'','read,local,noroot');
    XFUI::html_foot();
    return true;
    }

  // print any comments left by executive users
  $user = XF::get_user();
    if ( !empty($user['u_comment']) )
    echo '<div class="xf_box_message xf_bm_warning">'.htmlspecialchars($user['u_comment']).'</div>';
    if ( $user['u_warning_level'] === 'high' )
    echo '<div class="xf_box_message xf_bm_warning">'.XFUI::i18n('warning_high').'</div>';
    if ( (bool)$this->gpc['setasread'] )
    echo '<div class="xf_box_message xf_bm_notice">'.XFUI::i18n('all_posts_are_marked_as_read').'</div>';
  unset($user,$lfp);

    // output some statistics
    if ( !XF::$tpl->is_cached('overview.tpl') ){
    $pc = XFCache::statistic('post');
    $uc = XFCache::statistic('user');
    XF::$tpl->assign('user_count_approved',$uc['approved']);
    XF::$tpl->assign('post_count_approved',$pc['approved']);
    XF::$tpl->assign('user_count_unapproved',$uc['unapproved']);
    XF::$tpl->assign('post_count_unapproved',$pc['unapproved']);
    }
  XF::$tpl->display('overview.tpl');
  XF::reset_tpl();
  unset($pc,$uc);
  //XF::$tpl->clear_cache('overview_recent_posts.tpl');

    // common index page: list recent approved(!) posts
    if ( !XF::$tpl->is_cached('overview_recent_posts.tpl') ){
    $neutral_prefixes = array(0);
    $pp = XFUI::get_post_prefix_list();
      foreach ( $pp as $v ){
        if ( empty($v['pp_preset_acl']) )
        $neutral_prefixes[] = $v['pp_id'];
      }
    $topics = array();
    $sthr = XF::sql_query("SELECT p_id,p_topic_id,p_u_id,p_time,p_pp_id,p_subject FROM ".XF::tbl('post_meta')."
    WHERE p_is_topic = true AND p_approved = true AND p_pp_id IN (".implode(',',$neutral_prefixes).") AND p_acl = ''
    ORDER BY p_weight DESC, p_time DESC LIMIT ".intval(XF::get_cfg('main_topic_per_page'))." OFFSET 0",'',__METHOD__,__LINE__);
    $dbr = $sthr->fetchAll(PDO::FETCH_OBJ);
    $sthr->closeCursor();
      foreach ( $dbr as $r ) // use prefetching instead of single query on each topic
      $topics[] = (int)$r->p_id;
    XFCache::topic($topics);
    $topics = array();
      foreach ( $dbr as $r ){
      $r->p_id = intval($r->p_id);
      $cache = XFCache::topic($r->p_topic_id);
      $lastpost = XFParser::lastpost($cache);
      XF::get_user(array($r->p_u_id,$cache['user'][$lastpost]));
      $user_main = XF::get_user($r->p_u_id);
      $user_last = XF::get_user($cache['user'][$lastpost]);
      $rating = ( sizeof($cache['rating']) > 0 ) ? XFParser::limit_rating(array_sum($cache['rating'])) : 0;
      $subject = ( isset($pp[$r->p_pp_id]) ) ? '['.$pp[$r->p_pp_id]['pp_name'].'] '.$r->p_subject : $r->p_subject;
      $topics[$r->p_id] = array(
      'p_id'=>intval($r->p_id),
      'p_subject'=>$subject,
      'p_u_id'=>$user_main['u_name'],
      'p_time'=>intval($r->p_time),
      'p_rating'=>$rating,
      'reply_count'=>XFParser::get_reply_count($cache['tree'],'+'),
      'last_reply_id'=>$lastpost,
      'last_reply_user'=>$user_last['u_name'],
      'last_reply_time'=>$cache['time'][$lastpost]
      );
      }
    XF::$tpl->assign('posting_listing',$topics);
    }
  XF::$tpl->display('overview_recent_posts.tpl');
  XF::reset_tpl();
  unset($user,$cache,$topics,$rating,$subject,$pp);

    // list some tags by frequency and display calendar
    if ( !XF::$tpl->is_cached('overview_quick_search_tab.tpl') ){
    $max = 0;
    $tags = array();
    $resolve = array();
    $stag = XF::sql_query("SELECT td_t_id,COUNT(td_t_id) AS t_count,t_name FROM ".XF::tbl('tag_data')."
    LEFT JOIN ".XF::tbl('tag_meta')." ON ".XF::tbl('tag_meta').".t_id = ".XF::tbl('tag_data').".td_t_id
    GROUP BY td_t_id,t_name ORDER BY t_count DESC LIMIT ".intval(XF::get_cfg('main_tags_on_index'))." OFFSET 0",'',__METHOD__,__LINE__);
      while ( $r = $stag->fetchObject() ){
      $r->t_count = intval($r->t_count);
      $tags[] = array(
      't_id'=>intval($r->td_t_id),
      't_name'=>strval($r->t_name),
      'count'=>$r->t_count
      );
        if ( $r->t_count > $max )
        $max = $r->t_count;
      }
    $stag->closeCursor();
    shuffle($tags); // let's mix some cocktail :D
      foreach ( $tags as $v ){
      $v['max'] = $max;
      $v['size'] = intval((($v['count']/$max)*300)+50);
      $resolve[] = $v;
      }
    //D($resolve,$max);

    $timespan = XFCache::get('simple','post_timespan');
    $calendar = '';
      if ( is_array($timespan) && sizeof($timespan) === 2 )
      $calendar = XFParser::calendar($timespan[0],$timespan[1]);
    XF::$tpl->assign('tag_listing',$resolve);
    XF::$tpl->assign('calendar_listing',$calendar);
    }
  XF::$tpl->display('overview_quick_search_tab.tpl');
  XF::reset_tpl();
  unset($max,$tags,$resolve,$v,$timespan);

  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * index page for all users (directly done by run())
  * @since 1.0.0
  */
  public function execute(){}

}
?>