<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_rss extends XFAction {
const USE_TAN = false;
/**
* @var integer limit included posts to x items on topic rss feed (default is 100)
*/
const LIMIT_POSTS_ON_TOPIC_FEED = 100;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
/**
* @var array buffer of resulting feed, each item is a line
*/
protected static $buffer = array();
/**
* @var integer timestamp of last feed entry, used for 'Last-Modified' in HTTP headers
*/
protected static $last = 0;
/**
* @var array matrix of special chars in xml
*/
protected static $special_chars_on_xml = array(
'min' =>array('&'=>'&amp;'),
'std' =>array('&'=>'&amp;','"'=>'&quot;',"'"=>'&#039;'),
'full'=>array('&'=>'&amp;','"'=>'&quot;',"'"=>'&#039;','<'=>'&lt;','>'=>'&gt;')
);

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  require_once(XF::vault_query('root_path').'/class.parser.php');
  $module = XF::sanitize_var(XF::ifset('get','module','last'),'enum','o=last,o=topic,o=mod_unapprove');
  $id = XF::sanitize_var(XF::ifset('get','id',0),'int');
  $auth_uid = XF::sanitize_var(XF::ifset('get','user',0),'int');
  $auth_pwd = XF::sanitize_var(XF::ifset('get','password',''),'str','okifempty,restrict');
  $this->gpc = array('module'=>$module,'id'=>$id,'auth_uid'=>$auth_uid,'auth_pwd'=>$auth_pwd);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('overview'));
  unset($module,$id,$auth_uid,$auth_pwd);
    // map other than topicid high up in address space. i think, nobody will ever have 2.1 billion posts ;)
    switch ( $this->gpc['module'] ){
    case 'last':
    $ch = XF::RSS_LAST;
    $seg = 'Last Topics';
    $longseg = 'These are our last '.intval(XF::get_cfg('rss_limit')).' topics located on our forum';
    break;
    case 'mod_unapprove':
    $ch = XF::RSS_MOD_UNAPPROVE;
    $seg = 'Unapproved Postings';
    $longseg = 'Any unapproved postings on our forum are listed here';
    break;
    case 'topic':
    $ch = $this->gpc['id'];
    $seg = 'Topic View';
    $longseg = 'This feed includes all postings of the selected topic on our forum';
    break;
    default:
    $ch = 0;
    $seg = $longseg = 'Unknown';
    break;
    }

  $err = '';
  $rss = array();
  $rss_space = chr(9);
  $cache = XFCache::get('rss',$ch);
  $pp = XFUI::get_post_prefix_list();
    if ( is_array($cache) && sizeof($cache) > 0 ){
    self::$last = XFCache::get('rss',$ch,'mtime');
    self::$buffer = $cache;
    }

    switch ( $this->gpc['module'] ){
    case 'last':
      if ( is_array($cache) && sizeof($cache) > 0 )
      return self::execute();
    $neutral_prefixes = array(0);
      foreach ( $pp as $v ){
        if ( empty($v['pp_preset_acl']) )
        $neutral_prefixes[] = $v['pp_id'];
      }
    // NOTE: we won't check the acl here, because we don't care, if subject lines are listed or not :)
    $stop = XF::sql_query("SELECT p_id,p_time,p_pp_id,p_subject,pd_text,u_name FROM ".XF::tbl('post_meta')."
    LEFT JOIN ".XF::tbl('post_data')." ON ".XF::tbl('post_data').".pd_id = ".XF::tbl('post_meta').".p_pd_id
    LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ".XF::tbl('post_meta').".p_u_id
    WHERE p_is_topic = true AND p_approved = true AND p_pp_id IN (".implode(',',$neutral_prefixes).") AND p_acl = ''
    ORDER BY p_time DESC LIMIT ".intval(XF::get_cfg('rss_limit'))." OFFSET 0",'',__METHOD__,__LINE__);
    break;
    case 'topic':
    $topic = XFCache::topic($this->gpc['id']);
      if ( !XFUI::topic_access($topic,$pp) ){
      $err = 'ERROR_NO_ACCESS_TO_TOPIC_GRANTED';
      break;
      }
      if ( is_array($cache) && sizeof($cache) > 0 )
      return self::execute();
    $stop = XF::sql_query("SELECT p_id,p_time,p_pp_id,p_subject,pd_text,u_name FROM ".XF::tbl('post_meta')."
    LEFT JOIN ".XF::tbl('post_data')." ON ".XF::tbl('post_data').".pd_id = ".XF::tbl('post_meta').".p_pd_id
    LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ".XF::tbl('post_meta').".p_u_id
    WHERE p_topic_id = :id AND p_approved = true ORDER BY p_is_topic ASC, p_time ASC
    LIMIT ".self::LIMIT_POSTS_ON_TOPIC_FEED." OFFSET 0",
    array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    break;
    case 'mod_unapprove':
    require_once(XF::vault_query('root_path').'/class.auth.php');
    $auth = XFAuth::check($this->gpc['auth_uid'],$this->gpc['auth_pwd']);
      if ( $auth['valid_user'] && $auth['valid_password'] && $auth['active'] ){
      $group = XF::get_group($auth['group']);
        if ( $group['g_read_unapproved'] ){
          if ( is_array($cache) && sizeof($cache) > 0 )
          return self::execute();
        $stop = XF::sql_query("SELECT p_id,p_time,p_pp_id,p_subject,pd_text,u_name FROM ".XF::tbl('post_meta')."
        LEFT JOIN ".XF::tbl('post_data')." ON ".XF::tbl('post_data').".pd_id = ".XF::tbl('post_meta').".p_pd_id
        LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ".XF::tbl('post_meta').".p_u_id
        WHERE p_approved = false ORDER BY p_time DESC",'',__METHOD__,__LINE__);
        }
        else
        $err = 'ERROR_NO_GROUP_PERMISSION_TO_READ_UNAPPROVED';
      }
      else
      $err = 'ERROR_AUTHENTICATION_FAILED';
    unset($auth,$group);
    break;
    default: $err = 'ERROR_INVALID_MODULE'; break;
    }

  // we use gmdate() instead of XF::date(), because we want to skip locales and have english time formatting at anytime
  $rss[] = '<?xml version=\'1.0\' encoding=\'utf-8\' standalone=\'yes\'?>';
  $rss[] = '<rss';
  $rss[] = '  version=\'2.0\'';
  $rss[] = '  xmlns:rdf=\'http://www.w3.org/1999/02/22-rdf-syntax-ns#\'';
  $rss[] = '  xmlns:content=\'http://purl.org/rss/1.0/modules/content/\'';
  $rss[] = '>';
  $rss[] = $rss_space.'<channel>';
  $rss[] = $rss_space.$rss_space.'<title>'.self::xml_encoding(XF::get_cfg('main_title').' - '.$seg,'>').'</title>';
  $rss[] = $rss_space.$rss_space.'<description>'.self::xml_encoding($longseg,'>').'</description>';
  $rss[] = $rss_space.$rss_space.'<link>'.self::xml_encoding(XF::link('overview'),'>').'</link>';
  $rss[] = $rss_space.$rss_space.'<copyright>Copyright © '.gmdate('Y').', '.self::xml_encoding(XF::get_cfg('main_title'),'>').'</copyright>';
  $rss[] = $rss_space.$rss_space.'<webMaster>'.self::xml_encoding(XF::get_cfg('mail_from_mail'),'>').' ('.self::xml_encoding(XF::get_cfg('mail_from_name'),'>').')</webMaster>';
  $rss[] = $rss_space.$rss_space.'<language>'.self::xml_encoding(XF::get_cfg('main_language'),'>').'</language>';

    if ( isset($stop) && is_object($stop) && empty($err) ){
      while ( $r = $stop->fetchObject() ){
      $r->p_subject = ( isset($pp[$r->p_pp_id]) ) ? '['.$pp[$r->p_pp_id]['pp_name'].'] '.$r->p_subject : $r->p_subject;
      $r->u_name = XFUI::lang_str($r->u_name);
        if ( $this->gpc['module'] === 'last' )
        $fl = XF::link('topic',array('id'=>$r->p_id),false);
        else
        $fl = XF::link('topic',array('post'=>$r->p_id),false).'#p'.$r->p_id;
      $rss[] = $rss_space.$rss_space.'<item>';
      $rss[] = $rss_space.$rss_space.$rss_space.'<title>'.self::xml_encoding($r->p_subject,'>').'</title>';
      $rss[] = $rss_space.$rss_space.$rss_space.'<author>'.self::xml_encoding('author.mail.is.hidden@'.XF::ifset('server','SERVER_NAME','localhost.localdomain').' ('.$r->u_name.')','>').'</author>';
      $rss[] = $rss_space.$rss_space.$rss_space.'<link>'.self::xml_encoding($fl,'>').'</link>';
      $rss[] = $rss_space.$rss_space.$rss_space.'<guid isPermaLink="false">'.self::xml_encoding(sha1($r->p_id.$r->p_subject),'>').'</guid>';
      $rss[] = $rss_space.$rss_space.$rss_space.'<pubDate>'.gmdate(XF::DATE_RFC822,$r->p_time).'</pubDate>';
        if ( XF::get_cfg('rss_payload') )
        $rss[] = $rss_space.$rss_space.$rss_space.'<content:encoded>'.htmlspecialchars(XFParser::message($r->pd_text)).'</content:encoded>';
      $rss[] = $rss_space.$rss_space.'</item>';
        if ( $r->p_time > self::$last )
        self::$last = $r->p_time;
      $cache = true;
      }
    $stop->closeCursor();
    }
    else
    $rss[7] = str_replace('</title>',' :: '.$err.'</title>',$rss[7]);

  $rss[] = $rss_space.'</channel>';
  $rss[] = '</rss>';
    if ( XF::get_cfg('cache_rss') && empty($err) )
    XFCache::put('rss',$ch,$rss);
  self::$buffer = $rss;
  return self::execute();
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * send xml data to client for rss feed
  * @return true
  * @since 1.0.0
  */
  public function execute(){
  //die(D(htmlspecialchars(implode(chr(10),self::$buffer))));
    if ( !headers_sent() ){
    @ob_end_flush();
    header('Content-Type: text/xml; charset=utf-8');
    header('Last-Modified: '.gmdate(XF::DATE_RFC822,self::$last));
    header('Cache-Control: ');
    header('Pragma: ');
    }
  echo implode(chr(10),self::$buffer);
  return true;
  }

  /**
  * do neccessary xml payload encoding
  * @param string $input input stream
  * @param string $class encode '>' string or decode '< ' it
  * @return string
  * @since 1.0.0
  */
  protected static function xml_encoding($input,$class = '>'){
    if ( $class === '>' )
    $o = strtr($input,self::$special_chars_on_xml['full']);
    elseif ( $class === '<' )
    $o = strtr($input,array_flip(self::$special_chars_on_xml['full']));
  return $o;
  }

}
?>