<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_post_approve extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
public $sucmsg = '';
public $sucid = '';
public $sucss = '';

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','mcp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('overview'));
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'post',0),'int');
  $this->gpc = array('id'=>$id);
  return true;
  }

  /**
  * approve or hide a posting
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $schk = XF::sql_query("SELECT p_is_topic,p_topic_id,p_approved FROM ".XF::tbl('post_meta')." WHERE p_id = :id",
    array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $postdata = $schk->fetchObject();
    $schk->closeCursor();
      if ( !is_object($postdata) )
      $this->error = '{:no_valid_id}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_meta'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $cache = XFCache::topic($postdata->p_topic_id);
      $new = ( (bool)$postdata->p_approved ) ? false : true;
      $u = XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_approved = :status WHERE p_id = :id",
      array('id'=>array($this->gpc['id'],'int'),
      'status'=>array((int)$new,'str')),__METHOD__,__LINE__);
        if ( !$u )
        throw new XFE('could not update approvement for posting "'.$this->gpc['id'].'"');
      XFCache::topic_delta($cache,'change_approve',array('id'=>$this->gpc['id'],'approve'=>$new));
      XF::tpl_use_cache_pool($this->gpc['id'],'begin');
        if ( XF::$tpl->is_cached('post.tpl',$this->gpc['id']) )
        XF::$tpl->clear_cache('post.tpl',$this->gpc['id']);
        if ( (bool)$postdata->p_is_topic ){ // if topic is processed, include all replies...
        $schk = XF::sql_query("SELECT p_id FROM ".XF::tbl('post_meta')." WHERE p_topic_id = :id AND p_is_topic = false",
        array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
          while ( $r = $schk->fetchObject() ){
          XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_approved = :status WHERE p_id = :id",
          array('id'=>array($r->p_id,'int'),
          'status'=>array((int)$new,'str')),__METHOD__,__LINE__);
          XFCache::topic_delta($cache,'change_approve',array('id'=>$r->p_id,'approve'=>$new));
          XF::tpl_use_cache_pool($r->p_id,'change');
            if ( XF::$tpl->is_cached('post.tpl',$r->p_id) )
            XF::$tpl->clear_cache('post.tpl',$r->p_id);
          }
        $schk->closeCursor();
        }
      XF::tpl_use_cache_pool(0,'reset');
      XF::logger('info','postid',$this->gpc['id'],'new_status',XF::bool2yn($new));
      XF::sql_transaction('commit');
      XFCache::statistic('post','rebuild');
      XFCache::put('topic',$postdata->p_topic_id,$cache);
        if ( (bool)$postdata->p_is_topic )
        XFCache::purge('rss',XF::RSS_LAST);
        if ( !$new )
        XFCache::purge('rss',XF::RSS_MOD_UNAPPROVE);
        if ( $new && (bool)$postdata->p_is_topic && XF::$tpl->is_cached('overview_recent_posts.tpl') )
        XF::$tpl->clear_cache('overview_recent_posts.tpl');
      XFUI::load_lang_res('','topic');
      $this->sucmsg = ( $new ) ? '{:posting_is_now_visible}' : '{:posting_is_now_hidden}';
      $this->sucid = ( $new ) ? '{:set_post_hidden}' : '{:set_post_visible}';
      $this->sucss = ( $new ) ? 'none' : 'block';
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_post_approve($input){
  $a = new XFAction_post_approve();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $b = $a->get_GPC();
  $a->execute();
    if ( $a->get_success() ){
    XFUI::$ajax_response->assign('f_post_mcp_approve_'.$b['id'],'innerHTML',XFUI::lang_str($a->sucid));
    XFUI::$ajax_response->assign('f_post_hide_'.$b['id'],'style.display',$a->sucss);
    return xfaf_success('',$a->sucmsg);
    }
    else
    return xfaf_failure($a->get_error());
  }

?>