<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_user_new extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $sucid = 0;
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  XFUI::load_lang_res('','register');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('acp_overview'));
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $uid = XF::sanitize_var(XF::ifset($input,'f_user',''),'uid');
  $this->gpc = array('f_user'=>$uid);
  $this->markgpc = array('f_user');
  }

  /**
  * create a new user account
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $susr = XF::sql_query("SELECT u_id FROM ".XF::tbl('user')." WHERE u_name = :username",
    array('username'=>array($this->gpc['f_user'],'str')),__METHOD__,__LINE__);
    $userdata = $susr->fetchObject();
    $susr->closeCursor();
      if ( is_object($userdata) )
      $this->error = '{:username_already_used}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('user'=>'w')) )
        throw new XFE('unable to begin database transaction');
      XF::sql_query("INSERT INTO ".XF::tbl('user')." (u_active,u_name,u_group,u_time_registration) VALUES (:active,:username,:group,:regtime)",
      array('active'=>array(0,'str'),
      'username'=>array($this->gpc['f_user'],'str'),
      'group'=>array(XF::get_cfg('main_default_group'),'int'),
      'regtime'=>array(XF::vault_query('uts'),'int')),__METHOD__,__LINE__);
      $newuid = XF::sql_lastId('user.u_id');
        if ( !$newuid )
        throw new XFE('new user could not be inserted');
      XF::logger('info','new_id',$newuid);
      XF::statistic('account_register');
      XF::sql_transaction('commit');
      $this->sucid = (int)$newuid;
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_user_new($input){
  $a = new XFAction_acp_user_new();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('ucp_profile',array('user'=>$a->sucid),false),'{:account_successfully_created}');
    else
    return xfaf_failure($a->get_error());
  }

?>