<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_reset_password extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.1.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','login');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.1.0
  */
  protected function regular(){
  $hash = XF::sanitize_var(XF::ifset('get','hash',''),'str','okifempty,restrict');
    if ( strlen($hash) !== 16 )
    XFUI::html_redirect(-1,XF::link('overview'));
  XFUI::ajax_init();
  XFUI::html_head('{:reset_password}');
  XF::$tpl->assign('hash',$hash);
  XF::$tpl->display('form_reset_password.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.1.0
  */
  protected function ajax($input){
  $f_hash = XF::sanitize_var(XF::ifset($input,'f_hash',''),'str','restrict');
  $f_pass_1 = XF::sanitize_var(XF::ifset($input,'f_pass_1_hash',''),'str','restrict');
  $f_pass_2 = XF::sanitize_var(XF::ifset($input,'f_pass_2_hash',''),'str','restrict');
  $this->gpc = array('f_hash'=>$f_hash,'f_pass_1'=>$f_pass_1,'f_pass_2'=>$f_pass_2);
  return true;
  }

  /**
  * reset user password to the new value
  * @return boolean
  * @since 1.1.0
  */
  public function execute(){
    try {
    $sreq = XF::sql_query("SELECT ur_u_id,ur_time FROM ".XF::tbl('user_request')." WHERE ur_hash = :hash AND ur_class = 'ACTIVATE_PASSWORD'",array('hash'=>array($this->gpc['f_hash'],'str')),__METHOD__,__LINE__);
    $reqdata = $sreq->fetchObject();
    $sreq->closeCursor();
      if ( !is_object($reqdata) )
      $this->error = '{:no_valid_id}';
      else{
        if ( $reqdata->ur_time+XF::get_cfg('auth_activate_limit') < XF::vault_query('uts') && empty($this->error) )
        $this->error = '{:time limit for activation exceeded}';
      }
      if ( hash('sha1',hash('sha1','')) === substr($this->gpc['f_pass_2'],3) && empty($this->error) )
      $this->error = '{:password_must_not_be_empty}';
      if ( $this->gpc['f_pass_1'] !== $this->gpc['f_pass_2'] && empty($this->error) )
      $this->error = '{:new_passwords_not_equal}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('user'=>'w','user_request'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $u = XF::sql_query("UPDATE ".XF::tbl('user')." SET u_password = :password WHERE u_id = :userid",array(
      'userid'=>array($reqdata->ur_u_id,'int'),
      'password'=>array(XF::advhash(substr($this->gpc['f_pass_2'],3)),'int'),
      ),__METHOD__,__LINE__);
        if ( !$u )
        throw new XFE('user password could not be updated');
      $d = XF::sql_query("DELETE FROM ".XF::tbl('user_request')." WHERE ur_class = 'ACTIVATE_PASSWORD' AND ur_hash = :hash",array('hash'=>array($this->gpc['f_hash'],'str')),__METHOD__,__LINE__);
        if ( !$d )
        throw new XFE('user request could not be deleted');
      XF::logger('info','userid',$reqdata->ur_u_id);
      XF::statistic('password_activation');
      XF::sql_transaction('commit');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_reset_password($input){
  $a = new XFAction_reset_password();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() ){
    $b = ( XF::vault_query('is_logged_in') ) ? 'overview' : 'login';
    return xfaf_success(XF::link($b,'',false),'{:reset_password_success}');
    }
    else
    return xfaf_failure($a->get_error());
  }

?>