/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.core;

import java.util.Vector;
import org.linphone.core.CallDirection;
import org.linphone.core.LinphoneAddress;
import org.linphone.core.LinphoneCallLog;
import org.linphone.core.LinphoneCallParams;

public interface LinphoneCall {
    public State getState();

    public LinphoneAddress getRemoteAddress();

    public CallDirection getDirection();

    public LinphoneCallLog getCallLog();

    public LinphoneCallParams getCurrentParamsReadOnly();

    public static class State {
        private static Vector values = new Vector();
        private final int mValue;
        private final String mStringValue;
        public static final State Idle = new State(0, "Idle");
        public static final State IncomingReceived = new State(1, "IncomingReceived");
        public static final State OutgoingInit = new State(2, "OutgoingInit");
        public static final State OutgoingProgress = new State(3, "OutgoingProgress");
        public static final State OutgoingRinging = new State(4, "OutgoingRinging");
        public static final State OutgoingEarlyMedia = new State(5, "OutgoingEarlyMedia");
        public static final State Connected = new State(6, "Connected");
        public static final State StreamsRunning = new State(7, "StreamsRunning");
        public static final State Pausing = new State(8, "Pausing");
        public static final State Paused = new State(9, "Paused");
        public static final State Resuming = new State(10, "Resuming");
        public static final State Refered = new State(11, "Refered");
        public static final State Error = new State(12, "Error");
        public static final State CallEnd = new State(13, "CallEnd");
        public static final State PausedByRemote = new State(14, "PausedByRemote");
        public static final State CallUpdatedByRemote = new State(15, "CallUpdatedByRemote");
        public static final State CallIncomingEarlyMedia = new State(16, "CallIncomingEarlyMedia");
        public static final State CallUpdated = new State(17, "CallUpdated");

        private State(int value, String stringValue) {
            this.mValue = value;
            values.addElement(this);
            this.mStringValue = stringValue;
        }

        public static State fromInt(int value) {
            int i = 0;
            while (i < values.size()) {
                State state = (State)values.elementAt(i);
                if (state.mValue == value) {
                    return state;
                }
                ++i;
            }
            throw new RuntimeException("state not found [" + value + "]");
        }

        public String toString() {
            return this.mStringValue;
        }
    }
}

