/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import org.linphone.jortp.PayloadType;
import org.linphone.jortp.PayloadTypeImpl;
import org.linphone.jortp.RtpProfile;

public class RtpProfileImpl
implements RtpProfile {
    private PayloadType[] mPayloads = new PayloadType[127];

    public PayloadType findPayloadType(String mime, int clockrate, int[] position) {
        int i = 0;
        while (i < 127) {
            PayloadType p = this.mPayloads[i];
            if (p != null && mime.equalsIgnoreCase(p.getMimeType()) && clockrate != -1 && clockrate == p.getClockRate()) {
                position[0] = i;
                return p;
            }
            ++i;
        }
        return null;
    }

    public PayloadType getPayloadType(int pos) {
        return this.mPayloads[pos];
    }

    public void setPayloadType(PayloadType pt, int pos) {
        this.mPayloads[pos] = pt;
    }

    public static RtpProfile createAVProfile() {
        RtpProfileImpl p = new RtpProfileImpl();
        p.setPayloadType(PayloadTypeImpl.createAudio("pcmu", 8000), 0);
        p.setPayloadType(PayloadTypeImpl.createAudio("gsm", 8000), 3);
        p.setPayloadType(PayloadTypeImpl.createAudio("g723", 8000), 4);
        p.setPayloadType(PayloadTypeImpl.createAudio("pcma", 8000), 8);
        return p;
    }
}

