/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.fields;

import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.fields.SDPField;

public class OriginField
extends SDPField {
    protected String username;
    protected String sessID;
    protected long sessVersion;
    protected String nettype;
    protected String addrtype;
    protected Host address;

    public Object clone() {
        OriginField retval = new OriginField();
        retval.username = this.username;
        retval.sessID = this.sessID;
        retval.sessVersion = this.sessVersion;
        retval.nettype = this.nettype;
        retval.addrtype = this.addrtype;
        if (this.address != null) {
            retval.address = (Host)this.address.clone();
        }
        return retval;
    }

    public OriginField() {
        super("o=");
    }

    public String getUsername() throws SdpParseException {
        return this.username;
    }

    public String getNettype() {
        return this.nettype;
    }

    public String getAddrtype() {
        return this.addrtype;
    }

    public Host getHost() {
        return this.address;
    }

    public void setNettype(String n) {
        this.nettype = n;
    }

    public void setAddrtype(String a) {
        this.addrtype = a;
    }

    public void setAddress(Host a) {
        this.address = a;
    }

    public void setUsername(String user) throws SdpException {
        if (user == null) {
            throw new SdpException("The user parameter is null");
        }
        this.username = user;
    }

    public String getSessionId() throws SdpParseException {
        return this.sessID;
    }

    public void setSessionId(String id) throws SdpException {
        if (id == null || id.length() == 0) {
            throw new SdpException("The SessionID is null or too short");
        }
        this.sessID = id;
    }

    public long getSessionVersion() throws SdpParseException {
        return this.sessVersion;
    }

    public void setSessionVersion(long version) throws SdpException {
        if (version < 0L) {
            throw new SdpException("The version parameter is <0");
        }
        this.sessVersion = version;
    }

    public String getAddress() throws SdpParseException {
        Host addr = this.getHost();
        if (addr == null) {
            return null;
        }
        return addr.getAddress();
    }

    public String getAddressType() throws SdpParseException {
        return this.getAddrtype();
    }

    public String getNetworkType() throws SdpParseException {
        return this.getNettype();
    }

    public void setAddress(String addr) throws SdpException {
        if (addr == null) {
            throw new SdpException("The addr parameter is null");
        }
        Host host = this.getHost();
        if (host == null) {
            host = new Host();
        }
        host.setAddress(addr);
        this.setAddress(host);
    }

    public void setAddressType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("The type parameter is <0");
        }
        this.setAddrtype(type);
    }

    public void setNetworkType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("The type parameter is <0");
        }
        this.setNettype(type);
    }

    public String encode() {
        return "o=" + this.username + " " + this.sessID + " " + this.sessVersion + " " + this.nettype + " " + this.addrtype + " " + this.address.encode() + "\r\n";
    }
}

