/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.bb;

import net.rim.device.api.system.CoverageInfo;
import net.rim.device.api.system.RadioStatusListener;
import net.rim.device.api.system.WLANConnectionListener;
import net.rim.device.api.system.WLANInfo;
import org.linphone.core.LinphoneCore;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;

public class NetworkManager
implements RadioStatusListener,
WLANConnectionListener {
    private final LinphoneCore mCore;
    private int mCurrentTransportType = 0;
    private boolean isWifiConnected = WLANInfo.getWLANState() == 4620;
    static Logger mLog = JOrtpFactory.instance().createLogger("LinphoneCore");

    public NetworkManager(LinphoneCore aCore) {
        this.mCore = aCore;
    }

    public void baseStationChange() {
    }

    public void networkScanComplete(boolean success) {
    }

    public void networkServiceChange(int networkId, int service) {
    }

    public void networkStarted(int networkId, int service) {
        this.handleCnxStateChange();
    }

    public void networkStateChange(int state) {
        this.handleCnxStateChange();
    }

    public void pdpStateChange(int apn, int state, int cause) {
    }

    public void radioTurnedOff() {
        this.handleCnxStateChange();
    }

    public void signalLevel(int level) {
    }

    public void networkConnected() {
        this.isWifiConnected = true;
        this.handleCnxStateChange();
    }

    public void networkDisconnected(int reason) {
        this.isWifiConnected = false;
        this.handleCnxStateChange();
    }

    public void handleCnxStateChange() {
        boolean lIsWifi = this.isWifiConnected & WLANInfo.getWLANState() == 4620;
        boolean lIsCellular = (CoverageInfo.getCoverageStatus((int)3, (boolean)true) & 1) == 1;
        mLog.info("Cnx state has changed, wifi [" + lIsWifi + "] WAN [" + lIsCellular + "] for coverage status [" + CoverageInfo.getCoverageStatus() + "]");
        if (!lIsWifi && !lIsCellular) {
            this.mCore.setNetworkReachable(false);
            this.mCurrentTransportType = 0;
            return;
        }
        if (lIsWifi) {
            if (this.mCurrentTransportType != 6) {
                this.mCore.setNetworkReachable(false);
                this.mCore.iterate();
                this.mCurrentTransportType = 6;
                this.mCore.setNetworkReachable(true);
                return;
            }
        } else if (lIsCellular && this.mCurrentTransportType != 1) {
            this.mCore.setNetworkReachable(false);
            this.mCore.iterate();
            this.mCurrentTransportType = 1;
            this.mCore.setNetworkReachable(true);
            return;
        }
    }
}

