/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.media.jsr135;

import java.util.Timer;
import java.util.TimerTask;
import org.linphone.jlinphone.media.AudioStream;
import org.linphone.jlinphone.media.AudioStreamParameters;
import org.linphone.jlinphone.media.jsr135.RecvStream;
import org.linphone.jlinphone.media.jsr135.SendStream;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;
import org.linphone.jortp.RtpException;
import org.linphone.jortp.RtpSession;
import org.linphone.jortp.RtpTransport;
import org.linphone.jortp.SocketAddress;

public class AudioStreamImpl
implements AudioStream {
    private RecvStream mRecvStream;
    private SendStream mSendStream;
    static Logger mLog = JOrtpFactory.instance().createLogger("AudioStream");
    private RtpSession mSession;
    static Timer mTimer = new Timer();
    private TimerTask mTimerTask;
    private boolean mIsStarted = false;
    RtpTransport mRtpTransport;

    public void stop() {
        if (this.mRecvStream != null) {
            this.mRecvStream.stop();
        }
        if (this.mSendStream != null) {
            this.mSendStream.stop();
        }
        this.mSession.close();
        if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
        }
        mLog.warn("received stats :" + this.mSession.getRecvStats().toString());
        mLog.warn("send stats :" + this.mSession.getSendStats().toString());
        this.mIsStarted = false;
    }

    public void init(SocketAddress local) throws RtpException {
        this.mSession = JOrtpFactory.instance().createRtpSession();
        if (this.mRtpTransport != null) {
            this.mSession.setTransport(this.mRtpTransport);
        }
        this.mSession.setLocalAddr(local);
    }

    public void start(AudioStreamParameters params) throws RtpException {
        this.mIsStarted = true;
        this.mSession.setRemoteAddr(params.getRemoteDest());
        this.mSession.setProfile(params.getRtpProfile());
        this.mSession.setSendPayloadTypeNumber(params.getActivePayloadTypeNumber());
        this.mSession.setRecvPayloadTypeNumber(params.getActivePayloadTypeNumber());
        this.mTimerTask = new TimerTask(){

            public void run() {
                if (AudioStreamImpl.this.mSession != null) {
                    mLog.warn("received stats :" + AudioStreamImpl.this.mSession.getRecvStats().toString() + "\n Player timestamp =" + AudioStreamImpl.this.mRecvStream.getPlayerTs());
                    mLog.warn("send stats :" + AudioStreamImpl.this.mSession.getSendStats().toString());
                    mLog.warn("Jitter buffer statistics\n" + AudioStreamImpl.this.mSession.getJitterBufferStatistics());
                }
            }
        };
        mTimer.scheduleAtFixedRate(this.mTimerTask, 5000L, 5000L);
        this.mSendStream = new SendStream(this.mSession);
        this.mRecvStream = new RecvStream(this.mSession, this.mSendStream);
        this.mSendStream.start();
        Thread lTmpThread = new Thread(new Runnable(){

            public void run() {
                AudioStreamImpl.this.mRecvStream.start();
            }
        });
        lTmpThread.start();
    }

    public int getPlayLevel() {
        if (this.mRecvStream != null) {
            return this.mRecvStream.getPlayLevel();
        }
        return 0;
    }

    public void setPlayLevel(int level) {
        if (this.mRecvStream != null) {
            this.mRecvStream.setPlayLevel(level);
        }
    }

    public boolean isStarted() {
        return this.mIsStarted;
    }

    public void enableSpeaker(boolean value) {
        if (this.mRecvStream != null) {
            this.mRecvStream.enableSpeaker(value);
        }
        if (this.mSendStream != null) {
            this.mSendStream.enableSpeaker(value);
        }
    }

    public boolean isSpeakerEnabled() {
        if (this.mRecvStream != null) {
            return this.mRecvStream.isSpeakerEnabled();
        }
        return false;
    }

    public void muteMic(boolean value) {
        if (this.mSendStream != null) {
            this.mSendStream.muteMic(value);
        }
    }

    public boolean isMicMuted() {
        if (this.mSendStream != null) {
            return this.mSendStream.isMicMuted();
        }
        return false;
    }

    public void setRtpTransport(RtpTransport t) {
        this.mRtpTransport = t;
    }
}

