/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.microedition.sip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.microedition.sip.RefreshManager;
import sip4me.gov.nist.microedition.sip.RefreshTask;
import sip4me.gov.nist.microedition.sip.SDPOutputStream;
import sip4me.gov.nist.microedition.sip.SipConnectionNotifierImpl;
import sip4me.gov.nist.microedition.sip.SipDialogImpl;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.AuthenticationHelper;
import sip4me.gov.nist.siplite.SipException;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.address.TelURL;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.ContactHeader;
import sip4me.gov.nist.siplite.header.ContentTypeHeader;
import sip4me.gov.nist.siplite.header.ExpiresHeader;
import sip4me.gov.nist.siplite.header.FromHeader;
import sip4me.gov.nist.siplite.header.Header;
import sip4me.gov.nist.siplite.header.MaxForwardsHeader;
import sip4me.gov.nist.siplite.header.ToHeader;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.ClientTransaction;
import sip4me.gov.nist.siplite.stack.authentication.Credentials;
import sip4me.gov.nist.siplite.stack.authentication.DigestClientAuthentication;
import sip4me.nist.javax.microedition.sip.SipClientConnection;
import sip4me.nist.javax.microedition.sip.SipClientConnectionListener;
import sip4me.nist.javax.microedition.sip.SipConnectionNotifier;
import sip4me.nist.javax.microedition.sip.SipDialog;
import sip4me.nist.javax.microedition.sip.SipRefreshListener;

public class SipClientConnectionImpl
implements SipClientConnection {
    protected static final int CREATED = 1;
    protected static final int INITIALIZED = 2;
    protected static final int STREAM_OPEN = 3;
    protected static final int PROCEEDING = 4;
    protected static final int UNAUTHORIZED = 5;
    protected static final int COMPLETED = 6;
    protected static final int TERMINATED = 7;
    private SipDialog sipDialog = null;
    private SipClientConnectionListener sipClientConnectionListener = null;
    private SipConnectionNotifier sipConnectionNotifier = null;
    private SipRefreshListener sipRefreshListener = null;
    private String refreshID = null;
    protected int state;
    private boolean connectionOpen;
    private Vector credentials;
    private Request request = null;
    private Response response = null;
    private OutputStream contentOutputStream = null;
    private InputStream contentInputStream = null;
    private URI requestURI = null;
    private String scheme = null;
    private String user = null;
    private String host = null;
    private int port;
    private Vector parameters = null;
    private String userSipURI = "sip:anonymous@anonymous.invalid";
    private ClientTransaction clientTransaction = null;
    private Thread listeningThread = null;
    private StackConnector stackConnector = null;
    private AuthenticationHelper authHelper;
    private Response authResponse;

    protected SipClientConnectionImpl(String scheme, String user, String host, int port, Vector parameters) throws IllegalArgumentException {
        this.scheme = scheme;
        this.user = user;
        this.host = host;
        this.port = port;
        this.parameters = parameters;
        this.connectionOpen = true;
        this.credentials = new Vector();
        try {
            this.stackConnector = StackConnector.getInstance();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            String ruri = String.valueOf(scheme) + ":" + user;
            if (host != null) {
                ruri = String.valueOf(ruri) + "@" + host;
            }
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("Creating SipClientConnection from R-URI: " + ruri + " and parameters " + parameters);
            }
            this.requestURI = StackConnector.addressFactory.createURI(ruri);
            if (port != -1) {
                ((SipURI)this.requestURI).setPort(port);
            }
            if (parameters != null && this.requestURI.isSipURI()) {
                int i = 0;
                while (i < parameters.size()) {
                    String parameter = (String)parameters.elementAt(i);
                    String name = parameter.substring(0, parameter.indexOf("=")).trim().toLowerCase();
                    String value = parameter.substring(parameter.indexOf("=") + 1);
                    ((SipURI)this.requestURI).setParameter(name, value);
                    ++i;
                }
            }
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("Created SipClientConnection with R-URI: " + this.requestURI);
            }
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("The request URI can not be created, check the URI syntax");
        }
        this.state = 1;
    }

    protected SipClientConnectionImpl(URI requestURI, SipDialog sipDialog) throws IllegalArgumentException {
        this.connectionOpen = true;
        this.credentials = new Vector();
        this.requestURI = requestURI;
        this.sipDialog = sipDialog;
        try {
            this.stackConnector = StackConnector.getInstance();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.state = 1;
    }

    protected SipClientConnectionImpl(Request request, SipConnectionNotifier sipConnectionNotifier, String sipUserURI) throws IllegalArgumentException {
        this.connectionOpen = true;
        this.credentials = new Vector();
        this.request = request;
        this.userSipURI = sipUserURI;
        this.sipConnectionNotifier = sipConnectionNotifier;
        try {
            this.stackConnector = StackConnector.getInstance();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.state = request.getMethod().equals("CANCEL") ? 2 : 1;
    }

    public void initRequest(String method, SipConnectionNotifier scn) throws IllegalArgumentException, sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 1) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the request can not be initialized, because of wrong state.", 5);
        }
        if (this.state == 1 && (method.equals("ACK") || method.equals("CANCEL"))) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the request can not be initialized, because of wrong state.", 5);
        }
        if (method == null) {
            throw new IllegalArgumentException("The method can not be null");
        }
        if (this.sipConnectionNotifier == null && scn == null) {
            throw new IllegalArgumentException("The SipConnectionNotifier can not be null");
        }
        if (scn != null) {
            this.sipConnectionNotifier = scn;
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Initializing Request with Method: " + method + "and SCN: " + scn);
        }
        if (method.equals("ACK")) {
            this.initAck();
        }
        if (method.equals("CANCEL")) {
            this.initCancel();
        }
        if (method.equals("BYE")) {
            this.initBye();
            this.state = 2;
            return;
        }
        if (method.equals("INVITE") && this.state == 1 && this.sipDialog != null) {
            this.initReInvite();
            this.state = 2;
            return;
        }
        if (method.equals("NOTIFY")) {
            this.initNotify();
            this.state = 2;
            return;
        }
        if (method.equals("INFO")) {
            this.initInfo();
            this.state = 2;
            return;
        }
        String sipURI = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"UserSipUri", (boolean)false);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            if (re.hasNextElement()) {
                sipURI = new String(re.nextRecord());
            }
            re.destroy();
        }
        catch (RecordStoreException rs) {
            // empty catch block
        }
        this.userSipURI = sipURI != null ? sipURI : "\"Anonymous\" <sip:thisis@anonymous.invalid>";
        Address userAddress = null;
        try {
            userAddress = StackConnector.addressFactory.createAddress(this.userSipURI);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("The system property UserSipUri can not be parsed, check the syntax");
        }
        CallIdHeader callIdHeader = ((SipConnectionNotifierImpl)scn).getSipProvider().getNewCallId();
        CSeqHeader cSeqHeader = null;
        try {
            cSeqHeader = StackConnector.headerFactory.createCSeqHeader(1, method);
        }
        catch (ParseException pe) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Problem during the creation of the CSeqHeader", 9);
        }
        FromHeader fromHeader = null;
        Address fromAddress = null;
        if (((SipConnectionNotifierImpl)this.sipConnectionNotifier).isSharedMode()) {
            fromAddress = userAddress;
        } else {
            try {
                fromAddress = StackConnector.addressFactory.createAddress("\"Anonymous\" <sip:thisis@anonymous.invalid>");
            }
            catch (ParseException e) {
                throw new sip4me.nist.javax.microedition.sip.SipException("Problem during the creation of the FromHeader", 9);
            }
        }
        try {
            fromHeader = StackConnector.headerFactory.createFromHeader(fromAddress, StackConnector.generateTag());
        }
        catch (ParseException ex) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Problem during the creation of the FromHeader", 9);
        }
        Address toAddress = StackConnector.addressFactory.createAddress(this.requestURI);
        ToHeader toHeader = null;
        try {
            toHeader = StackConnector.headerFactory.createToHeader(toAddress, null);
        }
        catch (ParseException ex) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Problem during the creation of the ToHeader", 9);
        }
        Vector<ViaHeader> viaHeaders = new Vector<ViaHeader>();
        try {
            String transport = null;
            if (this.requestURI instanceof SipURI) {
                transport = ((SipURI)this.requestURI).getTransportParam();
            }
            if (transport == null || !transport.equalsIgnoreCase("tcp") && !transport.equalsIgnoreCase("udp")) {
                transport = "udp";
                if (this.parameters != null && this.parameters.contains("transport=tcp")) {
                    transport = "tcp";
                }
            }
            ViaHeader viaHeader = StackConnector.headerFactory.createViaHeader(this.sipConnectionNotifier.getLocalAddress(), this.sipConnectionNotifier.getLocalPort(), transport, null);
            viaHeader.setParameter("rport", "");
            viaHeaders.addElement(viaHeader);
        }
        catch (ParseException ex) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Problem during the creation of the ViaHeaders", 9);
        }
        catch (IOException ioe) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Internal Error, cannot get the local port or address", 9);
        }
        catch (ClassCastException ex) {
            System.err.println("mwahahaha");
            throw new sip4me.nist.javax.microedition.sip.SipException("Problem during the creation of the ViaHeaders", 9);
        }
        MaxForwardsHeader maxForwardsHeader = StackConnector.headerFactory.createMaxForwardsHeader(70);
        if (method.equals("REGISTER")) {
            Address reqUriAddress = null;
            try {
                reqUriAddress = StackConnector.addressFactory.createAddress(this.userSipURI);
                if (reqUriAddress.isSIPAddress()) {
                    ((SipURI)reqUriAddress.getURI()).removeUser();
                    this.requestURI = reqUriAddress.getURI();
                }
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("The system property UserSipUri can not be parsed, check the syntax");
            }
        }
        try {
            if (this.sipConnectionNotifier != null) {
                this.request = StackConnector.messageFactory.createRequest(this.requestURI, method, callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader);
            } else {
                this.request = StackConnector.messageFactory.createRequest(this.requestURI.toString());
                this.request.setMethod(method);
                this.request.setCallId(callIdHeader);
                this.request.setCSeqHeader(cSeqHeader);
                this.request.setTo(toHeader);
                this.request.setVia(viaHeaders);
                this.request.setHeader(maxForwardsHeader);
            }
        }
        catch (ParseException ex) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Problem during the creation of the Request " + method, 9);
        }
        this.state = 2;
    }

    public void setRequestURI(String URI2) throws IllegalArgumentException, sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the request URI can not be set, because of wrong state.", 5);
        }
        if (URI2 == null) {
            throw new IllegalArgumentException("Invalid URI");
        }
        URI uri = null;
        try {
            uri = StackConnector.addressFactory.createURI(URI2);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Invalid URI");
        }
        this.request.setRequestURI(uri);
    }

    public void initAck() throws sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 6) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the ACK request can not be initialized, because of wrong state.", 5);
        }
        try {
            this.request = this.clientTransaction.createAck();
        }
        catch (SipException se) {
            new sip4me.nist.javax.microedition.sip.SipException(se.getMessage(), 9);
        }
        this.state = 2;
    }

    protected void initBye() {
        SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
        try {
            this.request = sipDialogImpl.dialog.createRequest("BYE");
            if (this.parameters != null) {
                int i = 0;
                while (i < this.parameters.size()) {
                    String parameter = (String)this.parameters.elementAt(i);
                    String name = parameter.substring(0, parameter.indexOf("=")).trim().toLowerCase();
                    String value = parameter.substring(parameter.indexOf("=") + 1);
                    ((SipURI)this.requestURI).setParameter(name, value);
                    ++i;
                }
            }
        }
        catch (SipException ex) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(2, "Could not create the BYE request! " + ex.getMessage());
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
    }

    protected void initReInvite() {
        SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
        try {
            this.request = sipDialogImpl.dialog.createRequest("INVITE");
            if (this.parameters != null) {
                int i = 0;
                while (i < this.parameters.size()) {
                    String parameter = (String)this.parameters.elementAt(i);
                    String name = parameter.substring(0, parameter.indexOf("=")).trim().toLowerCase();
                    String value = parameter.substring(parameter.indexOf("=") + 1);
                    ((SipURI)this.requestURI).setParameter(name, value);
                    ++i;
                }
            }
        }
        catch (SipException ex) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(2, "Could not create the re-INVITE request! " + ex.getMessage());
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
    }

    protected void initNotify() {
        SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
        try {
            this.request = sipDialogImpl.dialog.createRequest("NOTIFY");
            if (this.parameters != null) {
                int i = 0;
                while (i < this.parameters.size()) {
                    String parameter = (String)this.parameters.elementAt(i);
                    String name = parameter.substring(0, parameter.indexOf("=")).trim().toLowerCase();
                    String value = parameter.substring(parameter.indexOf("=") + 1);
                    ((SipURI)this.requestURI).setParameter(name, value);
                    ++i;
                }
            }
        }
        catch (SipException ex) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(2, "Could not create the NOTIFY request! " + ex.getMessage());
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
    }

    protected void initInfo() {
        SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
        try {
            this.request = sipDialogImpl.dialog.createRequest("INFO");
            if (this.parameters != null) {
                int i = 0;
                while (i < this.parameters.size()) {
                    String parameter = (String)this.parameters.elementAt(i);
                    String name = parameter.substring(0, parameter.indexOf("=")).trim().toLowerCase();
                    String value = parameter.substring(parameter.indexOf("=") + 1);
                    ((SipURI)this.requestURI).setParameter(name, value);
                    ++i;
                }
            }
        }
        catch (SipException ex) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(2, "Could not create the INFO request! " + ex.getMessage());
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
    }

    public SipClientConnection initCancel() throws sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 4) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the CANCEL request can not be initialized, because of wrong state.", 5);
        }
        try {
            Request cancelRequest = this.clientTransaction.createCancel();
            SipClientConnectionImpl sipClientConnectionCancel = new SipClientConnectionImpl(cancelRequest, this.sipConnectionNotifier, this.userSipURI);
            return sipClientConnectionCancel;
        }
        catch (SipException se) {
            new sip4me.nist.javax.microedition.sip.SipException(se.getMessage(), 9);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(long timeout) throws sip4me.nist.javax.microedition.sip.SipException, IOException {
        if (this.state != 4) {
            throw new sip4me.nist.javax.microedition.sip.SipException("can not check for any response received, because of wrong state.", 5);
        }
        if (!this.connectionOpen) {
            throw new IOException("The connection has been closed");
        }
        if (this.response == null && timeout != 0L) {
            SipClientConnectionImpl sipClientConnectionImpl = this;
            synchronized (sipClientConnectionImpl) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
        this.changeDialogState();
        this.changeClientConnectionState();
        if (this.state == 5 && this.credentials.size() > 0) {
            this.reoriginateRequest();
        } else if (this.state == 5 && LogWriter.needsLogging) {
            LogWriter.logMessage("Authorization is required but no Credentials were set for this client connection");
        }
        return this.response != null;
    }

    public void setListener(SipClientConnectionListener sccl) throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("The Connection has been closed!");
        }
        this.sipClientConnectionListener = sccl;
    }

    public int enableRefresh(SipRefreshListener srl) throws sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("can not enable the refresh, because of wrong state.", 5);
        }
        if (srl == null) {
            return 0;
        }
        if (!this.request.getMethod().equals("REGISTER") && !this.request.getMethod().equals("SUBSCRIBE")) {
            return 0;
        }
        this.sipRefreshListener = srl;
        int taskID = RefreshManager.getInstance().createRefreshTask(this.request, this.sipConnectionNotifier, this.sipRefreshListener, this);
        this.refreshID = String.valueOf(taskID);
        return taskID;
    }

    public void setCredentials(String username, String password, String realm) throws sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 2 && this.state != 5) {
            throw new sip4me.nist.javax.microedition.sip.SipException("can set the credentials, because of wrong state.", 5);
        }
        if (username == null || password == null || realm == null) {
            throw new NullPointerException();
        }
        Credentials credential = new Credentials(username, password, realm);
        this.credentials.addElement(credential);
        if (this.state == 5) {
            this.reoriginateRequest();
        }
    }

    public void send() throws IOException, InterruptedIOException, sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 3 && this.state != 2 && this.state != 5) {
            throw new sip4me.nist.javax.microedition.sip.SipException("can not send the request, because of wrong state.", 5);
        }
        if (!this.connectionOpen) {
            throw new IOException("The Connection has been closed!");
        }
        if (this.contentOutputStream != null) {
            try {
                this.request.setContent(this.contentOutputStream, (ContentTypeHeader)this.request.getHeader("Content-Type"));
                this.contentOutputStream = null;
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("[SipClientConnection] Sending request " + this.request.getMethod());
        }
        if (!this.request.getFromHeader().hasTag()) {
            this.request.getFromHeader().setTag(StackConnector.generateTag());
        }
        if ((this.request.getMethod().equals("SUBSCRIBE") || this.request.getMethod().equals("INVITE")) && this.request.getHeader("Contact") == null) {
            ContactHeader contactHeader = null;
            try {
                URI contactURI;
                String userPart = "anonymous";
                if (this.userSipURI.indexOf("tel") != -1) {
                    contactURI = StackConnector.addressFactory.createTelURL(this.userSipURI);
                    userPart = ((TelURL)contactURI).getPhoneNumber();
                }
                if (this.userSipURI.indexOf("sip:") != -1) {
                    userPart = this.userSipURI.substring("sip:".length(), this.userSipURI.indexOf("@"));
                }
                contactURI = StackConnector.addressFactory.createSipURI(userPart, this.sipConnectionNotifier.getLocalAddress());
                if (this.stackConnector.sipStack.getListeningPoint(this.sipConnectionNotifier.getLocalPort(), "udp") == null) {
                    ((SipURI)contactURI).setTransportParam("TCP");
                }
                ((SipURI)contactURI).setPort(this.sipConnectionNotifier.getLocalPort());
                contactHeader = StackConnector.headerFactory.createContactHeader(StackConnector.addressFactory.createAddress(contactURI));
            }
            catch (IOException ioe) {
                throw new sip4me.nist.javax.microedition.sip.SipException("Internal Error, cannot get the local port or address", 9);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
                throw new sip4me.nist.javax.microedition.sip.SipException("Problem during the creation of the Contact Header", 9);
            }
            this.request.addHeader(contactHeader);
        }
        try {
            this.clientTransaction = ((SipConnectionNotifierImpl)this.sipConnectionNotifier).getSipProvider().getNewClientTransaction(this.request);
        }
        catch (Throwable tue) {
            tue.printStackTrace();
            throw new sip4me.nist.javax.microedition.sip.SipException("Cannot create a new Client Transaction for this request", 8);
        }
        this.clientTransaction.setApplicationData(this);
        try {
            if (this.request.getMethod().equals("ACK")) {
                try {
                    this.clientTransaction.getDialog().sendAck(this.request);
                }
                catch (SipException se) {
                    throw new sip4me.nist.javax.microedition.sip.SipException(se.getMessage(), 2);
                }
                catch (IllegalArgumentException iae) {
                    iae.printStackTrace();
                }
                this.state = 6;
                return;
            }
            if (this.request.getMethod().equals("BYE") || this.request.getMethod().equals("NOTIFY")) {
                ((SipDialogImpl)this.sipDialog).dialog.sendRequest(this.clientTransaction);
            } else if (this.state != 5 && this.request.getMethod().equals("SUBSCRIBE") && this.refreshID != null && this.request.getCSeqHeaderNumber() > 1) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Sending refresh through existing dialog");
                }
                ((SipDialogImpl)this.sipDialog).dialog.sendRequest(this.clientTransaction);
            } else {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Sending request directly through Client Transaction");
                }
                this.clientTransaction.sendRequest();
            }
        }
        catch (SipException se) {
            throw new sip4me.nist.javax.microedition.sip.SipException(se.getMessage(), 8);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        if (this.request.getMethod().equals("INVITE") || this.request.getMethod().equals("SUBSCRIBE")) {
            this.sipDialog = new SipDialogImpl(this.clientTransaction.getDialog(), this.sipConnectionNotifier, this.requestURI);
            ((SipDialogImpl)this.sipDialog).setSipClientConnectionListener(this.sipClientConnectionListener);
            this.stackConnector.sipDialogList.addElement(this.sipDialog);
        }
        if (this.request.getMethod().equals("REGISTER") && this.stackConnector.sipStack.getRouter().getOutboundProxy() == null) {
            int port;
            SipURI sipURI = (SipURI)this.request.getRequestURI();
            String transport = sipURI.getTransportParam();
            if (transport == null) {
                transport = "UDP";
            }
            if ((port = sipURI.getPort()) < 0) {
                port = 5060;
            }
            this.stackConnector.sipStack.getRouter().setOutboundProxy(String.valueOf(sipURI.getHost()) + ":" + port + "/" + transport);
        }
        this.state = 4;
    }

    public void setHeader(String name, String value) throws sip4me.nist.javax.microedition.sip.SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the Header can not be set, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The header value can not be null");
        }
        Header header = null;
        try {
            header = StackConnector.headerFactory.createHeader(name, value);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
        if (header == null) {
            throw new IllegalArgumentException("null header!");
        }
        if (this.request.getHeader(name) == null) {
            this.request.addHeader(header);
        } else {
            this.request.attachHeader(header, true, true);
        }
    }

    public void addHeader(String name, String value) throws sip4me.nist.javax.microedition.sip.SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the Header can not be added, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The header value can not be null");
        }
        Header header = null;
        try {
            header = StackConnector.headerFactory.createHeader(name, value);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("The header can not be created, check if it is correct");
        }
        this.request.addHeader(header);
    }

    public void removeHeader(String name) throws sip4me.nist.javax.microedition.sip.SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the Header can not be removed, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        this.request.removeHeader(name, true);
    }

    public String[] getHeaders(String name) {
        Enumeration e = this.response.getHeaders(name);
        int size = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++size;
        }
        if (size < 1) {
            return null;
        }
        String[] headers = new String[size];
        e = this.response.getHeaders(name);
        int count = 0;
        while (e.hasMoreElements()) {
            headers[count++] = ((Header)e.nextElement()).getHeaderValue();
        }
        return headers;
    }

    public String getHeader(String name) {
        if (this.response != null) {
            if (this.response.getHeader(name) != null) {
                return this.response.getHeader(name).getHeaderValue();
            }
            return null;
        }
        if (this.request != null && this.request.getHeader(name) != null) {
            return this.request.getHeader(name).getHeaderValue();
        }
        return null;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getRequestURI() {
        return this.request.getRequestURI().toString();
    }

    public int getStatusCode() {
        if (this.response == null) {
            return 0;
        }
        return this.response.getStatusCode();
    }

    public String getReasonPhrase() {
        if (this.response == null) {
            return null;
        }
        return this.response.getReasonPhrase();
    }

    public SipDialog getDialog() {
        return this.sipDialog;
    }

    public InputStream openContentInputStream() throws IOException, sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 6 && this.state != 4) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the content input strean can not be open, because of wrong state.", 5);
        }
        if (!this.connectionOpen) {
            throw new IOException("The Connection has been closed!");
        }
        byte[] buf = this.response.getRawContent();
        this.contentInputStream = new ByteArrayInputStream(buf);
        return this.contentInputStream;
    }

    public OutputStream openContentOutputStream() throws IOException, sip4me.nist.javax.microedition.sip.SipException {
        if (this.state != 2) {
            throw new sip4me.nist.javax.microedition.sip.SipException("the content output strean can not be open, because of wrong state.", 5);
        }
        if (this.request.getHeader("Content-Type") == null) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Content-Type unknown, set the content-type header first", 3);
        }
        if (this.request.getHeader("Content-Length") == null) {
            throw new sip4me.nist.javax.microedition.sip.SipException("Content-Length unknown, set the content-length header first", 4);
        }
        if (!this.connectionOpen) {
            throw new IOException("The Connection has been closed!");
        }
        this.contentOutputStream = new SDPOutputStream(this);
        this.state = 3;
        return this.contentOutputStream;
    }

    public void close() throws IOException {
        this.connectionOpen = false;
        this.listeningThread = null;
        this.state = 7;
    }

    private void reoriginateRequest() {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Authentication is needed for request: " + this.request.getFirstLine());
        }
        this.authResponse = (Response)this.response.clone();
        this.request = this.authenticateRequest(this.request);
        if (this.request != null) {
            RefreshTask task;
            if (this.refreshID != null && (task = RefreshManager.getInstance().getTask(this.refreshID)) != null) {
                task.updateRequest(this.request);
            }
            this.state = 5;
            try {
                this.send();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else if (LogWriter.needsLogging) {
            LogWriter.logMessage(16, "Couldn't create authenticated request for: " + this.request.getFirstLine());
        }
    }

    private void changeClientConnectionState() {
        this.state = this.response == null ? 6 : (this.response.getStatusCode() / 100 == 1 && this.state == 4 ? 4 : (this.state == 4 && (this.response.getStatusCode() == 401 || this.response.getStatusCode() == 407) ? 5 : 6));
    }

    private void changeDialogState() {
        if (this.response == null || this.response.getCSeqHeader().getMethod().equals("REGISTER") || this.response.getCSeqHeader().getMethod().equals("MESSAGE")) {
            return;
        }
        if (this.response.isSuccessfulResponse()) {
            ExpiresHeader expiresHeader;
            if (this.response.getCSeqHeader().getMethod().equals("SUBSCRIBE") && (expiresHeader = (ExpiresHeader)this.request.getHeader("Expires")).getExpires() == 0) {
                ((SipDialogImpl)this.sipDialog).setState((byte)3);
                this.stackConnector.sipDialogList.removeElement(this.sipDialog);
            }
            if (!this.response.getCSeqHeader().getMethod().equals("BYE")) {
                if (this.sipDialog != null) {
                    ((SipDialogImpl)this.sipDialog).setState((byte)2);
                    ((SipDialogImpl)this.sipDialog).setDialogID(this.response.getDialogId(false));
                }
            } else {
                ((SipDialogImpl)this.sipDialog).setState((byte)3);
                this.stackConnector.sipDialogList.removeElement(this.sipDialog);
            }
        } else if (this.sipDialog != null && this.sipDialog.getState() == 1 && this.response.getStatusCode() / 100 != 1) {
            ((SipDialogImpl)this.sipDialog).setState((byte)3);
            this.stackConnector.sipDialogList.removeElement(this.sipDialog);
        }
    }

    protected void updateRequestFromRefresh(Request request) {
        this.request = request;
        this.state = 2;
    }

    protected Request getRequest() {
        return this.request;
    }

    protected String getCallIdentifier() {
        if (this.request == null) {
            return " ";
        }
        return this.request.getCallIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResponseReceived(Response response) {
        if (this.state != 4 && response.getStatusCode() / 100 == 1) {
            return;
        }
        if (this.state == 6 && !response.isSuccessfulResponse()) {
            return;
        }
        this.response = response;
        if (response.getCSeqHeaderNumber() == this.request.getCSeqHeaderNumber()) {
            SipClientConnectionImpl sipClientConnectionImpl = this;
            synchronized (sipClientConnectionImpl) {
                this.notify();
            }
            if (this.sipClientConnectionListener != null) {
                this.sipClientConnectionListener.notifyResponse(this);
            }
        }
        String method = response.getCSeqHeader().getMethod();
        if (this.sipRefreshListener != null && (method.equals("REGISTER") || method.equals("SUBSCRIBE"))) {
            if (response.isSuccessfulResponse()) {
                int lExpire;
                int lRequestedExpire = lExpire = ((ExpiresHeader)this.request.getHeader("Expires")).getExpires();
                ExpiresHeader expiresHeader = (ExpiresHeader)response.getHeader("Expires");
                if (expiresHeader == null) {
                    ContactHeader lContactheader;
                    String lExpireValue;
                    if (response.hasHeader("Contact") && (lExpireValue = (lContactheader = (ContactHeader)response.getContactHeaders().getFirst()).getParameter("expires")) != null) {
                        lExpire = Integer.parseInt(lExpireValue);
                    }
                } else {
                    lExpire = expiresHeader.getExpires();
                }
                if (lExpire > lRequestedExpire) {
                    lExpire = lRequestedExpire;
                }
                if (lExpire > 0) {
                    RefreshManager.getInstance().scheduleTask(this.refreshID, lExpire);
                }
                this.sipRefreshListener.refreshEvent(Integer.parseInt(this.refreshID), response.getStatusCode(), response.getReasonPhrase());
            } else if (response.getStatusCode() >= 300 && this.state != 5) {
                this.sipRefreshListener.refreshEvent(Integer.parseInt(this.refreshID), response.getStatusCode(), response.getReasonPhrase());
            }
        }
    }

    public Request authenticateRequest(Request req) {
        if (this.authHelper == null) {
            this.authHelper = new DigestClientAuthentication(this.credentials);
        }
        return this.authHelper.createNewRequest(this.stackConnector.sipStack, this.request, this.authResponse);
    }
}

