/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.address;

import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.address.TelURL;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.parser.StringMsgParser;
import sip4me.gov.nist.siplite.parser.URLParser;

public class AddressFactory {
    public Address createAddress(String displayName, URI uri) {
        if (uri == null) {
            throw new NullPointerException("null  URI");
        }
        Address addressImpl = new Address();
        if (displayName != null) {
            addressImpl.setDisplayName(displayName);
        }
        addressImpl.setURI(uri);
        return addressImpl;
    }

    public SipURI createSipURI(String uri) throws ParseException {
        if (uri == null) {
            throw new NullPointerException("null URI");
        }
        try {
            StringMsgParser smp = new StringMsgParser();
            SipURI sipUri = smp.parseSIPUrl(uri);
            return sipUri;
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public SipURI createSipURI(String user, String host) throws ParseException {
        if (host == null) {
            throw new NullPointerException("null host");
        }
        StringBuffer uriString = new StringBuffer("sip:");
        if (user != null) {
            uriString.append(user);
            uriString.append("@");
        }
        if (host.indexOf(58) != host.lastIndexOf(58) && host.trim().charAt(0) != '[') {
            host = String.valueOf('[') + host + ']';
        }
        uriString.append(host);
        StringMsgParser smp = new StringMsgParser();
        try {
            SipURI sipUri = smp.parseSIPUrl(uriString.toString());
            return sipUri;
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public TelURL createTelURL(String uri) throws ParseException {
        if (uri == null) {
            throw new NullPointerException("null url");
        }
        if (uri.startsWith("<")) {
            uri = uri.substring(1);
        }
        if (uri.endsWith(">")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        try {
            StringMsgParser smp = new StringMsgParser();
            TelURL timp = (TelURL)smp.parseUrl(uri);
            return timp;
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public Address createAddress(URI uri) {
        if (uri == null) {
            throw new NullPointerException("null address");
        }
        Address addressImpl = new Address();
        addressImpl.setURI(uri);
        return addressImpl;
    }

    public Address createAddress(String address) throws ParseException {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        if (address.equals("*")) {
            Address addressImpl = new Address();
            addressImpl.setAddressType(3);
            return addressImpl;
        }
        StringMsgParser smp = new StringMsgParser();
        return smp.parseAddress(address);
    }

    public URI createURI(String uri) throws ParseException {
        if (uri == null) {
            throw new NullPointerException("null arg");
        }
        try {
            URLParser urlParser = new URLParser(uri);
            String scheme = urlParser.peekScheme();
            if (scheme == null) {
                throw new ParseException("bad scheme", 0);
            }
            if (Utils.equalsIgnoreCase(scheme, "sip")) {
                return urlParser.sipURL();
            }
            if (Utils.equalsIgnoreCase(scheme, "sips")) {
                return urlParser.sipURL();
            }
            if (Utils.equalsIgnoreCase(scheme, "tel")) {
                return urlParser.telURL();
            }
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
        return new URI(uri);
    }
}

