/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.message;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.microedition.sip.SDPOutputStream;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.ContactList;
import sip4me.gov.nist.siplite.header.ContentLengthHeader;
import sip4me.gov.nist.siplite.header.ContentTypeHeader;
import sip4me.gov.nist.siplite.header.FromHeader;
import sip4me.gov.nist.siplite.header.Header;
import sip4me.gov.nist.siplite.header.HeaderList;
import sip4me.gov.nist.siplite.header.RecordRouteList;
import sip4me.gov.nist.siplite.header.RequestLine;
import sip4me.gov.nist.siplite.header.RouteList;
import sip4me.gov.nist.siplite.header.StatusLine;
import sip4me.gov.nist.siplite.header.ToHeader;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.header.ViaList;
import sip4me.gov.nist.siplite.message.ListMap;
import sip4me.gov.nist.siplite.message.MessageFactory;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.parser.HeaderParser;
import sip4me.gov.nist.siplite.parser.ParserFactory;

public abstract class Message
extends GenericObject {
    private static Class sipHeaderListClass;
    protected static final String contentEncodingCharset;
    protected Vector unrecognizedHeaders = new Vector();
    protected Vector headers = new Vector();
    protected FromHeader fromHeader;
    protected ToHeader toHeader;
    protected CSeqHeader cSeqHeader;
    protected CallIdHeader callIdHeader;
    protected ContentLengthHeader contentLengthHeader;
    protected String messageContent;
    protected byte[] messageContentBytes;
    protected Object messageContentObject;
    private Hashtable nameTable = new Hashtable();

    static {
        contentEncodingCharset = MessageFactory.getDefaultContentEncodingCharset();
        try {
            sipHeaderListClass = Class.forName("sip4me.gov.nist.siplite.header.HeaderList");
        }
        catch (ClassNotFoundException ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    public static boolean isRequestHeader(Header sipHeader) {
        return sipHeader.getHeaderName().equals("Alert-Info") || sipHeader.getHeaderName().equals("In-Reply-To") || sipHeader.getHeaderName().equals("Authorization") || sipHeader.getHeaderName().equals("Max-Forwards") || sipHeader.getHeaderName().equals("Priority") || sipHeader.getHeaderName().equals("Proxy-Authorization") || sipHeader.getHeaderName().equals("Proxy-Require") || sipHeader.getHeaderName().equals("Route") || sipHeader.getHeaderName().equals("Subject");
    }

    public static boolean isResponseHeader(Header sipHeader) {
        return sipHeader.getHeaderName().equals("Error-Info") || sipHeader.getHeaderName().equals("Proxy-Authenticate") || sipHeader.getHeaderName().equals("Server") || sipHeader.getHeaderName().equals("Unsupported") || sipHeader.getHeaderName().equals("Retry-After") || sipHeader.getHeaderName().equals("Warning") || sipHeader.getHeaderName().equals("WWW-Authenticate");
    }

    public abstract String getDialogId(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() {
        StringBuffer encoding = new StringBuffer();
        Vector vector = this.headers;
        synchronized (vector) {
            Enumeration it = this.headers.elements();
            while (it.hasMoreElements()) {
                Header siphdr = (Header)it.nextElement();
                if (siphdr instanceof ContentLengthHeader) continue;
                encoding.append(siphdr.encode());
            }
        }
        if (this.contentLengthHeader != null) {
            encoding.append(this.contentLengthHeader.encode()).append("\r\n");
        }
        if (this.messageContentObject != null) {
            String mbody = this.getContent().toString();
            encoding.append(mbody);
        } else if (this.messageContent != null || this.messageContentBytes != null) {
            String content = null;
            try {
                content = this.messageContent != null ? this.messageContent : new String(this.messageContentBytes, contentEncodingCharset);
            }
            catch (Exception ex) {
                content = "";
            }
            encoding.append(content);
        }
        return encoding.toString();
    }

    public byte[] encodeAsBytes() {
        StringBuffer encoding = new StringBuffer();
        Enumeration it = this.headers.elements();
        while (it.hasMoreElements()) {
            Header siphdr = (Header)it.nextElement();
            if (siphdr instanceof ContentLengthHeader) continue;
            encoding.append(siphdr.encode());
        }
        byte[] retval = null;
        byte[] content = this.getRawContent();
        if (content != null) {
            if (this.contentLengthHeader == null) {
                encoding.append("Content-Length: " + content.length + "\r\n");
            } else {
                encoding.append(this.contentLengthHeader.encode());
            }
            encoding.append("\r\n");
            byte[] msgarray = null;
            try {
                msgarray = encoding.toString().getBytes("UTF-8");
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
            }
            retval = new byte[msgarray.length + content.length];
            System.arraycopy(msgarray, 0, retval, 0, msgarray.length);
            System.arraycopy(content, 0, retval, msgarray.length, content.length);
        } else {
            encoding.append("Content-Length: 0\r\n");
            encoding.append("\r\n");
            try {
                retval = encoding.toString().getBytes("UTF-8");
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        return retval;
    }

    public Object clone() {
        Message retval = null;
        try {
            retval = (Message)this.getClass().newInstance();
        }
        catch (IllegalAccessException ex) {
            InternalErrorHandler.handleException(ex);
        }
        catch (InstantiationException ex) {
            InternalErrorHandler.handleException(ex);
        }
        Enumeration li = this.headers.elements();
        while (li.hasMoreElements()) {
            try {
                Header sipHeader = (Header)((Header)li.nextElement()).clone();
                retval.attachHeader(sipHeader);
            }
            catch (ParseException sipHeader) {
                // empty catch block
            }
        }
        if (retval instanceof Request) {
            Request thisRequest = (Request)this;
            RequestLine rl = (RequestLine)thisRequest.getRequestLine().clone();
            ((Request)retval).setRequestLine(rl);
        } else {
            Response thisResponse = (Response)this;
            StatusLine sl = (StatusLine)thisResponse.getStatusLine().clone();
            ((Response)retval).setStatusLine(sl);
        }
        if (this.getContent() != null) {
            try {
                retval.setContent(this.getContent(), this.getContentTypeHeaderHeader());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return retval;
    }

    private void attachHeader(Header h) throws ParseException, IllegalArgumentException {
        HeaderList hl;
        if (h == null) {
            throw new IllegalArgumentException("null header!");
        }
        if (h instanceof HeaderList && (hl = (HeaderList)h).isEmpty()) {
            return;
        }
        this.attachHeader(h, false, false);
    }

    public void setHeader(Header sipHeader) throws IllegalArgumentException {
        HeaderList hl;
        Header header = sipHeader;
        if (header == null) {
            throw new IllegalArgumentException("null header!");
        }
        if (header instanceof HeaderList && (hl = (HeaderList)header).isEmpty()) {
            return;
        }
        this.removeHeader(header.getHeaderName());
        this.attachHeader(header, true, false);
    }

    public void setHeaders(Vector headers) {
        Enumeration elements = headers.elements();
        while (elements.hasMoreElements()) {
            Header sipHeader = (Header)elements.nextElement();
            this.attachHeader(sipHeader, false);
        }
    }

    public void attachHeader(Header h, boolean replaceflag) {
        this.attachHeader(h, replaceflag, false);
    }

    public void attachHeader(Header newHeader, boolean replaceFlag, boolean top) {
        Header headerToAttach;
        if (newHeader == null) {
            throw new NullPointerException("null header");
        }
        if (ListMap.hasList(newHeader) && !sipHeaderListClass.isAssignableFrom(newHeader.getClass())) {
            HeaderList hdrList = ListMap.getList(newHeader);
            hdrList.add(newHeader);
            headerToAttach = hdrList;
        } else {
            headerToAttach = newHeader;
        }
        if (replaceFlag) {
            this.removeHeader(newHeader.getHeaderName());
        } else if (this.nameTable.containsKey(newHeader.getHeaderName().toLowerCase()) && !(headerToAttach instanceof HeaderList)) {
            if (headerToAttach instanceof ContentLengthHeader) {
                try {
                    ContentLengthHeader cl = (ContentLengthHeader)headerToAttach;
                    this.contentLengthHeader.setContentLength(cl.getContentLength());
                }
                catch (IllegalArgumentException cl) {
                    // empty catch block
                }
            }
            return;
        }
        if (!this.nameTable.containsKey(newHeader.getHeaderName().toLowerCase())) {
            this.nameTable.put(newHeader.getHeaderName().toLowerCase(), headerToAttach);
            this.headers.addElement(headerToAttach);
        } else if (headerToAttach instanceof HeaderList) {
            HeaderList existingHdrList = (HeaderList)this.nameTable.get(newHeader.getHeaderName().toLowerCase());
            if (existingHdrList != null) {
                existingHdrList.concatenate((HeaderList)headerToAttach, top);
            } else {
                this.nameTable.put(headerToAttach.getHeaderName().toLowerCase(), headerToAttach);
            }
        } else {
            this.nameTable.put(headerToAttach.getHeaderName().toLowerCase(), headerToAttach);
        }
        if (headerToAttach instanceof FromHeader) {
            this.fromHeader = (FromHeader)headerToAttach;
        } else if (headerToAttach instanceof ContentLengthHeader) {
            this.contentLengthHeader = (ContentLengthHeader)headerToAttach;
        } else if (headerToAttach instanceof ToHeader) {
            this.toHeader = (ToHeader)headerToAttach;
        } else if (headerToAttach instanceof CSeqHeader) {
            this.cSeqHeader = (CSeqHeader)headerToAttach;
        } else if (headerToAttach instanceof CallIdHeader) {
            this.callIdHeader = (CallIdHeader)headerToAttach;
        }
    }

    public void removeHeader(String headerName, boolean top) {
        Header toRemove = (Header)this.nameTable.get(headerName.toLowerCase());
        if (toRemove == null) {
            return;
        }
        if (toRemove instanceof HeaderList) {
            HeaderList hdrList = (HeaderList)toRemove;
            if (top) {
                hdrList.removeFirst();
            } else {
                hdrList.removeLast();
            }
            if (hdrList.isEmpty()) {
                Enumeration li = this.headers.elements();
                int index = -1;
                while (li.hasMoreElements()) {
                    Header sipHeader = (Header)li.nextElement();
                    ++index;
                    if (Utils.equalsIgnoreCase(sipHeader.getName(), headerName)) break;
                }
                if (index != -1 && index < this.headers.size()) {
                    this.headers.removeElementAt(index);
                }
            }
        } else {
            this.nameTable.remove(headerName.toLowerCase());
            if (toRemove instanceof FromHeader) {
                this.fromHeader = null;
            } else if (toRemove instanceof ToHeader) {
                this.toHeader = null;
            } else if (toRemove instanceof CSeqHeader) {
                this.cSeqHeader = null;
            } else if (toRemove instanceof CallIdHeader) {
                this.callIdHeader = null;
            } else if (toRemove instanceof ContentLengthHeader) {
                this.contentLengthHeader = null;
            }
            Enumeration li = this.headers.elements();
            int index = -1;
            while (li.hasMoreElements()) {
                Header sipHeader = (Header)li.nextElement();
                ++index;
                if (Utils.equalsIgnoreCase(sipHeader.getName(), headerName)) break;
            }
            if (index != -1 && index < this.headers.size()) {
                this.headers.removeElementAt(index);
            }
        }
    }

    public void removeHeader(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null arg");
        }
        Header toRemove = (Header)this.nameTable.get(headerName.toLowerCase());
        if (toRemove == null) {
            return;
        }
        this.nameTable.remove(headerName.toLowerCase());
        if (toRemove instanceof FromHeader) {
            this.fromHeader = null;
        } else if (toRemove instanceof ToHeader) {
            this.toHeader = null;
        } else if (toRemove instanceof CSeqHeader) {
            this.cSeqHeader = null;
        } else if (toRemove instanceof CallIdHeader) {
            this.callIdHeader = null;
        } else if (toRemove instanceof ContentLengthHeader) {
            this.contentLengthHeader = null;
        }
        Enumeration li = this.headers.elements();
        int index = -1;
        while (li.hasMoreElements()) {
            Header sipHeader = (Header)li.nextElement();
            ++index;
            if (Utils.equalsIgnoreCase(sipHeader.getName(), headerName)) break;
        }
        if (index != -1 && index < this.headers.size()) {
            this.headers.removeElementAt(index);
        }
    }

    public String getTransactionId() {
        String hc;
        ViaHeader topVia = null;
        if (!this.getViaHeaders().isEmpty()) {
            topVia = (ViaHeader)this.getViaHeaders().first();
        }
        if (topVia.getBranch() != null && topVia.getBranch().startsWith("z9hG4bK")) {
            return topVia.getBranch().toLowerCase();
        }
        StringBuffer retval = new StringBuffer();
        FromHeader from = this.getFromHeader();
        ToHeader to = this.getTo();
        String hpFromHeader = from.getUserAtHostPort();
        retval.append(hpFromHeader).append(":");
        if (from.hasTag()) {
            retval.append(from.getTag()).append(":");
        }
        String hpTo = to.getUserAtHostPort();
        retval.append(hpTo).append(":");
        String cid = this.callIdHeader.getCallId();
        retval.append(cid).append(":");
        retval.append(this.cSeqHeader.getSequenceNumber()).append(":").append(this.cSeqHeader.getMethod());
        retval.append(":").append(topVia.getSentBy().encode());
        if (!topVia.getSentBy().hasPort()) {
            retval.append(":").append(5060);
        }
        if ((hc = Utils.toHexString(retval.toString().toLowerCase().getBytes())).length() < 32) {
            return hc;
        }
        return hc.substring(hc.length() - 32, hc.length() - 1);
    }

    public boolean hasContent() {
        return this.messageContent != null || this.messageContentBytes != null;
    }

    public Enumeration getHeaders() {
        return this.headers.elements();
    }

    public Header getHeader(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null header name");
        }
        Header sipHeader = (Header)this.nameTable.get(headerName.toLowerCase());
        if (sipHeader instanceof HeaderList) {
            return ((HeaderList)sipHeader).getFirst();
        }
        return sipHeader;
    }

    public ContentTypeHeader getContentTypeHeaderHeader() {
        return (ContentTypeHeader)this.getHeader("Content-Type");
    }

    public FromHeader getFromHeader() {
        return this.fromHeader;
    }

    public ContactList getContactHeaders() {
        return (ContactList)this.getHeaderList("Contact");
    }

    public ViaList getViaHeaders() {
        return (ViaList)this.getHeaderList("Via");
    }

    public void setVia(ViaList viaList) {
        this.setHeader(viaList);
    }

    public void setVia(Vector viaList) {
        this.removeHeader("Via");
        int i = 0;
        while (i < viaList.size()) {
            ViaHeader via = (ViaHeader)viaList.elementAt(i);
            this.addHeader(via);
            ++i;
        }
    }

    public void setHeader(HeaderList sipHeaderList) {
        this.setHeader((Header)sipHeaderList);
    }

    public ViaHeader getTopmostVia() {
        if (this.getViaHeaders() == null) {
            return null;
        }
        return (ViaHeader)this.getViaHeaders().getFirst();
    }

    public CSeqHeader getCSeqHeader() {
        return this.cSeqHeader;
    }

    public int getCSeqHeaderNumber() {
        return this.cSeqHeader.getSequenceNumber();
    }

    public RouteList getRouteHeaders() {
        return (RouteList)this.getHeaderList("Route");
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    public void setCallId(CallIdHeader callId) {
        this.setHeader(callId);
    }

    public void setCallId(String callId) throws ParseException {
        if (this.callIdHeader == null) {
            this.setHeader(new CallIdHeader());
        }
        this.callIdHeader.setCallId(callId);
    }

    public String getCallIdentifier() {
        return this.callIdHeader.getCallId();
    }

    public RecordRouteList getRecordRouteHeaders() {
        return (RecordRouteList)this.getHeaderList("Record-Route");
    }

    public ToHeader getTo() {
        return this.toHeader;
    }

    public void setTo(ToHeader to) {
        this.setHeader(to);
    }

    public void setFromHeader(FromHeader from) {
        this.setHeader(from);
    }

    public ContentLengthHeader getContentLengthHeader() {
        return this.contentLengthHeader;
    }

    public String getMessageContent() throws UnsupportedEncodingException {
        if (this.messageContent == null && this.messageContentBytes == null) {
            return null;
        }
        if (this.messageContent == null) {
            String charset;
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.nameTable.get("Content-Type".toLowerCase());
            this.messageContent = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? new String(this.messageContentBytes, charset) : new String(this.messageContentBytes, contentEncodingCharset)) : new String(this.messageContentBytes, contentEncodingCharset);
        }
        return this.messageContent;
    }

    public byte[] getRawContent() {
        block5: {
            try {
                if (this.messageContent != null || this.messageContentBytes != null || this.messageContentObject != null) break block5;
                return null;
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
                return null;
            }
        }
        if (this.messageContentObject != null) {
            String charset;
            String messageContent = String.valueOf(this.messageContentObject);
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.nameTable.get("Content-Type".toLowerCase());
            byte[] messageContentBytes = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? messageContent.getBytes(charset) : messageContent.getBytes(contentEncodingCharset)) : messageContent.getBytes(contentEncodingCharset);
            return messageContentBytes;
        }
        if (this.messageContent != null) {
            String charset;
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.nameTable.get("Content-Type".toLowerCase());
            byte[] messageContentBytes = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? this.messageContent.getBytes(charset) : this.messageContent.getBytes(contentEncodingCharset)) : this.messageContent.getBytes(contentEncodingCharset);
            return messageContentBytes;
        }
        return this.messageContentBytes;
    }

    public void setMessageContent(String type, String subType, String messageContent) throws IllegalArgumentException {
        if (messageContent == null) {
            throw new IllegalArgumentException("messageContent is null");
        }
        ContentTypeHeader ct = new ContentTypeHeader(type, subType);
        this.setHeader(ct);
        this.messageContent = messageContent;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        if (this.getContentLengthHeader() != null) {
            this.getContentLengthHeader().setContentLength(messageContent.length());
        }
    }

    public void setContent(Object content, ContentTypeHeader contentTypeHeader) throws ParseException {
        if (content == null) {
            throw new NullPointerException("null content");
        }
        this.messageContent = null;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        this.setHeader(contentTypeHeader);
        if (content instanceof String) {
            this.messageContent = (String)content;
        } else if (content instanceof SDPOutputStream) {
            this.messageContentBytes = ((SDPOutputStream)content).toByteArray();
        } else if (content instanceof byte[]) {
            this.messageContentBytes = (byte[])content;
        } else {
            this.messageContentObject = content;
        }
        this.computeContentLength(content);
    }

    public void setContent(Object content) {
        if (content == null) {
            throw new NullPointerException("null content");
        }
        String contentString = String.valueOf(content);
        this.setMessageContent(contentString);
        this.removeContent();
        if (content instanceof String) {
            this.messageContent = (String)content;
        } else if (content instanceof SDPOutputStream) {
            this.messageContentBytes = ((SDPOutputStream)content).toByteArray();
        } else if (content instanceof byte[]) {
            this.messageContentBytes = (byte[])content;
        } else {
            this.messageContentObject = content;
        }
        this.computeContentLength(content);
    }

    public Object getContent() {
        if (this.messageContentObject != null) {
            return this.messageContentObject;
        }
        if (this.messageContentBytes != null) {
            return this.messageContentBytes;
        }
        if (this.messageContent != null) {
            return this.messageContent;
        }
        return null;
    }

    public void setMessageContent(String type, String subType, byte[] messageContent) {
        ContentTypeHeader ct = new ContentTypeHeader(type, subType);
        this.setHeader(ct);
        this.setMessageContent(messageContent);
        if (this.getContentLengthHeader() != null) {
            this.getContentLengthHeader().setContentLength(messageContent.length);
        }
    }

    public void setMessageContent(String content) {
        int clength;
        int n = clength = content == null ? 0 : content.length();
        if (this.getContentLengthHeader() != null) {
            this.getContentLengthHeader().setContentLength(clength);
        }
        this.messageContent = content;
        this.messageContentBytes = null;
        this.messageContentObject = null;
    }

    public void setMessageContent(byte[] content) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Setting payload to SIP Message:\n" + new String(content));
        }
        if (this.getContentLengthHeader() != null) {
            this.getContentLengthHeader().setContentLength(content.length);
        }
        this.messageContentBytes = content;
        this.messageContent = null;
        this.messageContentObject = null;
    }

    public void removeContent() {
        this.messageContent = null;
        this.messageContentBytes = null;
        this.messageContentObject = null;
    }

    private void computeContentLength(Object content) {
        int length = 0;
        if (content != null) {
            if (content instanceof String) {
                String charset = null;
                ContentTypeHeader contentTypeHeader = (ContentTypeHeader)this.nameTable.get("Content-Type".toLowerCase());
                if (contentTypeHeader != null) {
                    charset = contentTypeHeader.getCharset();
                }
                if (charset == null) {
                    charset = contentEncodingCharset;
                }
                try {
                    this.messageContentBytes = this.messageContent.getBytes(charset);
                    length = ((String)content).getBytes(charset).length;
                }
                catch (UnsupportedEncodingException ex) {
                    InternalErrorHandler.handleException(ex);
                }
            } else {
                length = content instanceof byte[] ? ((byte[])content).length : String.valueOf(content).length();
            }
        }
        this.contentLengthHeader.setContentLength(length);
    }

    public Enumeration getHeaders(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null headerName");
        }
        Header sipHeader = (Header)this.nameTable.get(headerName.toLowerCase());
        if (sipHeader == null) {
            return new Vector().elements();
        }
        if (sipHeader instanceof HeaderList) {
            return ((HeaderList)sipHeader).getElements();
        }
        Vector<Header> v = new Vector<Header>();
        v.addElement(sipHeader);
        return v.elements();
    }

    private HeaderList getHeaderList(String headerName) {
        return (HeaderList)this.nameTable.get(headerName.toLowerCase());
    }

    public boolean hasHeader(String headerName) {
        return this.nameTable.containsKey(headerName.toLowerCase());
    }

    public boolean hasFromHeaderTag() {
        return this.fromHeader != null && this.fromHeader.getTag() != null;
    }

    public boolean hasToTag() {
        return this.toHeader != null && this.toHeader.getTag() != null;
    }

    public String getFromHeaderTag() {
        return this.fromHeader == null ? null : this.fromHeader.getTag();
    }

    public void setFromHeaderTag(String tag) {
        this.fromHeader.setTag(tag);
    }

    public void setToTag(String tag) {
        this.toHeader.setTag(tag);
    }

    public String getToTag() {
        return this.toHeader == null ? null : this.toHeader.getTag();
    }

    public abstract String getFirstLine();

    public void addHeader(Header sipHeader) {
        Header sh = sipHeader;
        if (sipHeader instanceof ViaHeader) {
            this.attachHeader(sh, false, true);
        } else {
            this.attachHeader(sh, false, false);
        }
    }

    public void addUnparsed(String unparsed) {
        this.unrecognizedHeaders.addElement(unparsed);
    }

    public void addHeader(String sipHeader) {
        String hdrString = String.valueOf(sipHeader.trim()) + "\n";
        try {
            HeaderParser parser = ParserFactory.createParser(sipHeader);
            Header sh = parser.parse();
            this.attachHeader(sh, false);
        }
        catch (ParseException ex) {
            this.unrecognizedHeaders.addElement(hdrString);
        }
    }

    public Enumeration getUnrecognizedHeaders() {
        return this.unrecognizedHeaders.elements();
    }

    public Enumeration getHeaderNames() {
        Enumeration li = this.headers.elements();
        Vector<String> retval = new Vector<String>();
        while (li.hasMoreElements()) {
            Header sipHeader = (Header)li.nextElement();
            String name = sipHeader.getName();
            retval.addElement(name);
        }
        return retval.elements();
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        otherMessage = (Message)other;
        values = this.nameTable.elements();
        if (otherMessage.nameTable.size() == this.nameTable.size()) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            mine = (Header)values.nextElement();
            his = (Header)this.nameTable.get(mine.getHeaderName().toLowerCase());
            if (his == null) {
                return false;
            }
            if (his.equals(mine)) continue;
            return false;
lbl13:
            // 2 sources

            ** while (values.hasMoreElements())
        }
lbl14:
        // 1 sources

        return true;
    }

    public void setContentLength(ContentLengthHeader contentLength) {
        this.setHeader(contentLength);
    }

    public void setCSeqHeader(CSeqHeader cseqHeader) {
        this.setHeader(cseqHeader);
    }

    public abstract void setSIPVersion(String var1) throws ParseException;

    public abstract String getSIPVersion();
}

