/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import java.util.Vector;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.NameValueList;
import sip4me.gov.nist.siplite.SIPUtils;
import sip4me.gov.nist.siplite.SipException;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.address.Hop;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.header.ContactHeader;
import sip4me.gov.nist.siplite.header.ContactList;
import sip4me.gov.nist.siplite.header.RecordRouteHeader;
import sip4me.gov.nist.siplite.header.RecordRouteList;
import sip4me.gov.nist.siplite.header.RouteHeader;
import sip4me.gov.nist.siplite.header.RouteList;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.header.ViaList;
import sip4me.gov.nist.siplite.message.Message;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.Dialog;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.SIPServerException;
import sip4me.gov.nist.siplite.stack.SIPServerResponseInterface;
import sip4me.gov.nist.siplite.stack.SIPTransactionStack;
import sip4me.gov.nist.siplite.stack.ServerLog;
import sip4me.gov.nist.siplite.stack.Transaction;

public class ClientTransaction
extends Transaction
implements SIPServerResponseInterface {
    private Request lastRequest;
    private boolean eventPending;
    private int viaPort;
    private String viaHost;
    private SIPServerResponseInterface respondTo;
    private Hop nextHop;

    protected ClientTransaction(SIPTransactionStack newSIPMessageStack, MessageChannel newChannelToHeaderUse) {
        super(newSIPMessageStack, newChannelToHeaderUse);
        this.setBranch(SIPUtils.generateBranchId());
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Creating clientTransaction " + this);
        }
    }

    public void setResponseInterface(SIPServerResponseInterface newRespondToHeader) {
        this.respondTo = newRespondToHeader;
    }

    public String getProcessingInfo() {
        return this.respondTo.getProcessingInfo();
    }

    public MessageChannel getRequestChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(Message messageToHeaderTest) {
        ViaList viaHeaders = messageToHeaderTest.getViaHeaders();
        String messageBranch = ((ViaHeader)viaHeaders.getFirst()).getBranch();
        boolean rfc3261Compliant = this.getBranch() != null && messageBranch != null && this.getBranch().startsWith("z9hG4bK") && messageBranch.startsWith("z9hG4bK");
        boolean transactionMatches = false;
        if (!this.isTerminated()) {
            if (rfc3261Compliant) {
                if (this.getBranch().equals(((ViaHeader)viaHeaders.getFirst()).getBranch())) {
                    transactionMatches = this.getOriginalRequest().getCSeqHeader().getMethod().equals(messageToHeaderTest.getCSeqHeader().getMethod());
                }
            } else {
                transactionMatches = this.getOriginalRequest().getTransactionId().equals(messageToHeaderTest.getTransactionId());
            }
        }
        return transactionMatches;
    }

    public void sendMessage(Message messageToHeaderSend) throws IOException {
        Request transactionRequest = (Request)messageToHeaderSend;
        ViaHeader topVia = (ViaHeader)transactionRequest.getViaHeaders().getFirst();
        topVia.setBranch(this.getBranch());
        if (this.getState() == -1) {
            this.setOriginalRequest(transactionRequest);
            if (transactionRequest.getMethod().equals("INVITE")) {
                this.setState(2);
            } else if (transactionRequest.getMethod().equals("ACK")) {
                this.setState(6);
            } else {
                this.setState(1);
            }
            if (!this.isReliable()) {
                this.enableRetransmissionTimer();
            }
            if (this.isInviteTransaction()) {
                this.enableTimeoutTimer(64);
            } else {
                this.enableTimeoutTimer(64);
            }
        } else if ((this.getState() == 3 || this.getState() == 2) && transactionRequest.getMethod().equals("ACK")) {
            this.setState(6);
            this.getMessageChannel().sendMessage(transactionRequest);
            return;
        }
        try {
            this.lastRequest = transactionRequest;
            this.getMessageChannel().sendMessage(transactionRequest);
        }
        catch (IOException e) {
            this.setState(6);
            throw e;
        }
    }

    public synchronized void processResponse(Response transactionResponse, MessageChannel sourceChannel) throws SIPServerException {
        if (ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
            this.logResponse(transactionResponse, System.currentTimeMillis(), "normal processing");
        }
        if (this.getState() == 4 && transactionResponse.getStatusCode() / 100 == 1) {
            return;
        }
        if (3 == this.getState() && transactionResponse.getStatusCode() == 100) {
            return;
        }
        if (this.eventPending) {
            return;
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("processing " + transactionResponse.getFirstLine() + "current state = " + this.getState());
        }
        this.lastResponse = transactionResponse;
        if (this.dialog != null) {
            this.dialog.addRoute(transactionResponse);
        }
        String method = transactionResponse.getCSeqHeader().getMethod();
        if (this.dialog != null) {
            SIPTransactionStack sipStackImpl = (SIPTransactionStack)this.getSIPStack();
            if (this.dialog.getRemoteTag() == null && transactionResponse.getTo().getTag() != null) {
                if (transactionResponse.getStatusCode() != 100) {
                    this.dialog.setRemoteTag(transactionResponse.getToTag());
                }
                String dialogId = transactionResponse.getDialogId(false);
                this.dialog.setDialogId(dialogId);
                if (sipStackImpl.isDialogCreated(method) && transactionResponse.getStatusCode() != 100) {
                    sipStackImpl.putDialog(this.dialog);
                    if (transactionResponse.getStatusCode() / 100 == 1) {
                        this.dialog.setState(1);
                    } else if (transactionResponse.isSuccessfulResponse()) {
                        this.dialog.setState(2);
                    }
                }
            } else if (this.dialog.getRemoteTag() != null && transactionResponse.getToTag() != null && !this.dialog.getRemoteTag().equals(transactionResponse.getToTag())) {
                this.dialog.setRemoteTag(transactionResponse.getToTag());
                String dialogId = transactionResponse.getDialogId(false);
                this.dialog.setDialogId(dialogId);
                if (sipStackImpl.isDialogCreated(method)) {
                    sipStackImpl.putDialog(this.dialog);
                }
            }
            if (sipStackImpl.isDialogCreated(method)) {
                if (transactionResponse.getTo().getTag() != null && transactionResponse.isSuccessfulResponse()) {
                    this.dialog.setRemoteTag(transactionResponse.getToTag());
                    this.dialog.setState(2);
                } else if (transactionResponse.getStatusCode() >= 300 && (this.dialog.getState() == -1 || this.dialog.getState() == 1)) {
                    this.dialog.setState(4);
                }
            }
            if (transactionResponse.getCSeqHeader().getMethod().equals("BYE") && transactionResponse.isSuccessfulResponse()) {
                this.dialog.setState(4);
            }
        }
        try {
            if (this.isInviteTransaction()) {
                this.inviteClientTransaction(transactionResponse, sourceChannel);
            } else {
                this.nonInviteClientTransaction(transactionResponse, sourceChannel);
            }
        }
        catch (IOException ex) {
            this.setState(6);
            this.raiseErrorEvent(2);
        }
    }

    private void nonInviteClientTransaction(Response transactionResponse, MessageChannel sourceChannel) throws IOException, SIPServerException {
        int currentState = this.getState();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("nonInviteClientTransaction " + transactionResponse.getFirstLine());
            LogWriter.logMessage("currentState = " + currentState);
        }
        int statusCode = transactionResponse.getStatusCode();
        if (currentState == 1) {
            if (statusCode / 100 == 1) {
                this.setState(3);
                this.enableRetransmissionTimer(8);
                this.enableTimeoutTimer(64);
            } else if (transactionResponse.isFinalResponse()) {
                this.respondTo.processResponse(transactionResponse, this);
                if (!this.isReliable()) {
                    this.setState(4);
                    this.enableTimeoutTimer(7);
                } else {
                    this.setState(6);
                }
            }
        } else if (currentState == 3 && transactionResponse.isFinalResponse()) {
            this.respondTo.processResponse(transactionResponse, this);
            this.disableRetransmissionTimer();
            this.disableTimeoutTimer();
            if (!this.isReliable()) {
                this.setState(4);
                this.enableTimeoutTimer(7);
            } else {
                this.setState(6);
            }
        }
    }

    private void inviteClientTransaction(Response transactionResponse, MessageChannel sourceChannel) throws IOException, SIPServerException {
        int statusCode = transactionResponse.getStatusCode();
        int currentState = this.getState();
        if (currentState == 6) {
            boolean ackAlreadySent = false;
            if (this.dialog != null && this.dialog.isAckSeen() && this.dialog.getLastAck() != null && this.dialog.getLastAck().getCSeqHeader().getSequenceNumber() == transactionResponse.getCSeqHeader().getSequenceNumber()) {
                ackAlreadySent = true;
            }
            if (ackAlreadySent && transactionResponse.getCSeqHeader().getMethod().equals(this.dialog.getFirstTransaction().getOriginalRequest().getMethod())) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(16, "resending ACK");
                }
                this.dialog.resendAck();
            }
            return;
        }
        if (currentState == 2) {
            if (transactionResponse.isSuccessfulResponse()) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(6);
                this.respondTo.processResponse(transactionResponse, this);
            } else if (statusCode / 100 == 1) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(3);
                this.respondTo.processResponse(transactionResponse, this);
            } else if (300 <= statusCode && statusCode <= 699) {
                try {
                    this.sendMessage(this.createAck());
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                this.respondTo.processResponse(transactionResponse, this);
                if (!this.isReliable()) {
                    this.setState(4);
                    this.enableTimeoutTimer(49);
                } else {
                    this.setState(6);
                }
            }
        } else if (currentState == 3) {
            if (statusCode / 100 == 1) {
                this.respondTo.processResponse(transactionResponse, this);
            } else if (transactionResponse.isSuccessfulResponse()) {
                this.setState(6);
                this.respondTo.processResponse(transactionResponse, this);
            } else if (300 <= statusCode && statusCode <= 699) {
                try {
                    this.sendMessage(this.createAck());
                }
                catch (SipException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (!this.isReliable()) {
                    this.setState(4);
                    this.enableTimeoutTimer(49);
                } else {
                    this.setState(6);
                }
                this.respondTo.processResponse(transactionResponse, this);
            }
        } else if (currentState == 4 && 300 <= statusCode && statusCode <= 699) {
            try {
                this.sendMessage(this.createAck());
            }
            catch (SipException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
    }

    public void sendRequest() throws SipException {
        Request sipRequest = this.getOriginalRequest();
        try {
            this.sendMessage(sipRequest);
        }
        catch (IOException ex) {
            throw new SipException(ex.getMessage());
        }
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.getState() == -1) {
                return;
            }
            if (this.getState() == 2 || this.getState() == 1) {
                this.getMessageChannel().sendMessage(this.lastRequest);
            }
        }
        catch (IOException e) {
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        Dialog dialogImpl = this.getDialog();
        if (this.getState() == 2 || this.getState() == 1 || this.getState() == 3) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(16, "Transaction timed out! (no response) " + this);
            }
            if (dialogImpl != null) {
                if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod())) {
                    dialogImpl.setState(4);
                } else if (this.getOriginalRequest().getMethod().equals("BYE")) {
                    dialogImpl.setState(4);
                }
            }
        }
        if (this.getState() != 4) {
            this.raiseErrorEvent(1);
        } else {
            this.setState(6);
        }
    }

    public Request createCancel() throws SipException {
        Request originalRequest = this.getOriginalRequest();
        if (originalRequest.getMethod().equals("ACK")) {
            throw new SipException("Cannot Cancel ACK!");
        }
        return originalRequest.createCancelRequest();
    }

    public Request createAck() throws SipException {
        RouteHeader route;
        Request originalRequest = this.getOriginalRequest();
        if (originalRequest.getMethod().equals("ACK")) {
            throw new SipException("Cannot ACK an ACK!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        Request ackRequest = originalRequest.createAckRequest(this.lastResponse.getTo());
        RecordRouteList recordRouteList = this.lastResponse.getRecordRouteHeaders();
        if (recordRouteList == null) {
            return ackRequest;
        }
        ackRequest.removeHeader("Route");
        RouteList routeList = new RouteList();
        Vector li = recordRouteList.getHeaders();
        int i = li.size() - 1;
        while (i >= 0) {
            RecordRouteHeader rr = (RecordRouteHeader)li.elementAt(i);
            route = new RouteHeader();
            route.setAddress((Address)rr.getAddress().clone());
            route.setParameters((NameValueList)rr.getParameters().clone());
            routeList.add(route);
            --i;
        }
        ContactHeader contact = null;
        ContactList contactList = this.lastResponse.getContactHeaders();
        if (contactList != null && !contactList.isEmpty()) {
            contact = (ContactHeader)contactList.getFirst();
        }
        if (!((SipURI)((RouteHeader)routeList.getFirst()).getAddress().getURI()).hasLrParam()) {
            route = new RouteHeader();
            if (contact != null) {
                route.setAddress((Address)contact.getAddress().clone());
            }
            RouteHeader firstRoute = (RouteHeader)routeList.getFirst();
            routeList.removeFirst();
            URI uri = firstRoute.getAddress().getURI();
            ackRequest.setRequestURI(uri);
            if (contact != null) {
                routeList.add(route);
            }
            ackRequest.addHeader(routeList);
        } else {
            if (contact != null) {
                URI uri = (URI)contact.getAddress().getURI().clone();
                ackRequest.setRequestURI(uri);
            }
            ackRequest.addHeader(routeList);
        }
        return ackRequest;
    }

    public void setNextHop(Hop hop) {
        this.nextHop = hop;
    }

    public Hop getNextHop() {
        return this.nextHop;
    }

    protected void setViaPort(int port) {
        this.viaPort = port;
    }

    protected void setViaHost(String host) {
        this.viaHost = host;
    }

    public int getViaPort() {
        return this.viaPort;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public ViaHeader getOutgoingViaHeader() {
        return this.getMessageProcessor().getViaHeader();
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public void clearEventPending() {
        this.eventPending = false;
    }

    public void setEventPending() {
        this.eventPending = true;
    }

    public void setState(int newState) {
        super.setState(newState);
    }
}

