/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.siplite.address.Hop;
import sip4me.gov.nist.siplite.header.EventHeader;
import sip4me.gov.nist.siplite.message.Message;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.ClientTransaction;
import sip4me.gov.nist.siplite.stack.Dialog;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.SIPMessageStack;
import sip4me.gov.nist.siplite.stack.SIPServerRequestInterface;
import sip4me.gov.nist.siplite.stack.SIPServerResponseInterface;
import sip4me.gov.nist.siplite.stack.SIPStackMessageFactory;
import sip4me.gov.nist.siplite.stack.SIPTransactionErrorEvent;
import sip4me.gov.nist.siplite.stack.SIPTransactionEventListener;
import sip4me.gov.nist.siplite.stack.ServerTransaction;
import sip4me.gov.nist.siplite.stack.Transaction;

public abstract class SIPTransactionStack
extends SIPMessageStack
implements SIPTransactionEventListener {
    public static final int BASE_TIMER_INTERVAL = 650;
    private final Vector clientTransactions;
    private final Vector serverTransactions;
    private final Hashtable dialogTable;
    protected int transactionTableSize = -1;
    protected boolean retransmissionFilter;
    protected Hashtable dialogCreatingMethods = new Hashtable();

    protected SIPTransactionStack() {
        this.dialogCreatingMethods.put("REFER", "");
        this.dialogCreatingMethods.put("INVITE", "");
        this.dialogCreatingMethods.put("SUBSCRIBE", "");
        this.clientTransactions = new Vector();
        this.serverTransactions = new Vector();
        this.dialogTable = new Hashtable();
        new Thread(new TransactionScanner()).start();
    }

    private void printDialogCreatingMethods() {
        System.out.println("PRINTING DIALOGCREATINGMETHODS HASHTABLE");
        Enumeration e = this.dialogCreatingMethods.keys();
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement());
        }
        System.out.println("DIALOGCREATINGMETHODS HASHTABLE PRINTED");
    }

    public boolean isDialogCreated(String method) {
        return this.dialogCreatingMethods.containsKey(method.toUpperCase());
    }

    public void addExtensionMethod(String extensionMethod) {
        if (!extensionMethod.equals("NOTIFY")) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("NOTIFY Supported Natively");
            }
        } else {
            this.dialogCreatingMethods.put(extensionMethod, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDialog(Dialog dialog) {
        String dialogId = dialog.getDialogId();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("putDialog " + dialog + " with dialogId=" + dialogId);
        }
        if (this.dialogTable.containsKey(dialogId)) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Not adding dialog to table because it is already there\nDialogID: " + dialogId + "\nDialog: " + this.dialogTable.get(dialogId));
            }
            return;
        }
        dialog.setStack(this);
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            this.dialogTable.put(dialogId, dialog);
        }
    }

    public synchronized Dialog createDialog(Transaction transaction) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("[SIPTransactionStack] Creating dialog for transaction " + transaction);
        }
        return new Dialog(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dialog getDialog(String dialogId) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Getting dialog for " + dialogId);
        }
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            return (Dialog)this.dialogTable.get(dialogId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClientTransaction findSubscribeTransaction(Request notifyMessage) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            ClientTransaction ct;
            String fromTag;
            Request sipRequest;
            EventHeader hisEvent;
            Enumeration it = this.clientTransactions.elements();
            String thisToHeaderTag = notifyMessage.getTo().getTag();
            if (thisToHeaderTag == null) {
                return null;
            }
            EventHeader eventHdr = (EventHeader)notifyMessage.getHeader("Event");
            if (eventHdr == null) {
                return null;
            }
            do {
                if (!it.hasMoreElements()) {
                    return null;
                }
                ct = (ClientTransaction)it.nextElement();
                sipRequest = ct.getOriginalRequest();
                fromTag = sipRequest.getFromHeader().getTag();
            } while ((hisEvent = (EventHeader)sipRequest.getHeader("Event")) == null || !sipRequest.getMethod().equals("SUBSCRIBE") || !Utils.equalsIgnoreCase(fromTag, thisToHeaderTag) || hisEvent == null || !eventHdr.match(hisEvent) || !Utils.equalsIgnoreCase(notifyMessage.getCallId().getCallId(), sipRequest.getCallId().getCallId()));
            return ct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction findTransaction(Message sipMessage, boolean isServer) {
        if (isServer) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("searching server transaction for " + sipMessage + " size =  " + this.serverTransactions.size());
            }
            Vector vector = this.serverTransactions;
            synchronized (vector) {
                Enumeration it = this.serverTransactions.elements();
                while (it.hasMoreElements()) {
                    ServerTransaction sipServerTransaction = (ServerTransaction)it.nextElement();
                    if (!sipServerTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                    return sipServerTransaction;
                }
            }
        }
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            Enumeration it = this.clientTransactions.elements();
            while (it.hasMoreElements()) {
                ClientTransaction clientTransaction = (ClientTransaction)it.nextElement();
                if (!clientTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                return clientTransaction;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction findInviteTransactionToCancel(Request cancelRequest, boolean isServer) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("findInviteTransactionToCancel. CANCEL request= \n" + cancelRequest + "\nfindCancelRequest isServer=" + isServer);
        }
        if (isServer) {
            Vector vector = this.serverTransactions;
            synchronized (vector) {
                Enumeration li = this.serverTransactions.elements();
                while (li.hasMoreElements()) {
                    Transaction transaction = (Transaction)li.nextElement();
                    Request sipRequest = transaction.getRequest();
                    ServerTransaction sipServerTransaction = (ServerTransaction)transaction;
                    if (!sipServerTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage(32, "Found INVITE to cancel: " + sipServerTransaction.getOriginalRequest().encode());
                    }
                    return sipServerTransaction;
                }
            }
        }
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            Enumeration li = this.clientTransactions.elements();
            while (li.hasMoreElements()) {
                Transaction transaction = (Transaction)li.nextElement();
                Request sipRequest = transaction.getRequest();
                ClientTransaction sipClientTransaction = (ClientTransaction)transaction;
                if (!sipClientTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(32, "Found INVITE to cancel: " + sipClientTransaction.getOriginalRequest().encode());
                }
                return sipClientTransaction;
            }
        }
        return null;
    }

    protected SIPTransactionStack(SIPStackMessageFactory messageFactory) {
        this();
        this.sipMessageFactory = messageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIPServerRequestInterface newSIPServerRequest(Request requestReceived, MessageChannel requestMessageChannel) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("SIPTransactionStack: creating new Request " + requestReceived.getFirstLine());
        }
        try {
            Vector vector = this.serverTransactions;
            synchronized (vector) {
                Enumeration transactionIterator = this.serverTransactions.elements();
                ServerTransaction currentTransaction = null;
                while (transactionIterator.hasMoreElements() && currentTransaction == null) {
                    ServerTransaction nextTransaction = (ServerTransaction)transactionIterator.nextElement();
                    if (!nextTransaction.isMessagePartOfTransaction(requestReceived)) continue;
                    currentTransaction = nextTransaction;
                }
                if (currentTransaction == null) {
                    currentTransaction = this.createServerTransaction(requestMessageChannel);
                    currentTransaction.setOriginalRequest(requestReceived);
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Created server transaction: " + currentTransaction);
                    }
                    if (!this.isDialogCreated(requestReceived.getMethod())) {
                        String dialogId = requestReceived.getDialogId(true);
                        Dialog dialog = this.getDialog(dialogId);
                        if (LogWriter.needsLogging) {
                            LogWriter.logMessage("Non-dialog creating request with dialogID = " + dialogId + ".\n " + "Existing dialog found?: " + dialog);
                        }
                        if (dialog != null && (requestReceived.getMethod().equals("ACK") || requestReceived.getCSeqHeader().getSequenceNumber() > dialog.getRemoteSequenceNumber())) {
                            if (LogWriter.needsLogging) {
                                LogWriter.logMessage("Adding server transaction for a request inside a dialog: " + currentTransaction);
                            }
                            this.serverTransactions.addElement(currentTransaction);
                            currentTransaction.isMapped = true;
                        } else {
                            if (!requestReceived.getMethod().equals("NOTIFY") && LogWriter.needsLogging) {
                                LogWriter.logMessage("Adding server transaction for a request outside a dialog");
                            }
                            this.serverTransactions.addElement(currentTransaction);
                            currentTransaction.isMapped = true;
                        }
                    } else {
                        String dialogId = requestReceived.getDialogId(true);
                        Dialog dialog = this.getDialog(dialogId);
                        if (dialog != null && requestReceived.getCSeqHeader().getSequenceNumber() > dialog.getRemoteSequenceNumber()) {
                            try {
                                currentTransaction.map();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.serverTransactions.addElement(currentTransaction);
                            currentTransaction.toListener = true;
                        }
                    }
                }
                currentTransaction.setRequestInterface(super.newSIPServerRequest(requestReceived, currentTransaction));
                return currentTransaction;
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIPServerResponseInterface newSIPServerResponse(Response responseReceived, MessageChannel responseMessageChannel) {
        ClientTransaction currentTransaction;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("SIPTransactionStack: creating new Response " + responseReceived.getFirstLine());
        }
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            Enumeration transactionIterator = this.clientTransactions.elements();
            currentTransaction = null;
            while (transactionIterator.hasMoreElements() && currentTransaction == null) {
                ClientTransaction nextTransaction = (ClientTransaction)transactionIterator.nextElement();
                if (!nextTransaction.isMessagePartOfTransaction(responseReceived)) continue;
                currentTransaction = nextTransaction;
            }
        }
        if (currentTransaction == null) {
            return null;
        }
        currentTransaction.setResponseInterface(super.newSIPServerResponse(responseReceived, currentTransaction));
        return currentTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(Hop nextHop) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            MessageChannel mc;
            block4: {
                mc = super.createMessageChannel(nextHop);
                if (mc != null) break block4;
                return null;
            }
            ClientTransaction returnChannel = this.createClientTransaction(mc);
            this.clientTransactions.addElement(returnChannel);
            returnChannel.setViaPort(nextHop.getPort());
            returnChannel.setViaHost(nextHop.getHost());
            return returnChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(MessageChannel rawChannel) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            ClientTransaction returnChannel = this.createClientTransaction(rawChannel);
            this.clientTransactions.addElement(returnChannel);
            returnChannel.setViaPort(rawChannel.getViaPort());
            returnChannel.setViaHost(rawChannel.getHost());
            return returnChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(Transaction transaction) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            ClientTransaction returnChannel = this.createClientTransaction(transaction.getMessageChannel());
            this.clientTransactions.addElement(returnChannel);
            returnChannel.setViaPort(transaction.getViaPort());
            returnChannel.setViaHost(transaction.getViaHost());
            return returnChannel;
        }
    }

    public ClientTransaction createClientTransaction(MessageChannel encapsulatedMessageChannel) {
        return new ClientTransaction(this, encapsulatedMessageChannel);
    }

    public ServerTransaction createServerTransaction(MessageChannel encapsulatedMessageChannel) {
        return new ServerTransaction(this, encapsulatedMessageChannel);
    }

    public MessageChannel createRawMessageChannel(Hop hop) {
        return super.createMessageChannel(hop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(ClientTransaction clientTransaction) {
        Vector vector = this.clientTransactions;
        synchronized (vector) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Adding client transaction to stack: " + clientTransaction);
            }
            this.clientTransactions.addElement(clientTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(ServerTransaction serverTransaction) throws IOException {
        Vector vector = this.serverTransactions;
        synchronized (vector) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Adding server transaction to stack: " + serverTransaction);
            }
            serverTransaction.map();
            this.serverTransactions.addElement(serverTransaction);
        }
    }

    public abstract /* synthetic */ void transactionErrorEvent(SIPTransactionErrorEvent var1);

    class TransactionScanner
    implements Runnable {
        TransactionScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (SIPTransactionStack.this.isAlive()) {
                try {
                    int j;
                    Transaction nextTransaction;
                    Enumeration transactionIterator;
                    Thread.sleep(650L);
                    Vector<Transaction> fireList = new Vector<Transaction>();
                    Vector<Object> removeList = new Vector<Object>();
                    Cloneable cloneable = SIPTransactionStack.this.serverTransactions;
                    synchronized (cloneable) {
                        transactionIterator = SIPTransactionStack.this.serverTransactions.elements();
                        while (transactionIterator.hasMoreElements()) {
                            nextTransaction = (Transaction)transactionIterator.nextElement();
                            if (nextTransaction.isTerminated()) {
                                if (((ServerTransaction)nextTransaction).collectionTime == 0) {
                                    if (LogWriter.needsLogging) {
                                        LogWriter.logMessage("removing" + nextTransaction);
                                    }
                                    removeList.addElement(nextTransaction);
                                    continue;
                                }
                                --((ServerTransaction)nextTransaction).collectionTime;
                                continue;
                            }
                            fireList.addElement(nextTransaction);
                        }
                        j = 0;
                        while (j < removeList.size()) {
                            SIPTransactionStack.this.serverTransactions.removeElement(removeList.elementAt(j));
                            ++j;
                        }
                    }
                    removeList = new Vector();
                    cloneable = SIPTransactionStack.this.clientTransactions;
                    synchronized (cloneable) {
                        transactionIterator = SIPTransactionStack.this.clientTransactions.elements();
                        while (transactionIterator.hasMoreElements()) {
                            nextTransaction = (Transaction)transactionIterator.nextElement();
                            if (nextTransaction.isTerminated()) {
                                if (LogWriter.needsLogging) {
                                    LogWriter.logMessage("Removing clientTransaction " + nextTransaction);
                                }
                                removeList.addElement(nextTransaction);
                                continue;
                            }
                            fireList.addElement(nextTransaction);
                        }
                        j = 0;
                        while (j < removeList.size()) {
                            SIPTransactionStack.this.clientTransactions.removeElement(removeList.elementAt(j));
                            ++j;
                        }
                    }
                    removeList = new Vector();
                    cloneable = SIPTransactionStack.this.dialogTable;
                    synchronized (cloneable) {
                        Enumeration values = SIPTransactionStack.this.dialogTable.elements();
                        while (values.hasMoreElements()) {
                            Response response;
                            Transaction transaction;
                            Dialog d = (Dialog)values.nextElement();
                            if (d.getState() == 4) {
                                if (LogWriter.needsLogging) {
                                    String dialogId = d.getDialogId();
                                    LogWriter.logMessage("Removing Dialog " + dialogId);
                                }
                                removeList.addElement(d);
                            }
                            if (!d.isServer() || d.ackSeen || !d.isInviteDialog() || (transaction = d.getLastTransaction()).getState() != 6 || !(transaction instanceof ServerTransaction) || !((ServerTransaction)transaction).isMapped || !(response = transaction.getLastResponse()).isSuccessfulResponse()) continue;
                            try {
                                try {
                                    if (d.toRetransmitFinalResponse()) {
                                        transaction.sendMessage(response);
                                    }
                                }
                                catch (IOException ex) {
                                    d.setState(4);
                                    fireList.addElement(transaction);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                fireList.addElement(transaction);
                                throw throwable;
                            }
                            fireList.addElement(transaction);
                        }
                        int j2 = 0;
                        while (j2 < removeList.size()) {
                            Dialog d = (Dialog)removeList.elementAt(j2);
                            SIPTransactionStack.this.dialogTable.remove(d.getDialogId());
                            ++j2;
                        }
                    }
                    int i = 0;
                    while (i < fireList.size()) {
                        nextTransaction = (Transaction)fireList.elementAt(i);
                        nextTransaction.fireTimer();
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

