;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-get-default-backend
  (lambda (get-backends-proc best-backend warning-msg) 
    (let (
	  (backends (get-backends-proc))
	  )
      (if (eqv? backends '())
	  (begin
	    (lw6-log-warning warning-msg)
	    #f
	    )
	  (if (assoc-ref backends best-backend)
	      best-backend
	      (caar backends)))
       )))

(define lw6-get-default-gfx-backend
  (lambda () 
    (lw6-get-default-backend c-lw6gfx-get-backends 
			     "gl"
			     (_ "no gfx backend found"))
    ))

(define lw6-get-default-snd-backend
  (lambda () 
    (lw6-get-default-backend c-lw6snd-get-backends 
			     "ogg"
			     (_ "no snd backend found"))
    ))

(define lw6-check-backend
  (lambda (get-backends-proc backend best-backend warning-msg)
    (let (
	  (backends (get-backends-proc))
	  )
      (if (eqv? backends '())
	  (begin
	    (lw6-log-warning warning-msg)
	    #f
	    )
	  (if (assoc-ref backends backend)
	      backend
	      (lw6-get-default-backend get-backends-proc best-backend warning-msg)))
       )))

(define lw6-check-gfx-backend
  (lambda (backend)
    (lw6-check-backend c-lw6gfx-get-backends
		       backend
		       "gl"
		       (format #f (_ "gfx backend ~a not available") backend))
    ))

(define lw6-check-snd-backend
  (lambda (backend)
    (lw6-check-backend c-lw6snd-get-backends
		       backend
		       "ogg"
		       (format #f (_ "snd backend ~a not available") backend))
    ))
