;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define %lw6-frames-per-sec 0)

(define lw6-game-loop 
  (lambda () 
    (begin
      (lw6-log-info (_ "begin main game loop"))
      (let* (
	     (ticks-0 (c-lw6gfx-get-ticks))
	     (command-count 0)
	     (io-count 0)
	     (frame-count 0)
	     (checkpoint-period (lw6-config-get-number lw6def-checkpoint-period))
	     (last-checkpoint ticks-0)
	     (next-checkpoint (+ ticks-0 checkpoint-period))
	     (frames-checkpoint-counter 0)
	     (rounds-at-last-checkpoint 0)
	    )
	(while (not (c-lw6gfx-poll-quit))
	       (let (
		     (ticks (- (c-lw6gfx-get-ticks) ticks-0))
		     (command-incr (quotient 1000 (lw6-config-get-number lw6def-commands-per-sec)))
		     (io-incr (quotient 1000 (lw6-config-get-number lw6def-io-per-sec)))
		     (frame-incr (quotient 1000 (lw6-config-get-number lw6def-frames-per-sec)))
		     )
		 (begin 
		   (if (< frame-count ticks)
		       (begin
					; First step, process basic I/O
					; this does not happen so often,
					; to avoid wasting events (which
					; can be expensive over the network)
					; and prevent the user interface
					; from being "too fast"
			 (while (and (not (c-lw6gfx-poll-quit)) 
				     (< io-count ticks)
				     )
				(begin
				  (lw6-io)
				  (set! io-count (+ io-count io-incr))
				  )
				)
			 
					; generate commands
			 (if (< command-count ticks) 
			     (begin
			       (lw6-command #t)
			       ;(lw6-log-notice (format #f "~a/~a" command-count ticks))
			       (set! command-count (+ command-count command-incr))
			       )
			     (lw6-command #f)
			     )
					; checkpoint, calc system values
			 (if (> ticks next-checkpoint)
			     (let (
				   (ticks-delta (- ticks last-checkpoint))
				   )
			       (begin
				 (set! %lw6-frames-per-sec (quotient (* 1000 frames-checkpoint-counter) ticks-delta))
				 (set! frames-checkpoint-counter 0)
				 (set! last-checkpoint ticks)
				 (set! next-checkpoint (+ ticks checkpoint-period))
				 )))
					; Now, the master piece, we display
			 (set! frame-count (+ frame-count frame-incr))
			 (set! frames-checkpoint-counter
			       (+ frames-checkpoint-counter 1))
			 (lw6-display)
			 )
					; go idle, we have "too much CPU"
		       (c-lw6gfx-delay 1) 
		       )
		   )
		 )
	       )
	)
      )
    )
  )
    


