/*
 * @(#)Switchable.java            1.1               4 August 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.analysis;

/**
 * This interface specifies the method being called upon switching.
 * See the visitor (or switch) design pattern for details on how this
 * works.
 *
 * @version  1.1
 * @author   Per Cederberg, per@percederberg.net
 */
public interface Switchable {

   /**
    * Called with an object containing relevant case methods. This
    * method should be defined for all objects that are
    * switchable, preferedly replacing it with a call to the
    * appropriate caseXXX method.
    *
    * @param sw    the switch object
    */
   void apply(Switch sw);
}
