/*
 * @(#)TreePrinter.java        1.0                30 July 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.analysis;

import java.io.PrintStream;
import net.percederberg.mib.asn1.node.Node;

/**
 * This class provides a tree printing mechanism. The tree is traversed
 * in depth first order and all nodes in it are printed.
 *
 * @version  1.0
 * @author   Per Cederberg, per@percederberg.net
 */
public class TreePrinter extends DepthFirstAdapter {

   /**
    * The current indentation level.
    */
   private int            currentIndent = 0;

   /**
    * The indentation increment.
    */
   private int            indentStep = 2;

   /**
    * The output stream.
    */
   private PrintStream   os;

   /**
    * Creates a new tree printer with an indentation step of 2.
    *
    * @param  os     the selected output stream
    */
   public TreePrinter(PrintStream os) {
      this.os = os;
   }

   /**
    * Creates a new tree printer with the given indentation step.
    *
    * @param  os           the selected output stream
    * @param  indentStep   the size of each indentation step
    */
   public TreePrinter(PrintStream os, int indentStep) {
      this.os = os;
      this.indentStep = indentStep;
   }

   /**
    * A default method called from all inXXX methods. Override
    * this method in a subclass to handle the default case.
    *
    * @param  node   a parse tree node
    */
   protected void defaultIn(Node node) {
      int   i;

      for (i = 0; i < currentIndent; i++) {
         os.print(" ");
      }
      os.println(node.toString());
      currentIndent += indentStep;
   }

   /**
    * A default method called from all outXXX methods. Override
    * this method in a subclass to handle the default case.
    *
    * @param  node   a parse tree node
    */
   protected void defaultOut(Node node) {
      currentIndent -= indentStep;
   }
}
