/*
 * @(#)ObjectIdentifierType.java     1.0      6 September 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.type;

/**
 * A class for handling object id type information.
 *
 * @version  1.0
 * @author   Per Cederberg, per@percederberg.net
 */
public class ObjectIdentifierType extends Type {

   /**
    * The one and only instance of this type.
    */
   private static ObjectIdentifierType instance = null;

   /**
    * Creates a new object identifier type. Should only be called from the
    * getInstance method.
    */
   protected ObjectIdentifierType() {
   }

   /**
    * Returns the existing instance of the ObjectIdentifierType or creates
    * a new one if none existed.
    *
    * @return the one and only instance of this type
    */
   public static ObjectIdentifierType getInstance() {
      if (instance == null) {
         instance = new ObjectIdentifierType();
      }
      return instance;
   }

   /**
    * Checks if this type is equals to some other object. It will only
    * be reported equal to other object identifier types.
    *
    * @param  obj     an object
    *
    * @return true if the objects are equal, or
    *         false otherwise
    */
   public boolean equals(Object obj) {
      if (obj instanceof ObjectIdentifierType) {
         return true;
      } else if (obj instanceof NamedType) {
         NamedType t = (NamedType)obj;
         return t.equals(this);
      } else {
         return false;
      }
   }

   /**
    * Returns a string description of this type.
    *
    * @return a string description of the type
    */
   public String toString() {
      return "ObjectIdentifier";
   }

   /**
    * Transfers the type information from this type to a type converter
    * object. The calling conventions declared in the TypeConverter
    * class are followed.
    *
    * @param   converter     a type converter
    */
   public void transferType(TypeConverter converter) {
      throw new UnsupportedOperationException("Object identifiers cannot be " +
                                              "mapped to anything");
   }

}

