/*
 * @(#)TypeSymbol.java         1.0             14 October 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.symbol;

/**
 * A class containing a type symbol from the MIB file. Type symbols
 * does not support having children, neither do they have object
 * identifiers. The corresponding methods from Symbol have been
 * overridden to generate errors when inserting these.<p>
 *
 * Type symbols typically contains a name and a type (which should be
 * set upon type analysis). The symbols may also link to a parent
 * symbol.
 *
 * @version  1.0
 * @author   Per Cederberg, per@percederberg.net
 */
public class TypeSymbol extends Symbol {

    /**
     * Creates a new type symbol with the given name.
     *
     * @param   name     the symbol name
     */
    public TypeSymbol(String name) {
        this.name = name;
    }

    /**
     * Returns an empty string, as types have no object identifiers.
     *
     * @return an empty string
     */
    public String getOID() {
        return "";
    }

    /**
     * Throws an exception, since this operation is not allowed for
     * type symbols.
     *
     * @param id     the new OID
     *
     * @exception UnsupportedOperationException thrown as this
     *                operation is not supported
     */
    public void setOID(int id) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(
            "Cannot assign an id to " + this.toString());
    }

    /**
     * Throws an exception, since this operation is not allowed for
     * type symbols.
     *
     * @param child    the child symbol
     *
     * @exception UnsupportedOperationException thrown as this
     *                operation is not supported
     */
    protected void addChild(Symbol child)
        throws UnsupportedOperationException {

        throw new UnsupportedOperationException(
            "Cannot add children to " + this.toString());
    }
}
