/*
 * @(#)SnmpTrapType.java
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.type;

import java.util.Vector;

/**
 * A class for handling type information for a SNMP trap type.
 *
 * @version  1.1
 * @author   Per Cederberg, per@percederberg.net
 */
public class SnmpTrapType extends Type {
    // TODO: add methods for reading the instance variables

    /**
     * The enterprise identifier.
     */
    private String enterprise = null;
    
    /**
     * The name of the variables.
     */
    private Vector variables = null;

    /**
     * The description text.
     */
    private String description = null;
    
    /**
     * The reference text.
     */
    private String reference = null;

    /**
     * Creates a new SNMP trap type with the given description.
     *
     * @param enterprise  the enterprise name
     * @param vars        the variable names (or null)
     * @param desc        the string description (or null)
     * @param ref         the reference text (or null)
     */
    public SnmpTrapType(String enterprise, 
                        Vector vars,
                        String desc, 
                        String ref) {

        this.enterprise = enterprise;
        this.variables = vars;
        this.description = desc;
        this.reference = ref;
    }

    /**
     * Checks if this type equals another.
     *
     * @param  obj       an object
     * @return true if the types are equal, false otherwise
     */
    public boolean equals(Object obj) {
        return this == obj;
    }

    /**
     * Returns a description of this type.
     *
     * @return a description of the type
     */
    public String toString() {
        return "TrapType";
    }

    /**
     * Transfers the type information from this type to a type
     * converter object. The calling conventions declared in the
     * TypeConverter class are followed.
     *
     * @param   converter     a type converter
     */
    public void transferType(TypeConverter converter) {
        throw new UnsupportedOperationException(
            "Traps cannot be mapped to anything.");
    }

}
