/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib.example;

import net.percederberg.mib.Mib;
import net.percederberg.mib.MibTreeModel;
import net.percederberg.mib.symbol.TypeSymbol;
import net.percederberg.mib.symbol.ValueSymbol;

public class SimpleMibPrinter {
    static /* synthetic */ Class class$net$percederberg$mib$example$SimpleMibPrinter;

    public static void main(String[] args) {
        if (args.length != 1) {
            SimpleMibPrinter.printHelp("Wrong number of arguments");
            System.exit(1);
        }
        try {
            Mib mib = new Mib(args[0]);
            MibTreeModel tree = new MibTreeModel(mib);
            System.err.print(mib.getAllMessages());
            SimpleMibPrinter.printTree(tree);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void printHelp(String error) {
        System.err.println("Syntax: java " + (class$net$percederberg$mib$example$SimpleMibPrinter == null ? (class$net$percederberg$mib$example$SimpleMibPrinter = SimpleMibPrinter.class$("net.percederberg.mib.example.SimpleMibPrinter")) : class$net$percederberg$mib$example$SimpleMibPrinter) + " <mibfile>");
        System.err.println();
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void printTree(MibTreeModel tree) {
        SimpleMibPrinter.printTreeNode(tree, tree.getRoot(), "");
    }

    private static void printTreeNode(MibTreeModel tree, Object node, String indent) {
        System.out.print(indent + node.toString());
        if (node instanceof ValueSymbol) {
            ValueSymbol value = (ValueSymbol)node;
            System.out.print(", OID: " + value.getOID() + ", Type: " + value.getType());
        } else if (node instanceof TypeSymbol) {
            TypeSymbol type = (TypeSymbol)node;
            System.out.print(", Type: " + type.getType());
        }
        System.out.println();
        int children = tree.getChildCount(node);
        int i = 0;
        while (i < children) {
            SimpleMibPrinter.printTreeNode(tree, tree.getChild(node, i), indent + "  ");
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

