/*
 * @(#)Switchable.java
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * As a special exception, the copyright holders of this library 
 * give you permission to link this library with independent modules
 * to produce an executable, regardless of the license terms of 
 * these independent modules, and to copy and distribute the 
 * resulting executable under terms of your choice, provided that 
 * you also meet, for each linked independent module, the terms and 
 * conditions of the license of that module. An independent module 
 * is a module which is not derived from or based on this library. 
 * If you modify this library, you may extend this exception to your 
 * version of the library, but you are not obligated to do so. If 
 * you do not wish to do so, delete this exception statement from 
 * your version. 
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.analysis;

/**
 * This interface specifies the method being called upon switching.
 * See the visitor (or switch) design pattern for details on how this
 * works.
 *
 * @version  1.1
 * @author   Per Cederberg, per@percederberg.net
 */
public interface Switchable {

    /**
     * Called with an object containing relevant case methods. This
     * method should be defined for all objects that are
     * switchable, preferedly replacing it with a call to the
     * appropriate caseX method.
     *
     * @param sw    the switch object
     */
    void apply(Switch sw);
}
