/* Generated By:JavaCC: Do not edit this line. AsnParser.java */
package net.percederberg.mib.asn1.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import net.percederberg.mib.asn1.node.Node;
import net.percederberg.mib.asn1.node.Production;
import net.percederberg.mib.asn1.node.Token;

/**
 * An ASN.1 parser class.  The parser is generated to be static, and only
 * the method parse() should be called, which returns the parse tree.<p>
 *
 * The grammar used is derived in part from the yacc and lex sources
 * of 'snacc' - a GNU ASN.1 to C or C++ compiler. Other parts of the
 * grammar comes from RFC 1155, 1212, 1215, 1902, 1903, and 1904 in
 * order to be able to correctly parse Internet MIBs.<p>
 *
 * The parser was originally written by Helena Sarin (hsarin@lucent.com).
 * Modifications have been made by Per Cederberg (per@percederberg.net).
 * The changes includes removing parts of the constraint mechanism,
 * fixing some inefficient rules, and adding new productions for parsing
 * Internet MIBs. Some unnecessary productions have been removed and
 * others have been brought closer to the original 'snacc' grammar.
 * Tokens and productions have also been reordered and renamed.
 *
 * @version  1.1
 * @author   Helena Sarin, hsarin@lucent.com
 * @author   Per Cederberg, per@percederberg.net
 * @see "ISO 8824 - ASN.1 Syntax"
 * @see "RFC 1155 - SNMPv1 Macros"
 * @see "RFC 1212 - SNMPv1 Extended OBJECT-TYPE Macro"
 * @see "RFC 1215 - SNMPv1 TRAP-TYPE Macro"
 * @see "RFC 1902 - SNMPv2 Base Macros"
 * @see "RFC 1903 - SNMPv2 TEXTUAL-CONVENTION Macro"
 * @see "RFC 1904 - SNMPv2 Extended Macros"
 */
public class AsnParser implements AsnParserConstants {

    /**
     * A copy of the generated parser object.
     */
    private static AsnParser parser = null;

    /**
     * A stack of the currently open nodes.
     */
    private static Stack scope = new Stack();

    /**
     * The root tree node found during parsing.
     */
    private static Node root = null;

    /**
     * Adds a new child to the currently open node.
     *
     * @param child     the child node
     */
    private static void addChild(Node child) {
        Production parent = (Production) scope.peek();
        parent.addChild(child);
        child.setParent(parent);
    }

    /**
     * Closes the currently open node scope and returns to the
     * parent node scope.
     */
    private static void closeScope() {
        scope.pop();
    }

    /**
     * Opens a new node scope, after adding the given node as a
     * child to the currently open node.
     *
     * @param node      the new node scope
     */
    private static void openScope(Production node) {
        if (scope.empty()) {
            root = node;
        } else {
            addChild(node);
        }
        scope.push(node);
    }

    /**
     * Parses an input stream and returns a ParseTree object.
     * This method can be called any number of times, as it
     * automatically reinitializes the parser.
     *
     * @param in   an input character stream
     *
     * @return the top node of the parse tree
     *
     * @throws ParseException if the input stream couldn't be parsed
     *             correctly
     */
    public static Node parse(InputStream in) throws ParseException {
        return parse(new InputStreamReader(in));
    }

    /**
     * Parses an input stream and returns a ParseTree object.
     * This method can be called any number of times, as it
     * automatically reinitializes the parser.
     *
     * @param in   an input stream reader
     *
     * @return the top node of the parse tree
     *
     * @throws ParseException if the input stream couldn't be parsed
     *             correctly
     */
    public static Node parse(Reader in) throws ParseException {

        // Initialize parser
        if (parser == null) {
            parser = new AsnParser(in);
        } else {
            parser.ReInit(in);
        }

        // Parse input
        root = null;
        scope.clear();
        Start();

        return root;
    }

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Module def/import/export productions
 *
 */
  static final public void Start() throws ParseException {
   openScope(new Production(Node.START));
    ModuleDefinition();
                          closeScope();
  }

  static final public void ModuleDefinition() throws ParseException {
   openScope(new Production(Node.MODULEDEFINITION));
    ModuleIdentifier();
    jj_consume_token(TDEFINITIONS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXPLICIT:
    case TIMPLICIT:
      TagDefault();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    jj_consume_token(TASSIGN);
    jj_consume_token(TBEGIN);
    ModuleBody();
    jj_consume_token(TEND);
                        closeScope();
  }

  static final public void TagDefault() throws ParseException {
   openScope(new Production(Node.TAGDEFAULT));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXPLICIT:
      jj_consume_token(TEXPLICIT);
                addChild(getToken(0));
      jj_consume_token(TTAGS);
                                                  closeScope();
      break;
    case TIMPLICIT:
      jj_consume_token(TIMPLICIT);
                addChild(getToken(0));
      jj_consume_token(TTAGS);
                                                  closeScope();
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void ModuleIdentifier() throws ParseException {
   openScope(new Production(Node.MODULEIDENTIFIER));
    ModuleReference();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTBRACE:
      ObjectIdentifierValue();
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
                                                 closeScope();
  }

  static final public void ModuleBody() throws ParseException {
   openScope(new Production(Node.MODULEBODY));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXPORTS:
      Exports();
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIMPORTS:
      Imports();
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    AssignmentList();
                                              closeScope();
  }

  static final public void Exports() throws ParseException {
   openScope(new Production(Node.EXPORTS));
    jj_consume_token(TEXPORTS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TMODULE_IDENTITY:
    case TOBJECT_IDENTITY:
    case TOBJECT_TYPE:
    case TNOTIFICATION_TYPE:
    case TTRAP_TYPE:
    case TTEXTUAL_CONVENTION:
    case TOBJECT_GROUP:
    case TNOTIFICATION_GROUP:
    case TMODULE_COMPLIANCE:
    case TAGENT_CAPABILITIES:
    case TIDENT:
      SymbolList();
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    jj_consume_token(TSEMI_COLON);
                                  closeScope();
  }

  static final public void Imports() throws ParseException {
   openScope(new Production(Node.IMPORTS));
    jj_consume_token(TIMPORTS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TMODULE_IDENTITY:
    case TOBJECT_IDENTITY:
    case TOBJECT_TYPE:
    case TNOTIFICATION_TYPE:
    case TTRAP_TYPE:
    case TTEXTUAL_CONVENTION:
    case TOBJECT_GROUP:
    case TNOTIFICATION_GROUP:
    case TMODULE_COMPLIANCE:
    case TAGENT_CAPABILITIES:
    case TIDENT:
      SymbolsFromModuleList();
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    jj_consume_token(TSEMI_COLON);
                                             closeScope();
  }

  static final public void SymbolsFromModuleList() throws ParseException {
   openScope(new Production(Node.SYMBOLSFROMMODULELIST));
    label_1:
    while (true) {
      SymbolsFromModule();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TMODULE_IDENTITY:
      case TOBJECT_IDENTITY:
      case TOBJECT_TYPE:
      case TNOTIFICATION_TYPE:
      case TTRAP_TYPE:
      case TTEXTUAL_CONVENTION:
      case TOBJECT_GROUP:
      case TNOTIFICATION_GROUP:
      case TMODULE_COMPLIANCE:
      case TAGENT_CAPABILITIES:
      case TIDENT:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_1;
      }
    }
                            closeScope();
  }

  static final public void SymbolsFromModule() throws ParseException {
   openScope(new Production(Node.SYMBOLSFROMMODULE));
    SymbolList();
    jj_consume_token(TFROM);
    ModuleIdentifier();
                                             closeScope();
  }

  static final public void SymbolList() throws ParseException {
   openScope(new Production(Node.SYMBOLLIST));
    Symbol();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TCOMMA:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_2;
      }
      jj_consume_token(TCOMMA);
      Symbol();
    }
                              closeScope();
  }

  static final public void Symbol() throws ParseException {
   openScope(new Production(Node.SYMBOL));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIDENT:
      Identifier();
                  closeScope();
      break;
    case TMODULE_IDENTITY:
    case TOBJECT_IDENTITY:
    case TOBJECT_TYPE:
    case TNOTIFICATION_TYPE:
    case TTRAP_TYPE:
    case TTEXTUAL_CONVENTION:
    case TOBJECT_GROUP:
    case TNOTIFICATION_GROUP:
    case TMODULE_COMPLIANCE:
    case TAGENT_CAPABILITIES:
      DefinedMacroName();
                        closeScope();
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void AssignmentList() throws ParseException {
   openScope(new Production(Node.ASSIGNMENTLIST));
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TMODULE_IDENTITY:
      case TOBJECT_IDENTITY:
      case TOBJECT_TYPE:
      case TNOTIFICATION_TYPE:
      case TTRAP_TYPE:
      case TTEXTUAL_CONVENTION:
      case TOBJECT_GROUP:
      case TNOTIFICATION_GROUP:
      case TMODULE_COMPLIANCE:
      case TAGENT_CAPABILITIES:
      case TIDENT:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_3;
      }
      Assignment();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TSEMI_COLON:
        jj_consume_token(TSEMI_COLON);
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
    }
                           closeScope();
  }

  static final public void Assignment() throws ParseException {
   openScope(new Production(Node.ASSIGNMENT));
    if (jj_2_1(2)) {
      MacroDefinition();
                                    closeScope();
    } else if (jj_2_2(3)) {
      TypeAssignment();
                                   closeScope();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TIDENT:
        ValueAssignment();
                       closeScope();
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  static final public void MacroDefinition() throws ParseException {
   openScope(new Production(Node.MACRODEFINITION));
    MacroReference();
    jj_consume_token(TMACRO);
    jj_consume_token(TASSIGN);
    MacroBody();
                                                closeScope();
  }

  static final public void MacroBody() throws ParseException {
   openScope(new Production(Node.MACROBODY));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TBEGIN:
      jj_consume_token(TBEGIN);
      SkipToEND();
      jj_consume_token(TEND);
                               closeScope();
      break;
    case TIDENT:
      ModuleReference();
      jj_consume_token(TDOT);
      MacroReference();
                                            closeScope();
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static void SkipToEND() throws ParseException {
   openScope(new Production(Node.SKIPTOEND));
   while (getToken(1).kind != TEND)
      addChild(getNextToken());
   closeScope();
  }

  static final public void MacroReference() throws ParseException {
   openScope(new Production(Node.MACROREFERENCE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIDENT:
      TypeReference();
                     closeScope();
      break;
    case TMODULE_IDENTITY:
    case TOBJECT_IDENTITY:
    case TOBJECT_TYPE:
    case TNOTIFICATION_TYPE:
    case TTRAP_TYPE:
    case TTEXTUAL_CONVENTION:
    case TOBJECT_GROUP:
    case TNOTIFICATION_GROUP:
    case TMODULE_COMPLIANCE:
    case TAGENT_CAPABILITIES:
      DefinedMacroName();
                        closeScope();
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Type notation productions
 *
 */
  static final public void TypeAssignment() throws ParseException {
   openScope(new Production(Node.TYPEASSIGNMENT));
    TypeReference();
    jj_consume_token(TASSIGN);
    Type();
                                  closeScope();
  }

  static final public void Type() throws ParseException {
   openScope(new Production(Node.TYPE));
    if (jj_2_3(2)) {
      BuiltinType();
                                 closeScope();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TIDENT:
        DefinedType();
                    closeScope();
        break;
      case TMODULE_IDENTITY:
      case TOBJECT_IDENTITY:
      case TOBJECT_TYPE:
      case TNOTIFICATION_TYPE:
      case TTRAP_TYPE:
      case TTEXTUAL_CONVENTION:
      case TOBJECT_GROUP:
      case TNOTIFICATION_GROUP:
      case TMODULE_COMPLIANCE:
      case TAGENT_CAPABILITIES:
        DefinedMacroType();
                         closeScope();
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  static final public void BuiltinType() throws ParseException {
   openScope(new Production(Node.BUILTINTYPE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TBOOLEAN:
      jj_consume_token(TBOOLEAN);
               addChild(getToken(0)); closeScope();
      break;
    case TREAL:
      jj_consume_token(TREAL);
            addChild(getToken(0)); closeScope();
      break;
    case TNULL:
      jj_consume_token(TNULL);
            addChild(getToken(0)); closeScope();
      break;
    case TOBJECT:
      jj_consume_token(TOBJECT);
              addChild(getToken(0));
      jj_consume_token(TIDENTIFIER);
     addChild(getToken(0)); closeScope();
      break;
    case TINTEGER:
      IntegerType();
                   closeScope();
      break;
    case TOCTET:
      StringType();
                  closeScope();
      break;
    case TBIT:
      BitStringType();
                     closeScope();
      break;
    default:
      jj_la1[16] = jj_gen;
      if (jj_2_4(2)) {
        SequenceType();
                                 closeScope();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TSEQUENCE:
          SequenceOfType();
                      closeScope();
          break;
        default:
          jj_la1[17] = jj_gen;
          if (jj_2_5(2)) {
            SetType();
                            closeScope();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case TSET:
              SetOfType();
                 closeScope();
              break;
            case TCHOICE:
              ChoiceType();
                  closeScope();
              break;
            case TENUMERATED:
              EnumeratedType();
                      closeScope();
              break;
            case TIDENT:
              SelectionType();
                     closeScope();
              break;
            case TLEFTBRACKET:
              TaggedType();
                  closeScope();
              break;
            case TANY:
              AnyType();
               closeScope();
              break;
            default:
              jj_la1[18] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
  }

  static final public void IntegerType() throws ParseException {
   openScope(new Production(Node.INTEGERTYPE));
    jj_consume_token(TINTEGER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTPAREN:
    case TLEFTBRACE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TLEFTBRACE:
        NamedNumberList();
        break;
      case TLEFTPAREN:
        ConstraintList();
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
                                                      closeScope();
  }

  static final public void NamedNumberList() throws ParseException {
   openScope(new Production(Node.NAMEDNUMBERLIST));
    jj_consume_token(TLEFTBRACE);
    NamedNumber();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TCOMMA:
        ;
        break;
      default:
        jj_la1[21] = jj_gen;
        break label_4;
      }
      jj_consume_token(TCOMMA);
      NamedNumber();
    }
    jj_consume_token(TRIGHTBRACE);
                                                closeScope();
  }

  static final public void NamedNumber() throws ParseException {
   openScope(new Production(Node.NAMEDNUMBER));
    Identifier();
    jj_consume_token(TLEFTPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TMINUS:
    case TNUMBER:
      SignedNumber();
      break;
    case TIDENT:
      DefinedValue();
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(TRIGHTPAREN);
                                                            closeScope();
  }

  static final public void SignedNumber() throws ParseException {
   openScope(new Production(Node.SIGNEDNUMBER));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TMINUS:
      jj_consume_token(TMINUS);
          addChild(getToken(0));
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    Number();
              closeScope();
  }

  static final public void StringType() throws ParseException {
   openScope(new Production(Node.STRINGTYPE));
    jj_consume_token(TOCTET);
    jj_consume_token(TSTRING);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTPAREN:
      ConstraintList();
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
                                         closeScope();
  }

  static final public void BitStringType() throws ParseException {
   openScope(new Production(Node.BITSTRINGTYPE));
    jj_consume_token(TBIT);
    jj_consume_token(TSTRING);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTPAREN:
    case TLEFTBRACE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TLEFTBRACE:
        NamedNumberList();
        break;
      case TLEFTPAREN:
        ConstraintList();
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
                                                           closeScope();
  }

  static final public void SequenceType() throws ParseException {
   openScope(new Production(Node.SEQUENCETYPE));
    jj_consume_token(TSEQUENCE);
    jj_consume_token(TLEFTBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTBRACKET:
    case TINTEGER:
    case TREAL:
    case TBOOLEAN:
    case TNULL:
    case TBIT:
    case TOCTET:
    case TENUMERATED:
    case TSEQUENCE:
    case TSET:
    case TCHOICE:
    case TANY:
    case TOBJECT:
    case TCOMPONENTS:
    case TMODULE_IDENTITY:
    case TOBJECT_IDENTITY:
    case TOBJECT_TYPE:
    case TNOTIFICATION_TYPE:
    case TTRAP_TYPE:
    case TTEXTUAL_CONVENTION:
    case TOBJECT_GROUP:
    case TNOTIFICATION_GROUP:
    case TMODULE_COMPLIANCE:
    case TAGENT_CAPABILITIES:
    case TIDENT:
      ElementTypeList();
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    jj_consume_token(TRIGHTBRACE);
                                            closeScope();
  }

  static final public void SequenceOfType() throws ParseException {
   openScope(new Production(Node.SEQUENCEOFTYPE));
    jj_consume_token(TSEQUENCE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TSIZE:
      SizeConstraint();
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
    jj_consume_token(TOF);
    Type();
                                               closeScope();
  }

  static final public void SetType() throws ParseException {
   openScope(new Production(Node.SETTYPE));
    jj_consume_token(TSET);
    jj_consume_token(TLEFTBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTBRACKET:
    case TINTEGER:
    case TREAL:
    case TBOOLEAN:
    case TNULL:
    case TBIT:
    case TOCTET:
    case TENUMERATED:
    case TSEQUENCE:
    case TSET:
    case TCHOICE:
    case TANY:
    case TOBJECT:
    case TCOMPONENTS:
    case TMODULE_IDENTITY:
    case TOBJECT_IDENTITY:
    case TOBJECT_TYPE:
    case TNOTIFICATION_TYPE:
    case TTRAP_TYPE:
    case TTEXTUAL_CONVENTION:
    case TOBJECT_GROUP:
    case TNOTIFICATION_GROUP:
    case TMODULE_COMPLIANCE:
    case TAGENT_CAPABILITIES:
    case TIDENT:
      ElementTypeList();
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    jj_consume_token(TRIGHTBRACE);
                                       closeScope();
  }

  static final public void SetOfType() throws ParseException {
   openScope(new Production(Node.SETOFTYPE));
    jj_consume_token(TSET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TSIZE:
      SizeConstraint();
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    jj_consume_token(TOF);
    Type();
                                          closeScope();
  }

  static final public void ElementTypeList() throws ParseException {
   openScope(new Production(Node.ELEMENTTYPELIST));
    ElementType();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TCOMMA:
        ;
        break;
      default:
        jj_la1[31] = jj_gen;
        break label_5;
      }
      jj_consume_token(TCOMMA);
      ElementType();
    }
                                        closeScope();
  }

  static final public void ElementType() throws ParseException {
   openScope(new Production(Node.ELEMENTTYPE));
    if (jj_2_6(2)) {
      NamedType();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TOPTIONAL:
      case TDEFAULT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TOPTIONAL:
          jj_consume_token(TOPTIONAL);
                 addChild(getToken(0));
          break;
        case TDEFAULT:
          jj_consume_token(TDEFAULT);
                addChild(getToken(0));
          NamedValue();
          break;
        default:
          jj_la1[32] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
                                                         closeScope();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TCOMPONENTS:
      case TIDENT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TIDENT:
          Identifier();
          break;
        default:
          jj_la1[34] = jj_gen;
          ;
        }
        jj_consume_token(TCOMPONENTS);
        jj_consume_token(TOF);
        Type();
                                             closeScope();
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  static final public void NamedType() throws ParseException {
   openScope(new Production(Node.NAMEDTYPE));
    if (jj_2_7(2)) {
      Identifier();
    } else {
      ;
    }
    Type();
                                        closeScope();
  }

  static final public void ChoiceType() throws ParseException {
   openScope(new Production(Node.CHOICETYPE));
    jj_consume_token(TCHOICE);
    jj_consume_token(TLEFTBRACE);
    ElementTypeList();
    jj_consume_token(TRIGHTBRACE);
                                        closeScope();
  }

  static final public void EnumeratedType() throws ParseException {
   openScope(new Production(Node.ENUMERATEDTYPE));
    jj_consume_token(TENUMERATED);
    NamedNumberList();
                                    closeScope();
  }

  static final public void SelectionType() throws ParseException {
   openScope(new Production(Node.SELECTIONTYPE));
    Identifier();
    jj_consume_token(TLESSTHAN);
    Type();
                             closeScope();
  }

  static final public void TaggedType() throws ParseException {
   openScope(new Production(Node.TAGGEDTYPE));
    Tag();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXPLICIT:
    case TIMPLICIT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEXPLICIT:
        jj_consume_token(TEXPLICIT);
                       addChild(getToken(0));
        break;
      case TIMPLICIT:
        jj_consume_token(TIMPLICIT);
                       addChild(getToken(0));
        break;
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    Type();
                                                           closeScope();
  }

  static final public void Tag() throws ParseException {
   openScope(new Production(Node.TAG));
    jj_consume_token(TLEFTBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TUNIVERSAL:
    case TAPPLICATION:
    case TPRIVATE:
      Class();
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    ClassNumber();
    jj_consume_token(TRIGHTBRACKET);
                                     closeScope();
  }

  static final public void ClassNumber() throws ParseException {
   openScope(new Production(Node.CLASSNUMBER));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TNUMBER:
      Number();
              closeScope();
      break;
    case TIDENT:
      DefinedValue();
                    closeScope();
      break;
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void Class() throws ParseException {
   openScope(new Production(Node.CLASS));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TUNIVERSAL:
      jj_consume_token(TUNIVERSAL);
                 addChild(getToken(0)); closeScope();
      break;
    case TAPPLICATION:
      jj_consume_token(TAPPLICATION);
                   addChild(getToken(0)); closeScope();
      break;
    case TPRIVATE:
      jj_consume_token(TPRIVATE);
               addChild(getToken(0)); closeScope();
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void AnyType() throws ParseException {
   openScope(new Production(Node.ANYTYPE));
    jj_consume_token(TANY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TDEFINED:
      jj_consume_token(TDEFINED);
      jj_consume_token(TBY);
      Identifier();
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
                                         closeScope();
  }

  static final public void DefinedType() throws ParseException {
   openScope(new Production(Node.DEFINEDTYPE));
    if (jj_2_8(2)) {
      ModuleReference();
      jj_consume_token(TDOT);
    } else {
      ;
    }
    TypeReference();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTPAREN:
    case TLEFTBRACE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TLEFTBRACE:
        NamedNumberList();
        break;
      case TLEFTPAREN:
        ConstraintList();
        break;
      default:
        jj_la1[42] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
                                            closeScope();
  }

  static final public void ConstraintList() throws ParseException {
   openScope(new Production(Node.CONSTRAINTLIST));
    jj_consume_token(TLEFTPAREN);
    Constraint();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TBAR:
        ;
        break;
      default:
        jj_la1[44] = jj_gen;
        break label_6;
      }
      jj_consume_token(TBAR);
      Constraint();
    }
    jj_consume_token(TRIGHTPAREN);
                                              closeScope();
  }

  static final public void Constraint() throws ParseException {
   openScope(new Production(Node.CONSTRAINT));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTBRACE:
    case TMINUS:
    case TNULL:
    case TMIN:
    case TTRUE:
    case TFALSE:
    case TPLUS_INFINITY:
    case TMINUS_INFINITY:
    case TBINSTRING:
    case THEXSTRING:
    case TCSTRING:
    case TIDENT:
    case TNUMBER:
      ValueConstraint();
                       closeScope();
      break;
    case TSIZE:
      SizeConstraint();
                      closeScope();
      break;
    case TFROM:
      AlphabetConstraint();
                          closeScope();
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void ValueConstraint() throws ParseException {
   openScope(new Production(Node.VALUECONSTRAINT));
    if (jj_2_9(3)) {
      ValueRange();
                               closeScope();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TLEFTBRACE:
      case TMINUS:
      case TNULL:
      case TTRUE:
      case TFALSE:
      case TPLUS_INFINITY:
      case TMINUS_INFINITY:
      case TBINSTRING:
      case THEXSTRING:
      case TCSTRING:
      case TIDENT:
      case TNUMBER:
        Value();
             closeScope();
        break;
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  static final public void ValueRange() throws ParseException {
   openScope(new Production(Node.VALUERANGE));
    LowerEndPoint();
    jj_consume_token(TDOT);
    jj_consume_token(TDOT);
    UpperEndPoint();
                                             closeScope();
  }

  static final public void LowerEndPoint() throws ParseException {
   openScope(new Production(Node.LOWERENDPOINT));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTBRACE:
    case TMINUS:
    case TNULL:
    case TTRUE:
    case TFALSE:
    case TPLUS_INFINITY:
    case TMINUS_INFINITY:
    case TBINSTRING:
    case THEXSTRING:
    case TCSTRING:
    case TIDENT:
    case TNUMBER:
      Value();
      break;
    case TMIN:
      jj_consume_token(TMIN);
                      addChild(getToken(0));
      break;
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLESSTHAN:
      jj_consume_token(TLESSTHAN);
          addChild(getToken(0));
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
                                      closeScope();
  }

  static final public void UpperEndPoint() throws ParseException {
   openScope(new Production(Node.UPPERENDPOINT));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLESSTHAN:
      jj_consume_token(TLESSTHAN);
          addChild(getToken(0));
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTBRACE:
    case TMINUS:
    case TNULL:
    case TTRUE:
    case TFALSE:
    case TPLUS_INFINITY:
    case TMINUS_INFINITY:
    case TBINSTRING:
    case THEXSTRING:
    case TCSTRING:
    case TIDENT:
    case TNUMBER:
      Value();
      break;
    case TMAX:
      jj_consume_token(TMAX);
                      addChild(getToken(0));
      break;
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                   closeScope();
  }

  static final public void SizeConstraint() throws ParseException {
   openScope(new Production(Node.SIZECONSTRAINT));
    jj_consume_token(TSIZE);
    jj_consume_token(TLEFTPAREN);
    ValueConstraint();
    jj_consume_token(TRIGHTPAREN);
                                      closeScope();
  }

  static final public void AlphabetConstraint() throws ParseException {
   openScope(new Production(Node.ALPHABETCONSTRAINT));
    jj_consume_token(TFROM);
    jj_consume_token(TLEFTPAREN);
    ValueConstraint();
    jj_consume_token(TRIGHTPAREN);
                                      closeScope();
  }

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Value notation productions
 *
 */
  static final public void ValueAssignment() throws ParseException {
   openScope(new Production(Node.VALUEASSIGNMENT));
    Identifier();
    Type();
    jj_consume_token(TASSIGN);
    Value();
                                       closeScope();
  }

  static final public void Value() throws ParseException {
   openScope(new Production(Node.VALUE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTBRACE:
    case TMINUS:
    case TNULL:
    case TTRUE:
    case TFALSE:
    case TPLUS_INFINITY:
    case TMINUS_INFINITY:
    case TBINSTRING:
    case THEXSTRING:
    case TCSTRING:
    case TNUMBER:
      BuiltinValue();
                    closeScope();
      break;
    case TIDENT:
      DefinedValue();
                    closeScope();
      break;
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void DefinedValue() throws ParseException {
   openScope(new Production(Node.DEFINEDVALUE));
    if (jj_2_10(2)) {
      ModuleReference();
      jj_consume_token(TDOT);
    } else {
      ;
    }
    Identifier();
                                                       closeScope();
  }

  static final public void BuiltinValue() throws ParseException {
   openScope(new Production(Node.BUILTINVALUE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TTRUE:
    case TFALSE:
      BooleanValue();
                    closeScope();
      break;
    case TNULL:
      NullValue();
                 closeScope();
      break;
    case TPLUS_INFINITY:
    case TMINUS_INFINITY:
      SpecialRealValue();
                        closeScope();
      break;
    case TMINUS:
    case TNUMBER:
      SignedNumber();
                    closeScope();
      break;
    case THEXSTRING:
      HexString();
                 closeScope();
      break;
    case TBINSTRING:
      BinaryString();
                    closeScope();
      break;
    case TCSTRING:
      CharString();
                  closeScope();
      break;
    case TLEFTBRACE:
      ObjectIdentifierValue();
                             closeScope();
      break;
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void BooleanValue() throws ParseException {
   openScope(new Production(Node.BOOLEANVALUE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TTRUE:
      jj_consume_token(TTRUE);
            addChild(getToken(0)); closeScope();
      break;
    case TFALSE:
      jj_consume_token(TFALSE);
             addChild(getToken(0)); closeScope();
      break;
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void SpecialRealValue() throws ParseException {
   openScope(new Production(Node.SPECIALREALVALUE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TPLUS_INFINITY:
      jj_consume_token(TPLUS_INFINITY);
                     addChild(getToken(0)); closeScope();
      break;
    case TMINUS_INFINITY:
      jj_consume_token(TMINUS_INFINITY);
                      addChild(getToken(0)); closeScope();
      break;
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void NullValue() throws ParseException {
   openScope(new Production(Node.NULLVALUE));
    jj_consume_token(TNULL);
            addChild(getToken(0)); closeScope();
  }

  static final public void NamedValue() throws ParseException {
   openScope(new Production(Node.NAMEDVALUE));
    if (jj_2_11(2)) {
      Identifier();
    } else {
      ;
    }
    Value();
                                         closeScope();
  }

  static final public void ObjectIdentifierValue() throws ParseException {
   openScope(new Production(Node.OBJECTIDENTIFIERVALUE));
    jj_consume_token(TLEFTBRACE);
    ObjIdComponentList();
    jj_consume_token(TRIGHTBRACE);
                                  closeScope();
  }

  static final public void ObjIdComponentList() throws ParseException {
   openScope(new Production(Node.OBJIDCOMPONENTLIST));
    label_7:
    while (true) {
      ObjIdComponent();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TIDENT:
      case TNUMBER:
        ;
        break;
      default:
        jj_la1[55] = jj_gen;
        break label_7;
      }
    }
                         closeScope();
  }

  static final public void ObjIdComponent() throws ParseException {
   openScope(new Production(Node.OBJIDCOMPONENT));
    if (jj_2_12(2)) {
      NameAndNumberForm();
                                      closeScope();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TNUMBER:
        Number();
              closeScope();
        break;
      case TIDENT:
        Identifier();
                  closeScope();
        break;
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  static final public void NameAndNumberForm() throws ParseException {
   openScope(new Production(Node.NAMEANDNUMBERFORM));
    Identifier();
    jj_consume_token(TLEFTPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TNUMBER:
      Number();
      break;
    case TIDENT:
      DefinedValue();
      break;
    default:
      jj_la1[57] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(TRIGHTPAREN);
                                                      closeScope();
  }

  static final public void BinaryString() throws ParseException {
   openScope(new Production(Node.BINARYSTRING));
    jj_consume_token(TBINSTRING);
                  addChild(getToken(0)); closeScope();
  }

  static final public void HexString() throws ParseException {
   openScope(new Production(Node.HEXSTRING));
    jj_consume_token(THEXSTRING);
                  addChild(getToken(0)); closeScope();
  }

  static final public void CharString() throws ParseException {
   openScope(new Production(Node.CHARSTRING));
    jj_consume_token(TCSTRING);
                addChild(getToken(0)); closeScope();
  }

  static final public void Number() throws ParseException {
   openScope(new Production(Node.NUMBER));
    jj_consume_token(TNUMBER);
               addChild(getToken(0)); closeScope();
  }

  static final public void Identifier() throws ParseException {
   openScope(new Production(Node.IDENTIFIER));
    jj_consume_token(TIDENT);
              addChild(getToken(0)); closeScope();
  }

  static final public void ModuleReference() throws ParseException {
   openScope(new Production(Node.MODULEREFERENCE));
    jj_consume_token(TIDENT);
              addChild(getToken(0)); closeScope();
  }

  static final public void TypeReference() throws ParseException {
   openScope(new Production(Node.TYPEREFERENCE));
    jj_consume_token(TIDENT);
              addChild(getToken(0)); closeScope();
  }

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Macro Syntax definitions
 *
 */
  static final public void DefinedMacroType() throws ParseException {
   openScope(new Production(Node.DEFINEDMACROTYPE));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TMODULE_IDENTITY:
      SnmpModuleIdentityMacroType();
                                   closeScope();
      break;
    case TOBJECT_IDENTITY:
      SnmpObjectIdentityMacroType();
                                   closeScope();
      break;
    case TOBJECT_TYPE:
      SnmpObjectTypeMacroType();
                               closeScope();
      break;
    case TNOTIFICATION_TYPE:
      SnmpNotificationTypeMacroType();
                                     closeScope();
      break;
    case TTRAP_TYPE:
      SnmpTrapTypeMacroType();
                             closeScope();
      break;
    case TTEXTUAL_CONVENTION:
      SnmpTextualConventionMacroType();
                                      closeScope();
      break;
    case TOBJECT_GROUP:
      SnmpObjectGroupMacroType();
                                closeScope();
      break;
    case TNOTIFICATION_GROUP:
      SnmpNotificationGroupMacroType();
                                      closeScope();
      break;
    case TMODULE_COMPLIANCE:
      SnmpModuleComplianceMacroType();
                                     closeScope();
      break;
    case TAGENT_CAPABILITIES:
      SnmpAgentCapabilitiesMacroType();
                                      closeScope();
      break;
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void DefinedMacroName() throws ParseException {
   openScope(new Production(Node.DEFINEDMACRONAME));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TMODULE_IDENTITY:
      jj_consume_token(TMODULE_IDENTITY);
                       addChild(getToken(0)); closeScope();
      break;
    case TOBJECT_IDENTITY:
      jj_consume_token(TOBJECT_IDENTITY);
                       addChild(getToken(0)); closeScope();
      break;
    case TOBJECT_TYPE:
      jj_consume_token(TOBJECT_TYPE);
                   addChild(getToken(0)); closeScope();
      break;
    case TNOTIFICATION_TYPE:
      jj_consume_token(TNOTIFICATION_TYPE);
                         addChild(getToken(0)); closeScope();
      break;
    case TTRAP_TYPE:
      jj_consume_token(TTRAP_TYPE);
                 addChild(getToken(0)); closeScope();
      break;
    case TTEXTUAL_CONVENTION:
      jj_consume_token(TTEXTUAL_CONVENTION);
                          addChild(getToken(0)); closeScope();
      break;
    case TOBJECT_GROUP:
      jj_consume_token(TOBJECT_GROUP);
                    addChild(getToken(0)); closeScope();
      break;
    case TNOTIFICATION_GROUP:
      jj_consume_token(TNOTIFICATION_GROUP);
                          addChild(getToken(0)); closeScope();
      break;
    case TMODULE_COMPLIANCE:
      jj_consume_token(TMODULE_COMPLIANCE);
                         addChild(getToken(0)); closeScope();
      break;
    case TAGENT_CAPABILITIES:
      jj_consume_token(TAGENT_CAPABILITIES);
                          addChild(getToken(0)); closeScope();
      break;
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void SnmpModuleIdentityMacroType() throws ParseException {
   openScope(new Production(Node.SNMPMODULEIDENTITYMACROTYPE));
    jj_consume_token(TMODULE_IDENTITY);
    SnmpUpdatePart();
    SnmpOrganizationPart();
    SnmpContactPart();
    SnmpDescrPart();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TREVISION:
        ;
        break;
      default:
        jj_la1[60] = jj_gen;
        break label_8;
      }
      SnmpRevisionPart();
    }
                           closeScope();
  }

  static final public void SnmpObjectIdentityMacroType() throws ParseException {
   openScope(new Production(Node.SNMPOBJECTIDENTITYMACROTYPE));
    jj_consume_token(TOBJECT_IDENTITY);
    SnmpStatusPart();
    SnmpDescrPart();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TREFERENCE:
      SnmpReferPart();
      break;
    default:
      jj_la1[61] = jj_gen;
      ;
    }
                       closeScope();
  }

  static final public void SnmpObjectTypeMacroType() throws ParseException {
   openScope(new Production(Node.SNMPOBJECTTYPEMACROTYPE));
    jj_consume_token(TOBJECT_TYPE);
    SnmpSyntaxPart();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TUNITS:
      SnmpUnitsPart();
      break;
    default:
      jj_la1[62] = jj_gen;
      ;
    }
    SnmpAccessPart();
    SnmpStatusPart();
    if (jj_2_13(2)) {
      SnmpDescrPart();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TREFERENCE:
      SnmpReferPart();
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TINDEX:
    case TAUGMENTS:
      SnmpIndexPart();
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    if (jj_2_14(2)) {
      SnmpDefValPart();
    } else {
      ;
    }
                                     closeScope();
  }

  static final public void SnmpNotificationTypeMacroType() throws ParseException {
   openScope(new Production(Node.SNMPNOTIFICATIONTYPEMACROTYPE));
    jj_consume_token(TNOTIFICATION_TYPE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TOBJECTS:
      SnmpObjectsPart();
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    SnmpStatusPart();
    SnmpDescrPart();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TREFERENCE:
      SnmpReferPart();
      break;
    default:
      jj_la1[66] = jj_gen;
      ;
    }
                       closeScope();
  }

  static final public void SnmpTrapTypeMacroType() throws ParseException {
   openScope(new Production(Node.SNMPTRAPTYPEMACROTYPE));
    jj_consume_token(TTRAP_TYPE);
    SnmpEnterprisePart();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TVARIABLES:
      SnmpVarPart();
      break;
    default:
      jj_la1[67] = jj_gen;
      ;
    }
    if (jj_2_15(2)) {
      SnmpDescrPart();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TREFERENCE:
      SnmpReferPart();
      break;
    default:
      jj_la1[68] = jj_gen;
      ;
    }
                       closeScope();
  }

  static final public void SnmpTextualConventionMacroType() throws ParseException {
   openScope(new Production(Node.SNMPTEXTUALCONVENTIONMACROTYPE));
    jj_consume_token(TTEXTUAL_CONVENTION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TDISPLAY_HINT:
      SnmpDisplayPart();
      break;
    default:
      jj_la1[69] = jj_gen;
      ;
    }
    SnmpStatusPart();
    SnmpDescrPart();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TREFERENCE:
      SnmpReferPart();
      break;
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    SnmpSyntaxPart();
                      closeScope();
  }

  static final public void SnmpObjectGroupMacroType() throws ParseException {
   openScope(new Production(Node.SNMPOBJECTGROUPMACROTYPE));
    jj_consume_token(TOBJECT_GROUP);
    SnmpObjectsPart();
    SnmpStatusPart();
    SnmpDescrPart();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TREFERENCE:
      SnmpReferPart();
      break;
    default:
      jj_la1[71] = jj_gen;
      ;
    }
                        closeScope();
  }

  static final public void SnmpNotificationGroupMacroType() throws ParseException {
   openScope(new Production(Node.SNMPNOTIFICATIONGROUPMACROTYPE));
    jj_consume_token(TNOTIFICATION_GROUP);
    SnmpNotificationsPart();
    SnmpStatusPart();
    SnmpDescrPart();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TREFERENCE:
      SnmpReferPart();
      break;
    default:
      jj_la1[72] = jj_gen;
      ;
    }
                        closeScope();
  }

  static final public void SnmpModuleComplianceMacroType() throws ParseException {
   openScope(new Production(Node.SNMPMODULECOMPLIANCEMACROTYPE));
    jj_consume_token(TMODULE_COMPLIANCE);
    SnmpStatusPart();
    SnmpDescrPart();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TREFERENCE:
      SnmpReferPart();
      break;
    default:
      jj_la1[73] = jj_gen;
      ;
    }
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TMODULE:
        ;
        break;
      default:
        jj_la1[74] = jj_gen;
        break label_9;
      }
      SnmpModulePart();
    }
                          closeScope();
  }

  static final public void SnmpAgentCapabilitiesMacroType() throws ParseException {
   openScope(new Production(Node.SNMPAGENTCAPABILITIESMACROTYPE));
    jj_consume_token(TAGENT_CAPABILITIES);
    SnmpProductReleasePart();
    SnmpStatusPart();
    SnmpDescrPart();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TREFERENCE:
      SnmpReferPart();
      break;
    default:
      jj_la1[75] = jj_gen;
      ;
    }
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TSUPPORTS:
        ;
        break;
      default:
        jj_la1[76] = jj_gen;
        break label_10;
      }
      SnmpModuleSupportPart();
    }
                                 closeScope();
  }

  static final public void SnmpUpdatePart() throws ParseException {
   openScope(new Production(Node.SNMPUPDATEPART));
    jj_consume_token(TLAST_UPDATED);
    jj_consume_token(TCSTRING);
                               addChild(getToken(0)); closeScope();
  }

  static final public void SnmpOrganizationPart() throws ParseException {
   openScope(new Production(Node.SNMPORGANIZATIONPART));
    jj_consume_token(TORGANIZATION);
    jj_consume_token(TCSTRING);
                               addChild(getToken(0)); closeScope();
  }

  static final public void SnmpContactPart() throws ParseException {
   openScope(new Production(Node.SNMPCONTACTPART));
    jj_consume_token(TCONTACT_INFO);
    jj_consume_token(TCSTRING);
                               addChild(getToken(0)); closeScope();
  }

  static final public void SnmpDescrPart() throws ParseException {
   openScope(new Production(Node.SNMPDESCRPART));
    jj_consume_token(TDESCRIPTION);
    jj_consume_token(TCSTRING);
                              addChild(getToken(0)); closeScope();
  }

  static final public void SnmpRevisionPart() throws ParseException {
   openScope(new Production(Node.SNMPREVISIONPART));
    jj_consume_token(TREVISION);
    Value();
    jj_consume_token(TDESCRIPTION);
    jj_consume_token(TCSTRING);
                              addChild(getToken(0)); closeScope();
  }

  static final public void SnmpStatusPart() throws ParseException {
   openScope(new Production(Node.SNMPSTATUSPART));
    jj_consume_token(TSTATUS);
    Identifier();
                           closeScope();
  }

  static final public void SnmpReferPart() throws ParseException {
   openScope(new Production(Node.SNMPREFERPART));
    jj_consume_token(TREFERENCE);
    jj_consume_token(TCSTRING);
                            addChild(getToken(0)); closeScope();
  }

  static final public void SnmpSyntaxPart() throws ParseException {
   openScope(new Production(Node.SNMPSYNTAXPART));
    jj_consume_token(TSYNTAX);
    TypeOrBits();
                           closeScope();
  }

  static final public void TypeOrBits() throws ParseException {
   openScope(new Production(Node.TYPEORBITS));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TLEFTBRACKET:
    case TINTEGER:
    case TREAL:
    case TBOOLEAN:
    case TNULL:
    case TBIT:
    case TOCTET:
    case TENUMERATED:
    case TSEQUENCE:
    case TSET:
    case TCHOICE:
    case TANY:
    case TOBJECT:
    case TMODULE_IDENTITY:
    case TOBJECT_IDENTITY:
    case TOBJECT_TYPE:
    case TNOTIFICATION_TYPE:
    case TTRAP_TYPE:
    case TTEXTUAL_CONVENTION:
    case TOBJECT_GROUP:
    case TNOTIFICATION_GROUP:
    case TMODULE_COMPLIANCE:
    case TAGENT_CAPABILITIES:
    case TIDENT:
      Type();
            closeScope();
      break;
    case TBITS:
      jj_consume_token(TBITS);
      jj_consume_token(TLEFTBRACE);
      NamedBits();
      jj_consume_token(TRIGHTBRACE);
                                closeScope();
      break;
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void NamedBits() throws ParseException {
   openScope(new Production(Node.NAMEDBITS));
    NamedBit();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TCOMMA:
        ;
        break;
      default:
        jj_la1[78] = jj_gen;
        break label_11;
      }
      jj_consume_token(TCOMMA);
      NamedBit();
    }
                                  closeScope();
  }

  static final public void NamedBit() throws ParseException {
   openScope(new Production(Node.NAMEDBIT));
    Identifier();
    jj_consume_token(TLEFTPAREN);
    Number();
    jj_consume_token(TRIGHTPAREN);
  }

  static final public void SnmpUnitsPart() throws ParseException {
   openScope(new Production(Node.SNMPUNITSPART));
    jj_consume_token(TUNITS);
    jj_consume_token(TCSTRING);
                        addChild(getToken(0)); closeScope();
  }

  static final public void SnmpAccessPart() throws ParseException {
   openScope(new Production(Node.SNMPACCESSPART));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TACCESS:
      jj_consume_token(TACCESS);
      Identifier();
                           closeScope();
      break;
    case TMAX_ACCESS:
      jj_consume_token(TMAX_ACCESS);
      Identifier();
                               closeScope();
      break;
    case TMIN_ACCESS:
      jj_consume_token(TMIN_ACCESS);
      Identifier();
                               closeScope();
      break;
    default:
      jj_la1[79] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void SnmpIndexPart() throws ParseException {
   openScope(new Production(Node.SNMPINDEXPART));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TINDEX:
      jj_consume_token(TINDEX);
      jj_consume_token(TLEFTBRACE);
      TypeOrValueList();
      jj_consume_token(TRIGHTBRACE);
                                       closeScope();
      break;
    case TAUGMENTS:
      jj_consume_token(TAUGMENTS);
      jj_consume_token(TLEFTBRACE);
      Value();
      jj_consume_token(TRIGHTBRACE);
                                closeScope();
      break;
    default:
      jj_la1[80] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void TypeOrValueList() throws ParseException {
   openScope(new Production(Node.TYPEORVALUELIST));
    TypeOrValue();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TCOMMA:
        ;
        break;
      default:
        jj_la1[81] = jj_gen;
        break label_12;
      }
      jj_consume_token(TCOMMA);
      TypeOrValue();
    }
                                        closeScope();
  }

  static final public void TypeOrValue() throws ParseException {
   openScope(new Production(Node.TYPEORVALUE));
    if (jj_2_16(3)) {
      Value();
                          closeScope();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TIMPLIED:
        jj_consume_token(TIMPLIED);
               addChild(getToken(0));
        Value();
                                                  closeScope();
        break;
      case TLEFTBRACKET:
      case TINTEGER:
      case TREAL:
      case TBOOLEAN:
      case TNULL:
      case TBIT:
      case TOCTET:
      case TENUMERATED:
      case TSEQUENCE:
      case TSET:
      case TCHOICE:
      case TANY:
      case TOBJECT:
      case TMODULE_IDENTITY:
      case TOBJECT_IDENTITY:
      case TOBJECT_TYPE:
      case TNOTIFICATION_TYPE:
      case TTRAP_TYPE:
      case TTEXTUAL_CONVENTION:
      case TOBJECT_GROUP:
      case TNOTIFICATION_GROUP:
      case TMODULE_COMPLIANCE:
      case TAGENT_CAPABILITIES:
      case TIDENT:
        Type();
            closeScope();
        break;
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  static final public void SnmpDefValPart() throws ParseException {
   openScope(new Production(Node.SNMPDEFVALPART));
    jj_consume_token(TDEFVAL);
    jj_consume_token(TLEFTBRACE);
    Value();
    jj_consume_token(TRIGHTBRACE);
                              closeScope();
  }

  static final public void SnmpObjectsPart() throws ParseException {
   openScope(new Production(Node.SNMPOBJECTSPART));
    jj_consume_token(TOBJECTS);
    jj_consume_token(TLEFTBRACE);
    ValueList();
    jj_consume_token(TRIGHTBRACE);
                                   closeScope();
  }

  static final public void ValueList() throws ParseException {
   openScope(new Production(Node.VALUELIST));
    Value();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TCOMMA:
        ;
        break;
      default:
        jj_la1[83] = jj_gen;
        break label_13;
      }
      jj_consume_token(TCOMMA);
      Value();
    }
                            closeScope();
  }

  static final public void SnmpEnterprisePart() throws ParseException {
   openScope(new Production(Node.SNMPENTERPRISEPART));
    jj_consume_token(TENTERPRISE);
    Identifier();
                               closeScope();
  }

  static final public void SnmpVarPart() throws ParseException {
   openScope(new Production(Node.SNMPVARPART));
    jj_consume_token(TVARIABLES);
    jj_consume_token(TLEFTBRACE);
    VarTypes();
    jj_consume_token(TRIGHTBRACE);
                                    closeScope();
  }

  static final public void VarTypes() throws ParseException {
   openScope(new Production(Node.VARTYPES));
    Identifier();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TCOMMA:
        ;
        break;
      default:
        jj_la1[84] = jj_gen;
        break label_14;
      }
      jj_consume_token(TCOMMA);
      Identifier();
    }
                                      closeScope();
  }

  static final public void SnmpDisplayPart() throws ParseException {
   openScope(new Production(Node.SNMPDISPLAYPART));
    jj_consume_token(TDISPLAY_HINT);
    jj_consume_token(TCSTRING);
                               addChild(getToken(0)); closeScope();
  }

  static final public void SnmpNotificationsPart() throws ParseException {
   openScope(new Production(Node.SNMPNOTIFICATIONSPART));
    jj_consume_token(TNOTIFICATIONS);
    jj_consume_token(TLEFTBRACE);
    ValueList();
    jj_consume_token(TRIGHTBRACE);
                                         closeScope();
  }

  static final public void SnmpModulePart() throws ParseException {
   openScope(new Production(Node.SNMPMODULEPART));
    jj_consume_token(TMODULE);
    if (jj_2_17(2)) {
      ModuleIdentifier();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TMANDATORY_GROUPS:
      SnmpMandatoryPart();
      break;
    default:
      jj_la1[85] = jj_gen;
      ;
    }
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TOBJECT:
      case TGROUP:
        ;
        break;
      default:
        jj_la1[86] = jj_gen;
        break label_15;
      }
      SnmpCompliancePart();
    }
                             closeScope();
  }

  static final public void SnmpMandatoryPart() throws ParseException {
   openScope(new Production(Node.SNMPMANDATORYPART));
    jj_consume_token(TMANDATORY_GROUPS);
    jj_consume_token(TLEFTBRACE);
    ValueList();
    jj_consume_token(TRIGHTBRACE);
                                             closeScope();
  }

  static final public void SnmpCompliancePart() throws ParseException {
   openScope(new Production(Node.SNMPCOMPLIANCEPART));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TGROUP:
      ComplianceGroup();
                        closeScope();
      break;
    case TOBJECT:
      ComplianceObject();
                         closeScope();
      break;
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void ComplianceGroup() throws ParseException {
   openScope(new Production(Node.COMPLIANCEGROUP));
    jj_consume_token(TGROUP);
    Value();
    SnmpDescrPart();
                      closeScope();
  }

  static final public void ComplianceObject() throws ParseException {
   openScope(new Production(Node.COMPLIANCEOBJECT));
    jj_consume_token(TOBJECT);
    Value();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TSYNTAX:
      SnmpSyntaxPart();
      break;
    default:
      jj_la1[88] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TWRITE_SYNTAX:
      SnmpWriteSyntaxPart();
      break;
    default:
      jj_la1[89] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TACCESS:
    case TMAX_ACCESS:
    case TMIN_ACCESS:
      SnmpAccessPart();
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
    SnmpDescrPart();
                      closeScope();
  }

  static final public void SnmpWriteSyntaxPart() throws ParseException {
   openScope(new Production(Node.SNMPWRITESYNTAXPART));
    jj_consume_token(TWRITE_SYNTAX);
    Type();
                            closeScope();
  }

  static final public void SnmpProductReleasePart() throws ParseException {
   openScope(new Production(Node.SNMPPRODUCTRELEASEPART));
    jj_consume_token(TPRODUCT_RELEASE);
    jj_consume_token(TCSTRING);
                                   addChild(getToken(0)); closeScope();
  }

  static final public void SnmpModuleSupportPart() throws ParseException {
   openScope(new Production(Node.SNMPMODULESUPPORTPART));
    jj_consume_token(TSUPPORTS);
    ModuleIdentifier();
    jj_consume_token(TINCLUDES);
    jj_consume_token(TLEFTBRACE);
    ValueList();
    jj_consume_token(TRIGHTBRACE);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TVARIATION:
        ;
        break;
      default:
        jj_la1[91] = jj_gen;
        break label_16;
      }
      SnmpVariationPart();
    }
                             closeScope();
  }

  static final public void SnmpVariationPart() throws ParseException {
   openScope(new Production(Node.SNMPVARIATIONPART));
    jj_consume_token(TVARIATION);
    Value();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TSYNTAX:
      SnmpSyntaxPart();
      break;
    default:
      jj_la1[92] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TWRITE_SYNTAX:
      SnmpWriteSyntaxPart();
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TACCESS:
    case TMAX_ACCESS:
    case TMIN_ACCESS:
      SnmpAccessPart();
      break;
    default:
      jj_la1[94] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TCREATION_REQUIRES:
      SnmpCreationPart();
      break;
    default:
      jj_la1[95] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TDEFVAL:
      SnmpDefValPart();
      break;
    default:
      jj_la1[96] = jj_gen;
      ;
    }
    SnmpDescrPart();
                      closeScope();
  }

  static final public void SnmpCreationPart() throws ParseException {
   openScope(new Production(Node.SNMPCREATIONPART));
    jj_consume_token(TCREATION_REQUIRES);
    jj_consume_token(TLEFTBRACE);
    ValueList();
    jj_consume_token(TRIGHTBRACE);
                                              closeScope();
  }

  static final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  static final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  static final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  static final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  static final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  static final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  static final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  static final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  static final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  static final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  static final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_11();
    jj_save(10, xla);
    return retval;
  }

  static final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_12();
    jj_save(11, xla);
    return retval;
  }

  static final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_13();
    jj_save(12, xla);
    return retval;
  }

  static final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_14();
    jj_save(13, xla);
    return retval;
  }

  static final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_15();
    jj_save(14, xla);
    return retval;
  }

  static final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_16();
    jj_save(15, xla);
    return retval;
  }

  static final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_17();
    jj_save(16, xla);
    return retval;
  }

  static final private boolean jj_3R_142() {
    if (jj_scan_token(TFALSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_118() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_141() {
    if (jj_scan_token(TTRUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_29() {
    if (jj_scan_token(TDEFVAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TLEFTBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_91() {
    if (jj_3R_74()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_90() {
    if (jj_3R_124()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_89() {
    if (jj_3R_123()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_16() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_88() {
    if (jj_3R_122()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_87() {
    if (jj_3R_121()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_86() {
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_85() {
    if (jj_3R_119()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_84() {
    if (jj_3R_118()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_54() {
    if (jj_3R_74()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_10() {
    if (jj_3R_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TDOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_53() {
    if (jj_3R_73()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_52() {
    if (jj_3R_72()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_31() {
    if (jj_3R_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_114() {
    if (jj_scan_token(TSIZE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_70() {
    if (jj_scan_token(TMIN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_153() {
    if (jj_scan_token(TSYNTAX)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_71() {
    if (jj_scan_token(TLESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_69() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_71()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_26() {
    if (jj_3R_51()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TDOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TDOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_152() {
    if (jj_scan_token(TSTATUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_9() {
    if (jj_3R_26()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_140() {
    if (jj_3R_135()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_28() {
    if (jj_scan_token(TDESCRIPTION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TCSTRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_135() {
    if (jj_scan_token(TLEFTPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_117() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_139() {
    if (jj_3R_81()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_8() {
    if (jj_3R_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TDOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_117()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_83() {
    if (jj_scan_token(TDEFINED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_151() {
    if (jj_scan_token(TLAST_UPDATED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_68() {
    if (jj_scan_token(TANY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_150() {
    if (jj_scan_token(TPRIVATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_149() {
    if (jj_scan_token(TAPPLICATION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_148() {
    if (jj_scan_token(TUNIVERSAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_136() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_134() {
    if (jj_scan_token(TAGENT_CAPABILITIES)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_159()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_138() {
    if (jj_3R_73()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_116() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_137() {
    if (jj_3R_146()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_115() {
    if (jj_3R_136()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_133() {
    if (jj_scan_token(TMODULE_COMPLIANCE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_152()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_82() {
    if (jj_scan_token(TLEFTBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_115()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_116()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_67() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_132() {
    if (jj_scan_token(TNOTIFICATION_GROUP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_158()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_66() {
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TLESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_131() {
    if (jj_scan_token(TOBJECT_GROUP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_157()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_65() {
    if (jj_scan_token(TENUMERATED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_81()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_64() {
    if (jj_scan_token(TCHOICE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TLEFTBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_156() {
    if (jj_3R_161()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_130() {
    if (jj_scan_token(TTEXTUAL_CONVENTION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_152()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_7() {
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_15() {
    if (jj_3R_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_50() {
    if (jj_scan_token(TDEFAULT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_129() {
    if (jj_scan_token(TTRAP_TYPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_155()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_49() {
    if (jj_scan_token(TOPTIONAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_6() {
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_23()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_154() {
    if (jj_3R_157()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_80() {
    if (jj_3R_114()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_128() {
    if (jj_scan_token(TNOTIFICATION_TYPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_154()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_152()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_63() {
    if (jj_scan_token(TSET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TOF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_14() {
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_79() {
    if (jj_3R_114()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_13() {
    if (jj_3R_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_21() {
    if (jj_scan_token(TSET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TLEFTBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_127() {
    if (jj_scan_token(TOBJECT_TYPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_153()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_62() {
    if (jj_scan_token(TSEQUENCE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TOF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_126() {
    if (jj_scan_token(TOBJECT_IDENTITY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_152()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_20() {
    if (jj_scan_token(TSEQUENCE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TLEFTBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_61() {
    if (jj_scan_token(TBIT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TSTRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_125() {
    if (jj_scan_token(TMODULE_IDENTITY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_151()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_113() {
    if (jj_3R_135()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_60() {
    if (jj_scan_token(TOCTET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TSTRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_101() {
    if (jj_scan_token(TAGENT_CAPABILITIES)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_100() {
    if (jj_scan_token(TMODULE_COMPLIANCE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_99() {
    if (jj_scan_token(TNOTIFICATION_GROUP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_145() {
    if (jj_scan_token(TMINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_98() {
    if (jj_scan_token(TOBJECT_GROUP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_121() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_145()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_146()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_97() {
    if (jj_scan_token(TTEXTUAL_CONVENTION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_96() {
    if (jj_scan_token(TTRAP_TYPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_95() {
    if (jj_scan_token(TNOTIFICATION_TYPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_94() {
    if (jj_scan_token(TOBJECT_TYPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_93() {
    if (jj_scan_token(TOBJECT_IDENTITY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_92() {
    if (jj_scan_token(TMODULE_IDENTITY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_78() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_112() {
    if (jj_3R_81()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_111() {
    if (jj_3R_134()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_110() {
    if (jj_3R_133()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_81() {
    if (jj_scan_token(TLEFTBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_109() {
    if (jj_3R_132()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_108() {
    if (jj_3R_131()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_107() {
    if (jj_3R_130()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_106() {
    if (jj_3R_129()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_105() {
    if (jj_3R_128()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_104() {
    if (jj_3R_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_103() {
    if (jj_3R_126()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_59() {
    if (jj_scan_token(TINTEGER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_102() {
    if (jj_3R_125()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_48() {
    if (jj_3R_68()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_47() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_159() {
    if (jj_scan_token(TPRODUCT_RELEASE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_46() {
    if (jj_3R_66()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_45() {
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_44() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_43() {
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_5() {
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_42() {
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_33() {
    if (jj_scan_token(TIDENT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_4() {
    if (jj_3R_20()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_41() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_40() {
    if (jj_3R_60()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_39() {
    if (jj_3R_59()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_38() {
    if (jj_scan_token(TOBJECT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TIDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_37() {
    if (jj_scan_token(TNULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_25() {
    if (jj_scan_token(TIDENT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_36() {
    if (jj_scan_token(TREAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_35() {
    if (jj_scan_token(TBOOLEAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_24() {
    if (jj_scan_token(TIDENT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_58() {
    if (jj_3R_77()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_57() {
    if (jj_3R_76()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_3() {
    if (jj_3R_19()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_34() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_146() {
    if (jj_scan_token(TNUMBER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_18() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TASSIGN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_124() {
    if (jj_scan_token(TCSTRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_122() {
    if (jj_scan_token(THEXSTRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_17() {
    if (jj_3R_31()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_56() {
    if (jj_3R_75()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_55() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_32() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_123() {
    if (jj_scan_token(TBINSTRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_27() {
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TLEFTPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_158() {
    if (jj_scan_token(TNOTIFICATIONS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_164() {
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_163() {
    if (jj_3R_146()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_162() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_12() {
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_161() {
    if (jj_scan_token(TDISPLAY_HINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_17() {
    if (jj_3R_32()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TMACRO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_160() {
    if (jj_3R_162()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_147() {
    Token xsp;
    if (jj_3R_160()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_160()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  static final private boolean jj_3_2() {
    if (jj_3R_18()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_1() {
    if (jj_3R_17()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_74() {
    if (jj_scan_token(TLEFTBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_147()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(TRIGHTBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3_11() {
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_155() {
    if (jj_scan_token(TENTERPRISE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_119() {
    if (jj_scan_token(TNULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_144() {
    if (jj_scan_token(TMINUS_INFINITY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_143() {
    if (jj_scan_token(TPLUS_INFINITY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_120() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static final private boolean jj_3R_157() {
    if (jj_scan_token(TOBJECTS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  static private boolean jj_initialized_once = false;
  static public AsnParserTokenManager token_source;
  static SimpleCharStream jj_input_stream;
  static public Token token, jj_nt;
  static private int jj_ntk;
  static private Token jj_scanpos, jj_lastpos;
  static private int jj_la;
  static public boolean lookingAhead = false;
  static private boolean jj_semLA;
  static private int jj_gen;
  static final private int[] jj_la1 = new int[97];
  static final private int[] jj_la1_0 = {0xc00000,0xc00000,0x2000,0x8000000,0x10000000,0x0,0x0,0x0,0x200,0x0,0x0,0x400,0x0,0x2000000,0x0,0x0,0x80000000,0x0,0x8000,0x2800,0x2800,0x200,0x20000,0x20000,0x800,0x2800,0x2800,0x80008000,0x0,0x80008000,0x0,0x200,0x0,0x0,0x0,0x0,0xc00000,0xc00000,0x0,0x0,0x0,0x0,0x2800,0x2800,0x80000,0x20022000,0x22000,0x22000,0x40000,0x40000,0x22000,0x22000,0x22000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80008000,0x200,0x0,0x0,0x200,0x80008000,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  static final private int[] jj_la1_1 = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2001f,0x80,0x4540,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20245df,0x400000,0x20245df,0x400000,0x0,0x30000000,0x30000000,0x0,0x2000000,0x0,0x0,0x3800,0x0,0x3800,0x8000,0x0,0x0,0x0,0xc0500004,0xc0000004,0xc0100004,0x0,0x0,0xc0200004,0xc0000004,0xc0000004,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x245df,0x0,0x0,0x0,0x0,0x245df,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  static final private int[] jj_la1_2 = {0x0,0x0,0x0,0x0,0x0,0xffc,0xffc,0xffc,0x0,0xffc,0xffc,0x0,0x0,0x0,0xffc,0xffc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffc,0x0,0xffc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x3,0x0,0x0,0x3,0x3,0x3,0x0,0x3,0x0,0x0,0x0,0xffc,0xffc,0x10000,0x40000,0x200000,0x40000,0x6000000,0x20000000,0x40000,0x80000000,0x40000,0x0,0x40000,0x40000,0x40000,0x40000,0x0,0x40000,0x0,0x100ffc,0x0,0x1c00000,0x6000000,0x0,0x8000ffc,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x1c00000,0x0,0x80000,0x0,0x1c00000,0x0,0x10000000,};
  static final private int[] jj_la1_3 = {0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x2000,0x0,0x2000,0x2000,0x0,0x2000,0x2000,0x2000,0x2000,0x0,0x0,0x2000,0x0,0x0,0x0,0x6000,0x0,0x0,0x0,0x0,0x2000,0x0,0x2000,0x0,0x0,0x0,0x0,0x2000,0x2000,0x0,0x0,0x0,0x6000,0x0,0x0,0x0,0x0,0x0,0x7c00,0x7c00,0x7c00,0x0,0x0,0x7c00,0x7c00,0x5c00,0x0,0x0,0x6000,0x6000,0x6000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x4,0x0,0x80,0x2000,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x8,0x10,0x10,0x0,0x20,0x0,0x100,0x0,0x20,0x0,0x200,0x0,};
  static final private JJCalls[] jj_2_rtns = new JJCalls[17];
  static private boolean jj_rescan = false;
  static private int jj_gc = 0;

  public AsnParser(java.io.InputStream stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new AsnParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public AsnParser(java.io.Reader stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new AsnParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public AsnParser(AsnParserTokenManager tm) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(AsnParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  static final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  static final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  static private java.util.Vector jj_expentries = new java.util.Vector();
  static private int[] jj_expentry;
  static private int jj_kind = -1;
  static private int[] jj_lasttokens = new int[100];
  static private int jj_endpos;

  static private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  static final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[111];
    for (int i = 0; i < 111; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 97; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 111; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  static final public void enable_tracing() {
  }

  static final public void disable_tracing() {
  }

  static final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 17; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  static final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
