# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import gtk

VERSION='0.2.0'

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Mobius base window
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class MobiusBaseWindow (gtk.Window):

  def __init__ (self, app, *args):
    gtk.Window.__init__ (self, *args)
    self.connect ('delete-event', self.on_close_window)
    self.set_title ('Mobius v%s' % VERSION)

    # accel_group
    self.accel_group = gtk.AccelGroup ()
    self.add_accel_group (self.accel_group)

    # vbox
    self.vbox = gtk.VBox (False, 1)
    self.vbox.set_border_width (1)
    self.add (self.vbox)
    self.vbox.show ()

    # menubar
    self.menubar = gtk.MenuBar ()
    self.menubar.show ()
    self.vbox.pack_start (self.menubar, False, False)

    item = gtk.MenuItem ('_File')
    item.show ()
    self.menubar.append (item)

    self.file_menu = gtk.Menu ()
    self.file_menu.show ()
    item.set_submenu (self.file_menu)

    item = gtk.ImageMenuItem (gtk.STOCK_CLOSE, self.accel_group)
    item.connect ("activate", self.on_close_window)
    item.show ()
    self.file_menu.append (item)

    item = gtk.SeparatorMenuItem ()
    item.show ()
    self.file_menu.append (item)

    item = gtk.ImageMenuItem (gtk.STOCK_QUIT, self.accel_group)
    item.connect ("activate", app.on_app_quit)
    item.show ()
    self.file_menu.append (item)

    item = gtk.MenuItem ('_Help')
    item.show ()
    self.menubar.append (item)

    self.help_menu = gtk.Menu ()
    self.help_menu.show ()
    item.set_submenu (self.help_menu)

    item = gtk.ImageMenuItem (gtk.STOCK_ABOUT, self.accel_group)
    item.connect ("activate", self.on_help_about)
    item.show ()
    self.help_menu.append (item)

    # toolbar
    self.tooltips = gtk.Tooltips ()

    handlebox = gtk.HandleBox ()
    handlebox.show ()
    self.vbox.pack_start (handlebox, False, False)

    self.toolbar = gtk.Toolbar ()
    self.toolbar.set_style (gtk.TOOLBAR_ICONS)
    self.toolbar.set_tooltips (True)
    self.toolbar.show ()
    handlebox.add (self.toolbar)

    button = gtk.ToolButton (gtk.STOCK_QUIT)
    button.connect ("clicked", app.on_app_quit)
    button.show ()
    button.set_tooltip (self.tooltips, "Exit from Mobius")
    self.toolbar.insert (button, -1)

    # status bar
    frame = gtk.Frame ()
    frame.set_shadow_type (gtk.SHADOW_IN)
    frame.show ()
    self.vbox.pack_end (frame, False, False)

    self.status_label = gtk.Label ()
    self.status_label.set_alignment (0, -1)
    self.status_label.show ()
    frame.add (self.status_label)

    # windows data
    self.app = app
    self.id = app.get_next_id ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  # @brief close window
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  def on_close_window (self, *args):
    return self.app.destroy_window (self.id)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  # @brief call 'about' dialog
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  def on_help_about (self, widget, *args):
    dialog = gtk.AboutDialog ()
    dialog.set_name ('Mobius Forensic Tool')
    dialog.set_version (VERSION)
    dialog.set_copyright ('Copyright (C) 2007 Eduardo Aguiar')
    dialog.set_license ('GNU Public License')
    dialog.set_authors (['Eduardo Aguiar <aguiar.users@sourceforge.net>'])
    dialog.set_comments ('Open-source forensic tool')
    dialog.run ()
    dialog.destroy ()
