// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "api_filesystem_hfs.h"
#include "api_datetime.h"
#include <mobius/filesystem/filesystem_hfs.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief api_filesystem_hfs: tp_new
//! \param type type object
//! \param args argument list
//! \param kwds keywords dict
//! \return new api.filesystem_hfs object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_tp_new (PyTypeObject *type, PyObject *args, PyObject *)
{
  // if (!PyArg_ParseTuple (args, "|s", &arg_uri))
  //   return nulptr;

  api_filesystem_hfs_o *self = (api_filesystem_hfs_o *) type->tp_alloc (type, 0);
  if (self)
    {
  //  try
  //    {
  //      if (arg_uri)
  //        self->obj = new mobius::filesystem::filesystem_hfs (arg_uri);
  //      else
  //        self->obj = new mobius::filesystem::filesystem_hfs ();
  //    }
  //  catch (const std::runtime_error& e)
  //    {
  //      Py_DECREF (self);
  //      PyErr_SetString (PyExc_IOError, e.what ());
  //      self = nulptr;
  //    }
    }

  return (PyObject *) self;
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
api_filesystem_hfs_tp_dealloc (api_filesystem_hfs_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: offset getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_offset (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_offset ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_size (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_name (api_filesystem_hfs_o *self)
{
  return PyString_FromString (self->obj->get_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: fs_type getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_fs_type (api_filesystem_hfs_o *self)
{
  return PyString_FromString (self->obj->get_fs_type ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: volume_uuid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_volume_uuid (api_filesystem_hfs_o *self)
{
  return PyString_FromString (self->obj->get_volume_uuid ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: volume_name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_volume_name (api_filesystem_hfs_o *self)
{
  return PyString_FromString (self->obj->get_volume_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: signature getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_signature (api_filesystem_hfs_o *self)
{
  return PyString_FromString (self->obj->get_signature ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_version (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: attributes getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_attributes (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_attributes ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: creation_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_creation_time (api_filesystem_hfs_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_creation_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: last_modification_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_last_modification_time (api_filesystem_hfs_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_last_modification_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: last_backup_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_last_backup_time (api_filesystem_hfs_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_last_backup_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: last_check_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_last_check_time (api_filesystem_hfs_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_last_check_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: file_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_file_count (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_file_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: folder_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_folder_count (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_folder_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: block_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_block_size (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_block_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: total_blocks getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_total_blocks (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_total_blocks ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: free_blocks getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_free_blocks (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_free_blocks ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: mount_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_hfs_getter_mount_count (api_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_mount_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef api_filesystem_hfs_getsetters[] =
{
  {
    (char *) "offset",
    (getter) api_filesystem_hfs_getter_offset,
    (setter) 0,
    (char *) "offset in bytes", NULL
  },
  {
    (char *) "size",
    (getter) api_filesystem_hfs_getter_size,
    (setter) 0,
    (char *) "filesystem size in bytes", NULL
  },
  {
    (char *) "name",
    (getter) api_filesystem_hfs_getter_name,
    (setter) 0,
    (char *) "filesystem name", NULL
  },
  {
    (char *) "fs_type",
    (getter) api_filesystem_hfs_getter_fs_type,
    (setter) 0,
    (char *) "filesystem type", NULL
  },
  {
    (char *) "volume_uuid",
    (getter) api_filesystem_hfs_getter_volume_uuid,
    (setter) 0,
    (char *) "volume UUID", NULL
  },
  {
    (char *) "volume_name",
    (getter) api_filesystem_hfs_getter_volume_name,
    (setter) 0,
    (char *) "volume name", NULL
  },
  {
    (char *) "signature",
    (getter) api_filesystem_hfs_getter_signature,
    (setter) 0,
    (char *) "file system signature", NULL
  },
  {
    (char *) "version",
    (getter) api_filesystem_hfs_getter_version,
    (setter) 0,
    (char *) "file system version", NULL
  },
  {
    (char *) "attributes",
    (getter) api_filesystem_hfs_getter_attributes,
    (setter) 0,
    (char *) "attributes", NULL
  },
  {
    (char *) "creation_time",
    (getter) api_filesystem_hfs_getter_creation_time,
    (setter) 0,
    (char *) "file system creation date/time", NULL
  },
  {
    (char *) "last_modification_time",
    (getter) api_filesystem_hfs_getter_last_modification_time,
    (setter) 0,
    (char *) "last modification date/time", NULL
  },
  {
    (char *) "last_backup_time",
    (getter) api_filesystem_hfs_getter_last_backup_time,
    (setter) 0,
    (char *) "last backup date/time", NULL
  },
  {
    (char *) "last_check_time",
    (getter) api_filesystem_hfs_getter_last_check_time,
    (setter) 0,
    (char *) "last check date/time", NULL
  },
  {
    (char *) "file_count",
    (getter) api_filesystem_hfs_getter_file_count,
    (setter) 0,
    (char *) "total number of files", NULL
  },
  {
    (char *) "folder_count",
    (getter) api_filesystem_hfs_getter_folder_count,
    (setter) 0,
    (char *) "total number of folders", NULL
  },
  {
    (char *) "block_size",
    (getter) api_filesystem_hfs_getter_block_size,
    (setter) 0,
    (char *) "block size in bytes", NULL
  },
  {
    (char *) "total_blocks",
    (getter) api_filesystem_hfs_getter_total_blocks,
    (setter) 0,
    (char *) "number of allocation blocks", NULL
  },
  {
    (char *) "free_blocks",
    (getter) api_filesystem_hfs_getter_free_blocks,
    (setter) 0,
    (char *) "number of unused allocation blocks", NULL
  },
  {
    (char *) "mount_count",
    (getter) api_filesystem_hfs_getter_mount_count,
    (setter) 0,
    (char *) "number of times the file system was mounted", NULL
  },
  {NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_hfs: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject api_filesystem_hfs_t =
{
  PyObject_HEAD_INIT (0)
  0,                                         		// ob_size
  "api.filesystem_hfs",                      		// tp_name
  sizeof (api_filesystem_hfs_o),             		// tp_basicsize
  0,                                         		// tp_itemsize
  (destructor) api_filesystem_hfs_tp_dealloc,		// tp_dealloc
  0,                                         		// tp_print
  0,                                         		// tp_getattr
  0,                                         		// tp_setattr
  0,                                         		// tp_compare
  0,                                         		// tp_repr
  0,                                         		// tp_as_number
  0,                                         		// tp_as_sequence
  0,                                         		// tp_as_mapping
  0,                                         		// tp_hash
  0,                                         		// tp_call
  0,                                         		// tp_str
  0,                                         		// tp_getattro
  0,                                         		// tp_setattro
  0,                                         		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,  		// tp_flags
  "filesystem_hfs class",                    		// tp_doc
  0,                                         		// tp_traverse
  0,                                         		// tp_clear
  0,                                         		// tp_richcompare
  0,                                         		// tp_weaklistoffset
  0,                                         		// tp_iter
  0,                                         		// tp_iternext
  0,                                         		// tp_methods
  0,                                         		// tp_members
  api_filesystem_hfs_getsetters,             		// tp_getset
  0,                                         		// tp_base
  0,                                         		// tp_dict
  0,                                         		// tp_descr_get
  0,                                         		// tp_descr_set
  0,                                         		// tp_dictoffset
  0,                                         		// tp_init
  0,                                         		// tp_alloc
  0                                          		// tp_new
};
