// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.filesystem module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "filesystem.h"
#include "filesystem_ext2.h"
#include "filesystem_hfs.h"
#include "filesystem_iso.h"
#include "filesystem_ntfs.h"
#include "filesystem_vfat.h"
#include "entry.h"
#include "stream.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief functions prototypes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject* func_get_filesystems (PyObject *, PyObject *);

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    "get_filesystems",
    func_get_filesystems,
    METH_VARARGS,
    "get filesystems from a given disk"
  },
  {
    NULL,
    NULL,
    0,
    NULL
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief create mobius.filesystem module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *new_filesystem_module ()
{
  // initialize module
  PyObject* module = Py_InitModule3 (
    "filesystem",
    module_methods,
    "Mobius Forensic Toolkit mobius.filesystem module"
  );

  // build types
  if (PyType_Ready (&filesystem_filesystem_t) < 0)
    return nullptr;

  if (PyType_Ready (&filesystem_filesystem_ext2_t) < 0)
    return nullptr;

  if (PyType_Ready (&filesystem_filesystem_hfs_t) < 0)
    return nullptr;

  if (PyType_Ready (&filesystem_filesystem_iso_t) < 0)
    return nullptr;

  if (PyType_Ready (&filesystem_filesystem_ntfs_t) < 0)
    return nullptr;

  if (PyType_Ready (&filesystem_filesystem_vfat_t) < 0)
    return nullptr;

  if (PyType_Ready (&filesystem_entry_t) < 0)
    return nullptr;

  if (PyType_Ready (&filesystem_stream_t) < 0)
    return nullptr;

  // add types
  Py_INCREF (&filesystem_filesystem_t);
  PyModule_AddObject (module, "filesystem", (PyObject *) &filesystem_filesystem_t);
  
  Py_INCREF (&filesystem_filesystem_ext2_t);
  PyModule_AddObject (module, "filesystem_ext2", (PyObject *) &filesystem_filesystem_ext2_t);
  
  Py_INCREF (&filesystem_filesystem_hfs_t);
  PyModule_AddObject (module, "filesystem_hfs", (PyObject *) &filesystem_filesystem_hfs_t);
  
  Py_INCREF (&filesystem_filesystem_iso_t);
  PyModule_AddObject (module, "filesystem_iso", (PyObject *) &filesystem_filesystem_iso_t);
  
  Py_INCREF (&filesystem_filesystem_ntfs_t);
  PyModule_AddObject (module, "filesystem_ntfs", (PyObject *) &filesystem_filesystem_ntfs_t);
  
  Py_INCREF (&filesystem_filesystem_vfat_t);
  PyModule_AddObject (module, "filesystem_vfat", (PyObject *) &filesystem_filesystem_vfat_t);
  
  Py_INCREF (&filesystem_entry_t);
  PyModule_AddObject (module, "entry", (PyObject *) &filesystem_entry_t);
  
  Py_INCREF (&filesystem_stream_t);
  PyModule_AddObject (module, "stream", (PyObject *) &filesystem_stream_t);
  
  // return module
  return module;
}
