# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import mobius
import pymobius
import pymobius.util
import pymobius.app.chrome
import sqlite3
import binascii

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Load data from Cookies file
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode (path):

  # create data object
  data = pymobius.Data ()
  data.cookies = []
  
  # get meta version
  db = sqlite3.connect (path)
  db.text_factory = str
  data.version = pymobius.app.chrome.get_meta_version (db)

  if data.version:
    mobius.core.log ('app.chrome: Cookies.version = %s' % data.version)

    decode_cookies (db, data)

  db.close ()

  # return data object
  return data

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Retrieve data from cookies table
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode_cookies (db, data):
  if data.version <= 5:
    decode_cookies_5 (db, data)

  else:
    decode_cookies_8 (db, data)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Retrieve data from cookies table
# Tested versions: 5
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode_cookies_5 (db, data):
  cursor = db.cursor ()

  stmt = '''
       SELECT _rowid_,
              host_key,
              name,
              value,
              last_access_utc,
              creation_utc
         FROM cookies'''

  for row in cursor.execute (stmt):
    entry = pymobius.Data ()
    entry.id = row[0]
    entry.domain = row[1]
    entry.name = row[2]
    entry.value = row[3]
    entry.last_access_time = mobius.datetime.new_datetime_from_nt_timestamp (row[4] * 10)
    entry.creation_time = mobius.datetime.new_datetime_from_nt_timestamp (row[5] * 10)

    data.cookies.append (entry)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Retrieve data from cookies table
# Tested versions: 7-10
# @todo Decrypt encrypted_value using DPAPI
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode_cookies_8 (db, data):
  cursor = db.cursor ()

  stmt = '''
       SELECT _rowid_,
              host_key,
              name,
              encrypted_value,
              last_access_utc,
              creation_utc
         FROM cookies'''

  for row in cursor.execute (stmt):
    entry = pymobius.Data ()
    entry.id = row[0]
    entry.domain = row[1]
    entry.name = row[2]
    entry.value = '<ENCRYPTED>' #binascii.hexlify (row[3])
    entry.last_access_time = mobius.datetime.new_datetime_from_nt_timestamp (row[4] * 10)
    entry.creation_time = mobius.datetime.new_datetime_from_nt_timestamp (row[5] * 10)

    data.cookies.append (entry)
