// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.h>
#include "filesystem_hfs.h"
#include "filesystem.h"
#include "api_metadata.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
tp_dealloc (filesystem_filesystem_hfs_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: volume_uuid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_uuid (filesystem_filesystem_hfs_o *self)
{
  return PyString2_from_std_string (self->obj->get_volume_uuid ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: volume_name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_name (filesystem_filesystem_hfs_o *self)
{
  return PyString2_from_std_string (self->obj->get_volume_name ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: signature getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_signature (filesystem_filesystem_hfs_o *self)
{
  return PyString2_from_std_string (self->obj->get_signature ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_version (filesystem_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: attributes getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_attributes (filesystem_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_attributes ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: creation_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_creation_time (filesystem_filesystem_hfs_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_creation_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: last_modification_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_last_modification_time (filesystem_filesystem_hfs_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_last_modification_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: last_backup_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_last_backup_time (filesystem_filesystem_hfs_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_last_backup_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: last_check_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_last_check_time (filesystem_filesystem_hfs_o *self)
{
  return mobius::py::pydatetime_from_datetime (self->obj->get_last_check_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: file_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_file_count (filesystem_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_file_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: folder_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_folder_count (filesystem_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_folder_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: block_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_block_size (filesystem_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_block_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: total_blocks getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_total_blocks (filesystem_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_total_blocks ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: free_blocks getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_free_blocks (filesystem_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_free_blocks ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: mount_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_mount_count (filesystem_filesystem_hfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_mount_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef tp_getset[] =
{
  {
    (char *) "volume_uuid",
    (getter) tp_getter_volume_uuid,
    (setter) 0,
    (char *) "volume UUID", NULL
  },
  {
    (char *) "volume_name",
    (getter) tp_getter_volume_name,
    (setter) 0,
    (char *) "volume name", NULL
  },
  {
    (char *) "signature",
    (getter) tp_getter_signature,
    (setter) 0,
    (char *) "file system signature", NULL
  },
  {
    (char *) "version",
    (getter) tp_getter_version,
    (setter) 0,
    (char *) "file system version", NULL
  },
  {
    (char *) "attributes",
    (getter) tp_getter_attributes,
    (setter) 0,
    (char *) "attributes", NULL
  },
  {
    (char *) "creation_time",
    (getter) tp_getter_creation_time,
    (setter) 0,
    (char *) "file system creation date/time", NULL
  },
  {
    (char *) "last_modification_time",
    (getter) tp_getter_last_modification_time,
    (setter) 0,
    (char *) "last modification date/time", NULL
  },
  {
    (char *) "last_backup_time",
    (getter) tp_getter_last_backup_time,
    (setter) 0,
    (char *) "last backup date/time", NULL
  },
  {
    (char *) "last_check_time",
    (getter) tp_getter_last_check_time,
    (setter) 0,
    (char *) "last check date/time", NULL
  },
  {
    (char *) "file_count",
    (getter) tp_getter_file_count,
    (setter) 0,
    (char *) "total number of files", NULL
  },
  {
    (char *) "folder_count",
    (getter) tp_getter_folder_count,
    (setter) 0,
    (char *) "total number of folders", NULL
  },
  {
    (char *) "block_size",
    (getter) tp_getter_block_size,
    (setter) 0,
    (char *) "block size in bytes", NULL
  },
  {
    (char *) "total_blocks",
    (getter) tp_getter_total_blocks,
    (setter) 0,
    (char *) "number of allocation blocks", NULL
  },
  {
    (char *) "free_blocks",
    (getter) tp_getter_free_blocks,
    (setter) 0,
    (char *) "number of unused allocation blocks", NULL
  },
  {
    (char *) "mount_count",
    (getter) tp_getter_mount_count,
    (setter) 0,
    (char *) "number of times the file system was mounted", NULL
  },
  {NULL, NULL, 0, NULL, NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_hfs: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject filesystem_filesystem_hfs_t =
{
  PyVarObject_HEAD_INIT (NULL, 0)
  "mobius.filesystem.filesystem_hfs",         		// tp_name
  sizeof (filesystem_filesystem_hfs_o),    		// tp_basicsize
  0,                                         		// tp_itemsize
  (destructor) tp_dealloc,	                     	// tp_dealloc
  0,                                         		// tp_print
  0,                                         		// tp_getattr
  0,                                         		// tp_setattr
  0,                                         		// tp_compare
  0,                                         		// tp_repr
  0,                                         		// tp_as_number
  0,                                         		// tp_as_sequence
  0,                                         		// tp_as_mapping
  0,                                         		// tp_hash
  0,                                         		// tp_call
  0,                                         		// tp_str
  0,                                         		// tp_getattro
  0,                                         		// tp_setattro
  0,                                         		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,  		// tp_flags
  "filesystem_hfs class",                    		// tp_doc
  0,                                         		// tp_traverse
  0,                                         		// tp_clear
  0,                                         		// tp_richcompare
  0,                                         		// tp_weaklistoffset
  0,                                         		// tp_iter
  0,                                         		// tp_iternext
  0,                                	           	// tp_methods
  0,                                         		// tp_members
  tp_getset,             	                      	// tp_getset
  &filesystem_filesystem_t,                   		// tp_base
  0,                                         		// tp_dict
  0,                                         		// tp_descr_get
  0,                                         		// tp_descr_set
  0,                                         		// tp_dictoffset
  0,                                         		// tp_init
  0,                                         		// tp_alloc
  0,                                          		// tp_new
  0,                                       		// tp_free
  0,                                       		// tp_is_gc
  0,                                       		// tp_bases
  0,                                       		// tp_mro
  0,                                       		// tp_cache
  0,                                       		// tp_subclasses
  0,                                       		// tp_weaklist
  0,                                       		// tp_del
  0,                                       		// tp_version_tag
};
