// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.turing module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.h>
#include <mobius/os/win/hash_msdcc2.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief hash_msdcc2 function
//! \param self function object
//! \param args argument list
//! \return Python object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
func_hash_msdcc2 (PyObject *, PyObject *args)
{
  // parse input args
  const char * arg_password;
  const char * arg_username;
  int arg_iterations = 10240;

  if (!PyArg_ParseTuple (args, "ss|i", &arg_password, &arg_username, &arg_iterations))
    return nullptr;

  // execute C++ function
  PyObject *ret = nullptr;
  PyThreadState *_save = PyEval_SaveThread ();

  try
    {
      auto digest = mobius::os::win::hash_msdcc2 (arg_password, arg_username, arg_iterations);

      PyEval_RestoreThread (_save);
      ret = mobius::py::pybytes_from_bytearray (digest);
    }
  catch (const std::exception& e)
    {
      PyEval_RestoreThread(_save);
      PyErr_SetString (PyExc_IOError, e.what ());
    }

  // return value
  return ret;
}
