# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import pymobius
import pymobius.app.internet_explorer

APP_ID = 'ie'
APP_NAME = 'Internet Explorer'

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Retrieve Internet Explorer browser artifacts
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def retrieve (os, item, model):

  # retrieve data from OS installed
  app_model = pymobius.app.internet_explorer.model (item)

  # add profiles
  for profile in app_model.get_profiles ():
    p = pymobius.Data ()
    p.app = APP_ID
    p.app_name = APP_NAME
    p.name = profile.name
    p.path = profile.path
    p.username = profile.username
    
    model.profiles.append (p)

    # add form history
    for entry in profile.get_form_history ():
      h = pymobius.Data ()
      h.app = APP_ID
      h.app_name = APP_NAME
      h.username = profile.username
      h.fieldname = entry.fieldname
      h.itemname = item.name
      h.value = entry.value
      h.profile_id = profile.name
      h.profile_path = profile.path

      h.metadata = []
      h.metadata.append (('First used date/time', str (entry.first_used_time)[:19]))
      h.metadata.append (('Last used date/time', str (entry.last_used_time)[:19]))

      model.form_history.append (h)
