// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.core module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "module.h"
#include <pymobius.h>
#include "application.h"
#include "attribute.h"
#include "category.h"
#include "category_manager.h"
#include "extension.h"
#include "log.h"
#include "resource.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Functions prototypes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject* func_logf (PyObject *, PyObject *);
PyObject* func_set_logfile_path (PyObject *, PyObject *);
PyObject* func_add_resource (PyObject *, PyObject *);
PyObject* func_remove_resource (PyObject *, PyObject *);
PyObject* func_has_resource (PyObject *, PyObject *);
PyObject* func_get_resource (PyObject *, PyObject *);
PyObject* func_get_resources (PyObject *, PyObject *);
PyObject* func_get_resource_value (PyObject *, PyObject *);
PyObject* func_has_config (PyObject *, PyObject *);
PyObject* func_set_config (PyObject *, PyObject *);
PyObject* func_get_config (PyObject *, PyObject *);
PyObject* func_remove_config (PyObject *, PyObject *);
PyObject* func_new_config_connection (PyObject *, PyObject *);
PyObject* func_new_config_transaction (PyObject *, PyObject *);
PyObject* func_subscribe (PyObject *, PyObject *);
PyObject* func_unsubscribe (PyObject *, PyObject *);

namespace
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    "logf",
    func_logf,
    METH_VARARGS,
    "Log event"
  },
  {
    "set_logfile_path",
    func_set_logfile_path,
    METH_VARARGS,
    "Set log file path"
  },
  {
    "add_resource",
    func_add_resource,
    METH_VARARGS,
    "Add resource"
  },
  {
    "remove_resource",
    func_remove_resource,
    METH_VARARGS,
    "Remove resource"
  },
  {
    "has_resource",
    func_has_resource,
    METH_VARARGS,
    "Check if resource exists"
  },
  {
    "get_resource",
    func_get_resource,
    METH_VARARGS,
    "Get resource"
  },
  {
    "get_resources",
    func_get_resources,
    METH_VARARGS,
    "Get resources"
  },
  {
    "get_resource_value",
    func_get_resource_value,
    METH_VARARGS,
    "Get resource value"
  },
  {
    "has_config",
    func_has_config,
    METH_VARARGS,
    "Check if config values exists"
  },
  {
    "set_config",
    func_set_config,
    METH_VARARGS,
    "Set config value"
  },
  {
    "get_config",
    func_get_config,
    METH_VARARGS,
    "Get config value"
  },
  {
    "remove_config",
    func_remove_config,
    METH_VARARGS,
    "Remove config value"
  },
  {
    "new_config_connection",
    func_new_config_connection,
    METH_VARARGS,
    "Create new connection object to config database"
  },
  {
    "new_config_transaction",
    func_new_config_transaction,
    METH_VARARGS,
    "Create new transaction object to config database"
  },
  {
    "subscribe",
    func_subscribe,
    METH_VARARGS,
    "Subscribe to event"
  },
  {
    "unsubscribe",
    func_unsubscribe,
    METH_VARARGS,
    "Unsubscribe from event"
  },
  {
    NULL,
    NULL,
    0,
    NULL
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Module definition structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyModuleDef module_def =
{
  PyModuleDef_HEAD_INIT,
  "mobius.core",
  "Mobius Forensic Toolkit mobius.core module",
  -1,
  module_methods,
  nullptr,
  nullptr,
  nullptr,
  nullptr
};

} // namespace

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Module initialization function
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
mobius::py::pymodule
new_core_module ()
{
  // Initialize module
  mobius::py::pymodule module (&module_def);

  // Add types
  module.add_type ("application", &core_application_t);
  module.add_type ("attribute", &core_attribute_t);
  module.add_type ("category_manager", &core_category_manager_t);
  module.add_type ("category", &core_category_t);
  module.add_type ("extension", &core_extension_t);
  module.add_type ("log", &core_log_t);
  module.add_type ("resource", &core_resource_t);

  // Build submodules
  //module.add_submodule ("xxx", new_xxx_submodule ());

  // Return module
  return module;
}
