# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2018 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Generic data holder
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class dataholder (object):
  pass

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief decode CDownloadBase structure
# @see DownloadBase.cpp - CDownloadBase::Serialize
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode (decoder, version):
  data = dataholder ()
  data.name = decoder.get_string ()
    
  if version >= 33:
    data.search_keyword = decoder.get_string ()
  else:
    data.search_keyword = None
      
  if version >= 29:
    data.size = decoder.get_qword ()
  else:
    data.size = decoder.get_dword ()

  data.hash_sha1 = decoder.get_hex_string (20)
  data.hash_sha1_trusted = decoder.get_dword () != 0
  data.hash_tiger = decoder.get_hex_string (24)
  data.hash_tiger_trusted = decoder.get_dword () != 0
    
  if version >= 22:
    data.hash_md5 = decoder.get_hex_string (16)
    data.hash_md5_trusted = decoder.get_dword () != 0
  else:
    data.hash_md5 = None
    data.hash_md5_trusted = None

  if version >= 13:
    data.hash_ed2k = decoder.get_hex_string (16)
    data.hash_ed2k_trusted = decoder.get_dword () != 0
  else:
    data.hash_ed2k = None
    data.hash_ed2k_trusted = None

  if version >= 37:
    data.hash_bth = decoder.get_hex_string (20)
    data.hash_bth_trusted = decoder.get_dword () != 0
  else:
    data.hash_bth = None
    data.hash_bth_trusted = None

  return data
