/* This file is part of the MPFRCPP Library.

  Copyright (c) 2006 -- 2007 Alexey V. Beshenov <bav.272304@gmail.com>.

  The MPFRCPP Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  The MPFRCPP Library is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the MPFRCPP Library; see the file COPYING.LIB. If
  not, write to the Free Software Foundation, Inc., 51 Franklin Street,
  Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file is.hpp
 * @date 2007-03-23
 * mpfrcpp::Real is... methods:
 * isInteger, isNaN, isInfinity, isNumber, isZero.
 * INTERNAL HEADER, NOT TO BE USED DIRECTLY.
 */

#ifndef INCLUDED_BY_MPFRCPP
    #error THIS IS AN INTERNAL HEADER ONLY, NOT TO BE USED DIRECTLY
#endif

#ifndef MPFRCPP_REAL_IS
#define MPFRCPP_REAL_IS

namespace mpfrcpp {

    //------------------------------------------------------------

    bool Real::isInteger () const throw() {
        return mpfr_integer_p( getMpfrT () ) != 0;
    }

    //------------------------------------------------------------

    bool Real::isNaN () const throw() {
        return mpfr_nan_p( getMpfrT () ) != 0;
    }

    //------------------------------------------------------------

    bool Real::isInfinity () const throw() {
        return mpfr_inf_p( getMpfrT () ) != 0;
    }

    //------------------------------------------------------------

    bool Real::isNumber () const throw() {
        return mpfr_number_p( getMpfrT () ) != 0;
    }

    //------------------------------------------------------------

    bool Real::isZero () const throw() {
        return mpfr_zero_p( getMpfrT () ) != 0;
    }

    //------------------------------------------------------------

}    // namespace mpfrcpp

#endif    // MPFRCPP_REAL_IS

