/* This file is part of the MPFRCPP Library.

   Copyright (c) 2006-2007 Alexey V. Beshenov <bav.272304@gmail.com>.

   The MPFRCPP Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of the
   License, or (at your option) any later version.

   The MPFRCPP Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the MPFRCPP Library; see the file COPYING.LIB. If
   not, write to the Free Software Foundation, Inc., 51 Franklin Street,
   Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file quick_start.cpp
 * @date 2007-04-01
 * Starting With the MPFRCPP Library
 * (translated from C source at http://www.mpfr.org/sample.html)
 * The following program computes a lower bound on 1 + 1/2! + ... + 1/100!
 * using 200-bit precision.
 */

#include "../misc/copyleft.hpp" // internal::copyleft();
#include <iostream>
#include <mpfrcpp/mpfrcpp.hpp>

using namespace std;
using namespace mpfr;

int main () {
    internal::copyleft();
    Library.setPrecision( Precision( 200 ) );
    cout << "Example of calculating a lower bound on 1 + 1/2! + ... + 1/100! with precision "
    << Library.getPrecision().getMpfrPrecT () << endl;
    cout << endl;

    Real s ( 1 ), t ( 1 ), u;
    for ( unsigned int i = 1; i <= 100; i++ ) {
        t = Mul( t, i, roundTowardInfinity );
        u = 1;
        u = Div( u, t, roundTowardNegInfinity );
        s = Add( s, u, roundTowardNegInfinity );
    }
    cout << "Sum is " <<
    s.toString ( -1, roundTowardNegInfinity ) << endl;
    cout << endl;
    return 0;
}

/*
 
The result of this program is:
 
   $ ./sample
   Sum is 2.7182818284590452353602874713526624977572470936999595749669131e+00
 
*/
