/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.nongnu.multigraph.Edge;

public class Node<N, L> {
    HashMap<Node<N, L>, HashMap<L, Edge<N, L>>> edgelist = new HashMap();
    HashMap<L, Edge<N, L>> label_edges = new HashMap();
    int edge_outdegree;
    final N unode;

    Node(N n) {
        this.unode = n;
    }

    void set(Node<N, L> node, int n, L l) {
        Edge<N, L> edge;
        HashMap<Object, Edge<N, L>> hashMap = this.edgelist.get(node);
        assert (node != null);
        assert (l != null);
        if (hashMap != null && (edge = hashMap.get(l)) != null) {
            edge.weight = n;
            return;
        }
        if (hashMap == null) {
            hashMap = new HashMap();
            this.edgelist.put(node, hashMap);
        }
        hashMap.put(l, new Edge<N, L>(this.unode, node.unode, n, l));
        ++this.edge_outdegree;
    }

    private boolean _remove(Node<N, L> node, L l, boolean bl) {
        HashMap<L, Edge<N, L>> hashMap = this.edgelist.get(node);
        assert (node != null);
        if (hashMap == null) {
            return false;
        }
        if (l != null && hashMap.remove(l) != null) {
            assert (this.edge_outdegree > 0);
            --this.edge_outdegree;
            return true;
        }
        if (!bl) {
            return false;
        }
        this.edge_outdegree -= hashMap.size();
        hashMap.clear();
        return this.edgelist.remove(node) != null;
    }

    boolean remove(Node<N, L> node, L l) {
        assert (node != null);
        assert (l != null);
        return this._remove(node, l, false);
    }

    boolean remove(Node<N, L> node) {
        assert (node != null);
        return this._remove(node, null, true);
    }

    int nodal_outdegree() {
        return this.edgelist.size();
    }

    Collection<HashMap<L, Edge<N, L>>> edgelist() {
        return this.edgelist.values();
    }

    Set<Edge<N, L>> edges() {
        HashSet<Edge<N, L>> hashSet = new HashSet<Edge<N, L>>();
        for (HashMap<L, Edge<N, L>> hashMap : this.edgelist()) {
            for (Edge<N, L> edge : hashMap.values()) {
                hashSet.add(edge);
            }
        }
        return hashSet;
    }

    Collection<Edge<N, L>> edges(Node<N, L> node) {
        if (node == null) {
            throw new NullPointerException("Node get requires non-null argument");
        }
        HashMap<L, Edge<N, L>> hashMap = this.edgelist.get(node);
        if (hashMap == null) {
            return null;
        }
        return hashMap.values();
    }

    boolean isLinked(Node<N, L> node) {
        if (node == null) {
            throw new NullPointerException("Node get requires non-null argument");
        }
        return this.edgelist.containsKey(node);
    }

    public String toString() {
        return this.unode.toString();
    }
}

