<?php

/**
 * Autogenerated file 
 *   This file is part of NOALYSS.
 *
 *   NOALYSS is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   NOALYSS is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with NOALYSS; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
require_once NOALYSS_INCLUDE.'/database/class_noalyss_sql.php';
require_once NOALYSS_INCLUDE.'/lib/class_database.php';

/**
 * class_file_csv_sql.php
 *
 * @file
 * @brief abstract of the table importcard.file_csv 
 *Name of the uploaded file , use to avoid to reload several time the same file 
 */
class Impcard_File_Csv_SQL extends Noalyss_SQL
{

    function __construct(Database $p_cn, $p_id=-1)
    {
        $this->table="importcard.file_csv";
        $this->primary_key="id";
        /*
         * List of columns
         */
        $this->name=array(
            "id"=>"id"
            , "file_name"=>"file_name"
            , "file_timestamp"=>"file_timestamp"
        );
        /*
         * Type of columns
         */
        $this->type=array(
            "id"=>"numeric"
            , "file_name"=>"text"
            , "file_timestamp"=>"timestamp with time zone"
        );


        $this->default=array(
            "id"=>"auto",
            "file_timestamp"=>"auto"
        );

        $this->date_format="DD.MM.YYYY";
        parent::__construct($p_cn, $p_id);
    }

}
