/************************************************************************
 *                                                                      *
 * Open File Manager - ncurses file manager for GNU/Linux               *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski                *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/

#ifndef __OFM_FILDIR__
#define __OFM_FILDIR__

#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <curses.h>
#ifndef PATH_MAX
    #define PATH_MAX 4095
#endif

/* definitions for dirProcess */

/* allocated unit for storing ds */

#define DP_DIR_DEEP_LEVEL	100

/* given entry is the file */

#define DP_FILE 		1	//podany wpis jest plikiem

/* directory after input */

#define DP_DIRIN 		2	//katalogiem po wejsciu

/* directory after output */

#define DP_DIROUT		3

#define DP_BREAK_NORMAL		1
#define DP_BREAK_DEST_NO_EXIST	2

/* number of available sort modes */

#define SORT_MODES	4
#define SORT_UNSORTED	0
#define	SORT_NAME	1
#define	SORT_DIR_FIRST	2
#define SORT_SIZE	3

typedef struct dirstruct{  
	char *path;         //field for bookmarks
	char *name; 
	short mode;
	short uid;
	short gid;
	unsigned long size;
	bool corrupt;
	bool exe;
	bool link;
	bool dir;
	bool selected;
	time_t atime;
	time_t mtime;
	time_t ctime;
	struct dirstruct *next;
	struct dirstruct *prev;	  
	struct dirstruct *first;
	struct dirstruct *last;
	unsigned long dir_count;
	unsigned long files_count;
	unsigned long index;
} DirStruct;


/* isn't changing directory, you should watch out for it!!! */

DirStruct	*dirSuck(char *dname);
DirStruct	*dirDuplicate(DirStruct *ds);
int 		dirFree(DirStruct *dst);
DirStruct 	*dirSort(DirStruct *dst, int mode, int keep_prev);
DirStruct 	*dirFind(DirStruct *ds, char *name);
int 		dirProcess(DirStruct *ds, void (*fptr)(DirStruct *,int) ,int all);
void 		dirProcessBreak(int errno);
DirStruct	*dirDuplicate(DirStruct *ds);

#endif /* __OFM_FILDIR_ */

