/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.component2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import opale.m2d.CoordSystem;
import opale.m2d.GAxis2D;
import opale.m2d.InfoAxis;
import opale.m2d.LinLinCS;
import opale.m2d.OIJ;
import opale.m2d.Pack2D;
import opale.m2d.Pen2D;

class JPanel2D
extends JPanel
implements MouseListener,
MouseMotionListener {
    private boolean modeZoom;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private Image buffer;
    private Pack2D pack;
    private CoordSystem vue = new LinLinCS(OIJ.OIJ_ABSOLUTE, 0, 0, this.getWidth(), this.getHeight());
    private GAxis2D axes = new GAxis2D(this.vue);

    public JPanel2D() {
        super.setBackground(Color.white);
        this.axes.drawLabel(false);
        ((InfoAxis)this.axes.getInfo()).setTick(0.0, 1.0, 0.0, 1.0);
        this.pack = new Pack2D();
        this.pack.add(OIJ.OIJ_ABSOLUTE, "oij_abs");
        this.modeZoom = false;
        this.vue.setSize(20, 20, this.getWidth() - 40, this.getHeight() - 40);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JPanel2D.this.buffer = JPanel2D.this.createImage(JPanel2D.this.getWidth(), JPanel2D.this.getHeight());
                JPanel2D.this.vue.setSize(20, 20, JPanel2D.this.getWidth() - 40, JPanel2D.this.getHeight() - 40);
                JPanel2D.this.vue.autoadjust();
                JPanel2D.this.redraw();
                JPanel2D.this.repaint();
            }
        });
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Pack2D getPack2D() {
        return this.pack;
    }

    public void setPack2D(Pack2D pack2D) {
        this.pack = pack2D;
    }

    public GAxis2D getAxis() {
        return this.axes;
    }

    public CoordSystem getCS() {
        return this.vue;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.modeZoom = true;
        this.x1 = this.x2 = mouseEvent.getX();
        this.y1 = this.y2 = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        double d;
        this.modeZoom = false;
        if (this.x2 <= this.x1 || this.y2 <= this.y1) {
            return;
        }
        double d2 = this.vue.xfromXY(this.x1, this.y1);
        double d3 = this.vue.yfromXY(this.x1, this.y1);
        double d4 = this.vue.xfromXY(this.x2, this.y2);
        double d5 = this.vue.yfromXY(this.x2, this.y2);
        if (d2 > d4) {
            d = d4;
            d2 = d4;
            d4 = d;
        }
        if (d5 > d3) {
            d = d3;
            d5 = d3;
            d3 = d;
        }
        this.vue.set(d2, d4, d5, d3);
        this.vue.autoadjust();
        Graphics graphics = this.buffer.getGraphics();
        int n = this.buffer.getHeight(null);
        int n2 = this.buffer.getWidth(null);
        graphics.clearRect(0, 0, n2, n);
        graphics.drawRect(5, 5, n2 - 10, n - 10);
        Pen2D pen2D = new Pen2D(graphics, this.vue);
        this.axes.draw(pen2D);
        pen2D.clip();
        this.pack.draw(pen2D);
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.modeZoom) {
            Graphics graphics = this.getGraphics();
            this.repaint();
            this.x2 = mouseEvent.getX();
            this.y2 = mouseEvent.getY();
            graphics.drawRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
        }
    }

    void redraw() {
        Graphics graphics = this.buffer.getGraphics();
        int n = this.buffer.getHeight(null);
        int n2 = this.buffer.getWidth(null);
        graphics.clearRect(0, 0, n2, n);
        graphics.drawRect(5, 5, n2 - 10, n - 10);
        Pen2D pen2D = new Pen2D(graphics, this.vue);
        this.axes.draw(pen2D);
        pen2D.clip();
        this.pack.draw(pen2D);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.drawImage(this.buffer, 0, 0, null);
    }
}

