/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import java.io.PrintWriter;
import opale.ode.StepsizeControl;
import opale.ode.TimeScheme;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.StreamReader;

public final class StandardStepControl
extends StepsizeControl {
    private double tol;

    public StandardStepControl() {
        this.tol = 0.001;
    }

    public StandardStepControl(TimeScheme timeScheme) {
        super(timeScheme);
        this.tol = 0.001;
    }

    public StandardStepControl(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The tolerance must be positive.");
        }
        this.tol = d;
    }

    public final boolean update() {
        double d = this.getTS().errorEstimate();
        if (d > 1.2 * this.tol) {
            double d2 = this.getTS().dt() * Math.sqrt(0.9 * this.tol / d);
            this.getTS().dt(d2);
            return false;
        }
        return true;
    }

    public int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("tol")) {
            this.tol = streamReader.nextDouble();
            return 0;
        }
        return -1;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) {
        printWriter.println("{");
        printWriter.println("tol " + this.tol);
        printWriter.println("}");
    }
}

