/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d;
import opale.tools.*;
import java.io.*;

/**
* This abstract class is the root of the class hierarchy that represents an object 2D.
* @since Opale-2d 0.15, Elle tend la classe OpaleObject 
* @author OC
* @since Opale-2d 0.1
*/
public abstract class Object2D extends OpaleObject implements Cloneable
{
private OIJ rep;	//Tout objet 2d est dfini dans un repre OIJ.
/**
* Constructs and initializes with the absolute OIJ.
*/
public Object2D()
	{
	this.rep = OIJ.OIJ_ABSOLUTE;
	}
	
/**
* Constructs and initialize with an specified OIJ.
* @param OIJ rep, an instance of <code>OIJ</code>.
*/
public Object2D(OIJ rep)
	{
	this.rep = rep;
	}

/**
* Sets the OIJ basis of this object.
* @param OIJ rep,  the new OIJ.
*/
public void setOIJ(OIJ rep)
	{
	this.rep = rep;
	}
	
	
/**
* Return the instance <code>OIJ</code> of this object.
* @return OIJ rep, the basis of this object.
*/
public OIJ getOIJ()
	{
	return rep;
	}
	
/**
* Creates a new object of the same class and with the same contents as this vector.
* @return Object, a clone of this instance.
* @exception  OutOfMemoryError if there is not enough memory.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	/*try
		{*/
		Object2D obj = (Object2D) super.clone();
		obj.rep = rep;
		return obj;
		/*}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
		throw new InternalError(""+e);
		}*/
    }


	
/**
* Compute the changement of OIJ for this object.
* @param OIJ rep, the new OIJ.
*/	
public abstract void changeOIJ(OIJ rep);


/**
* Returns a string representation of this object.
*/
public abstract String toString();

/**
* Writes informations about this object in a stream.
* @param WFile f, the file in writing.
*/
public void write(PrintWriter f,OpaleSet pack) throws InvalidFormatException
	{
	f.println("{");
	if (rep == OIJ.OIJ_ABSOLUTE) f.println("OIJ OIJ_ABSOLUTE");
	else {
	if (!pack.contains(getOIJ())) throw new InvalidFormatException("Error writing the file "+f+" : the OIJ "+getOIJ()+" doesn't exist !!");
	f.println("OIJ "+getOIJ().getId());
	}
	writeMore(f,pack);
	f.println("}");
	}
/**
* Write complementary information in a stream.
* @param WFile f, the file in writing .
*/
public abstract void writeMore(PrintWriter f,OpaleSet pack) throws InvalidFormatException;
		


/**
* Reads in a stream the construction of this object calling the method <code>readKeyWord().</code>
* @param StreamReader f, the file to read.
* @prama Pack2D p, instance of <code>Pack2D</code> that contains the requiered objects (OIJ, others objects 2d...).
*/
public void read(StreamReader f,OpaleSet pack) throws java.io.IOException,InvalidFormatException
	{
	int type;
	OIJ lerepere=null;

	String sval = f.next();	//on lit la premiere '{'
	if ( !sval.equals("{") ) throw new InvalidFormatException("Stream of data non valid !!");
	while ( !((sval = f.next()).equals("}")))
		{
		//if (Debug.On) Debug.print(sval);
		if (sval.equals("OIJ"))
			{
			sval = f.next();
			if (sval.equals("OIJ_ABSOLUTE"))
				lerepere = OIJ.OIJ_ABSOLUTE;
			else {
			if (Debug.On) Debug.print("Dans Object2D : "+pack.contains(sval));
			if (Debug.On) Debug.print("Dans Object2D : "+pack.getObject(sval));
			if ( (!pack.contains(sval)) || (pack.getObject(sval)) == null) throw new InvalidFormatException("Data file "+f+" is wrong  : the identifiant "+sval+" doesn't exist !!");
			if (pack.getObject(sval) instanceof OIJ) lerepere = (OIJ) pack.getObject(sval);
			else throw new InvalidFormatException("Data file "+f+" is non valid  : the identifiant "+sval+" is not a OIJ !!");
			}
			} 
			
		else if (readKeyWord(sval,f,pack) == -1) throw new InvalidFormatException("Data file "+f+" is non valid   : error reading a keyword "+sval+" !!");
		}
	if (lerepere == null) throw new InvalidFormatException("No OIJ for this object !!"+this);
	setOIJ(lerepere);
	
	
	}

/**
* Returns the maximum of the X coordinate.
* @return double, X maximum.
*/
// A FAIRE !!!! //
public double xmax() {return 0;};
}
