/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d.component2d;

import opale.m2d.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;

/**
* This class represents an graphical editor for the properties associated to the class opale.m2d.DefaultGraphicalOptions.
* @since Opale-2d 0.18
*/

public class DefaultStyleEditor extends JFrame
{
private DefaultGraphicalOptions options;


private static String[] marktype = {
	"Classic point", "ClassicPoint",
	"Circle", "CirclePoint",
	"Diamond", "DiamondPoint",
	"Horizontal line", "HLine",
	"Vertical line", "VLine",
	"Horizontal+Vertical lines", "HVLine",
	"Square", "SquarePoint",
	"X", "XPoint",
	"Triangle up", "TriangleUp",
	"Triangle down", "TriangleDown",
	"Triangle left", "TriangleLeft",
	"Triangle right", "TriangleRight"
	};



  JPanel jPanelVisible = new JPanel();
  JPanel jPanelSud = new JPanel();
  JLabel jLabelTitreFx = new JLabel();
  JButton jButtonOk = new JButton();
  JPanel jPanelMain = new JPanel();
  JButton jButtonAnn = new JButton();
  GridLayout gridLayout1 = new GridLayout();
  JPanel jPanelNord = new JPanel();
  BorderLayout borderLayout1 = new BorderLayout();
  JButton jButtonAppl = new JButton();
  JList jList2 = new JList();
  JPanel jPanelMark = new JPanel();
  JLabel jLabelMark = new JLabel();
  JCheckBox jCheckBoxVisible = new JCheckBox();
  JComboBox jComboBoxMark = new JComboBox();
  JLabel jLabelColor = new JLabel();
  JButton jButtonColor = new JButton();
  JLabel jLabelSize = new JLabel();
  JTextField jTextFieldSize = new JTextField();

  public DefaultStyleEditor() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
  setSize(450,200);
    jPanelSud.setBorder(BorderFactory.createRaisedBevelBorder());
    jLabelTitreFx.setText("Graphical Options Editor");
    jLabelTitreFx.setFont(new java.awt.Font("Dialog", 3, 18));
    jButtonOk.setText("Ok");
    jButtonOk.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonOk_actionPerformed(e);
      }
    });
    jPanelMain.setLayout(gridLayout1);
    jPanelMain.setBorder(BorderFactory.createRaisedBevelBorder());
    jButtonAnn.setText("Cancel");
    jButtonAnn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonAnn_actionPerformed(e);
      }
    });
    gridLayout1.setRows(2);
    gridLayout1.setColumns(1);
    jPanelNord.setBorder(BorderFactory.createRaisedBevelBorder());
    jButtonAppl.setText("Apply");
    jButtonAppl.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonAppl_actionPerformed(e);
      }
    });
    jList2.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    jLabelMark.setFont(new java.awt.Font("Monospaced", 1, 12));
    jLabelMark.setText("Mark type = ");

    for (int i=0;i<marktype.length/2;i++)
    jComboBoxMark.addItem(marktype[2*i]);


    jCheckBoxVisible.setText("Visible");
    jCheckBoxVisible.setForeground(new Color(102, 102, 153));
    jCheckBoxVisible.setFont(new java.awt.Font("Monospaced", 1, 12));
    jLabelColor.setText("Color = ");
    jLabelColor.setFont(new java.awt.Font("Monospaced", 1, 12));
    jButtonColor.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonColor_actionPerformed(e);
      }
    });
    jLabelSize.setFont(new java.awt.Font("Monospaced", 1, 12));
    jLabelSize.setText("Size = ");
    jTextFieldSize.setText("0");
    jTextFieldSize.setColumns(3);
    this.getContentPane().add(jPanelSud, BorderLayout.SOUTH);
    jPanelSud.add(jButtonOk, null);
    jPanelSud.add(jButtonAppl, null);
    jPanelSud.add(jButtonAnn, null);
    this.getContentPane().add(jPanelMain, BorderLayout.CENTER);
    jPanelMain.add(jPanelVisible, null);
    jPanelVisible.add(jCheckBoxVisible, null);
    jPanelVisible.add(jLabelColor, null);
    jPanelVisible.add(jButtonColor, null);
    jPanelMain.add(jPanelMark, null);
    jPanelMark.add(jLabelMark, null);
    jPanelMark.add(jComboBoxMark, null);
    jPanelMark.add(jList2, null);
    jPanelMark.add(jLabelSize, null);
    jPanelMark.add(jTextFieldSize, null);
    this.getContentPane().add(jPanelNord, BorderLayout.NORTH);
    jPanelNord.add(jLabelTitreFx, null);
  }
  
  
  public void setOptions(DefaultGraphicalOptions d)
  {
  options = d;
  initOptions();
  }
  
  private String find(String s)
  	{
	for (int i=0;i<marktype.length/2;i++)
		{
		if (("opale.m2d.marktype."+marktype[2*i+1]).equals(s)) return marktype[2*i]; 
		}
	return null;
	}
  private String find2(String s)
  	{
	for (int i=0;i<marktype.length/2;i++)
		{
		if ((marktype[2*i]).equals(s)) return "opale.m2d.marktype."+marktype[2*i+1]; 
		}
	return null;
	}
  
public  void initOptions()
  {
  jButtonColor.setBackground(options.getColor());
  jCheckBoxVisible.setSelected(options.isVisible());
  String mark = options.getMarktype().getClass().getName();
  jComboBoxMark.setSelectedItem(mark);
  jTextFieldSize.setText(""+options.getMarktype().getMarksize());
  }
  
  
public  void applyOptions()
  {
  options.setColor(jButtonColor.getBackground());
  if (jCheckBoxVisible.isSelected()) options.setVisible();
  else options.setUnvisible();
	
	try{
	  
  MarkType mt = (MarkType) Class.forName(find2((String) jComboBoxMark.getSelectedItem())).newInstance();
  mt.setMarksize(Integer.parseInt(jTextFieldSize.getText()));
  options.setMarktype(mt);
  
	}
	catch(ClassNotFoundException exc)
	{
	System.err.println(exc);
	System.err.println("Report the bug to the Opale team");
	System.exit(-1);
	}
	catch(IllegalAccessException exc)
	{
	System.err.println(exc);
	System.err.println("Report the bug to the Opale team");
	System.exit(-1);
	}
	catch(InstantiationException exc)
	{
	System.err.println(exc);
	System.err.println("Report the bug to the Opale team");
	System.exit(-1);
	}
  
  
  }
  
protected    void jButtonOk_actionPerformed(ActionEvent e) {
	applyOptions();
	dispose();
  }
protected    void jButtonAnn_actionPerformed(ActionEvent e) {
	dispose();
  }
protected    void jButtonColor_actionPerformed(ActionEvent e) {
  Color c = JColorChooser.showDialog(this,"Color editor",jButtonColor.getBackground());
  if (c!=null) jButtonColor.setBackground(c);
  }


protected  void jButtonAppl_actionPerformed(ActionEvent e) {
	applyOptions();

  }

  public static void main(String[] arg)
  {
  DefaultStyleEditor ed = new DefaultStyleEditor();
  ed.show();

  }

}
