/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.mathtools;
import opale.tools.*;
import opale.mathtools.parser.*;

import java.io.*;
import java.util.*;

/**
* This class extends IyFx and makes it possible to define an analytic function from a string represention of its analytical expression. 
* @since Opale-Mathtools 0.18
*/
public class AnalyticalFunction extends OpaleObject implements IyFx
{
private String fonc;
private Parser parser;
private double resu;


public AnalyticalFunction()
{
super();
}


/**
* Set the string representation of the function to be evaluate. The variable that  must be used is "x". 
*/
public void setFunc(String f)
	{
	parser = new Parser();
	fonc = new String();
	parser.addVar("x");
	parser.parseString(f);	
	fonc = new String(f);
	
	}

/**
* Returns the string representation of the function.
* @return String 
*/
public String getFunc()
	{
	return fonc;
	}


public double val(double x)
	{
	parser.setVar("x",x);
	resu = parser.eval();
	return resu;
	}

public String toString()
	{
	String s="";
	s = "f(x) = "+fonc;
	return s;
	}	
	
public void write(PrintWriter f, OpaleSet ode) 
	{
	int i;
	f.println("{");
	f.println("f(x)= '"+fonc+"'");
	f.println("}");
	}
	

public int readKeyWord(String word,StreamReader f,OpaleSet ode)  throws java.io.IOException, InvalidFormatException
	{
	int type,i;
	if ( word.equals("f(x)="))
		{
		String sval =  f.next();
		if (!( sval.endsWith("'") && sval.startsWith("'")))  throw new InvalidFormatException("Error reading the function "+sval+". The function must be bracketed between ''");
		String s = new String(sval.substring(1,sval.length()-1));
		try {
		setFunc(s);
		}
		catch(ParseFunctionException e)
			{
			throw new InvalidFormatException("Error reading the function "+s);
			}
		return 0;
		}
	return -1;
		
	}
	
	
	
}
